/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/ui/branch/GitCheckoutAndRebaseRemoteBranchWorkflow;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "brancher", "Lgit4idea/branch/GitBrancher;", "kotlin.jvm.PlatformType", "createBranch", "", "name", "", "startPoint", "force", "", "doCreateNewBranch", "reset", "execute", "options", "Lgit4idea/branch/GitNewBranchOptions;", "intellij.vcs.git"})
public final class GitCheckoutAndRebaseRemoteBranchWorkflow {
    private final GitBrancher brancher;
    private final Project project;
    private final List<GitRepository> repositories;

    public final void execute(@NotNull String startPoint, @NotNull GitNewBranchOptions options) {
        int result2;
        boolean bl;
        boolean reset;
        String name;
        block5: {
            Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            name = options.getName();
            reset = options.shouldReset();
            Iterable $this$any$iv = this.repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getCurrentBranchName(), (Object)name)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            VcsNotifier.getInstance((Project)this.project).notifyError("git.branch.operation.error", GitBundle.message("branches.checkout.and.rebase.failed", new Object[0]), GitBundle.message("branches.checkout.and.rebase.error.current.with.same.name", name));
            return;
        }
        boolean localHasMoreCommits = GitBranchCheckoutOperation.Companion.checkLocalHasMoreCommits$intellij_vcs_git(this.project, this.repositories, name, startPoint);
        if (localHasMoreCommits && (reset ? (result2 = Messages.showYesNoDialog((String)GitBundle.message("branches.create.with.reset.local.has.more.commits", name, startPoint), (String)GitBundle.message("checkout.0", startPoint), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null)) != 0 : (result2 = Messages.showYesNoDialog((String)GitBundle.message("branches.create.local.has.more.commits", name, startPoint), (String)GitBundle.message("checkout.0", startPoint), (String)GitBundle.message("new.branch.dialog.operation.create.name", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null)) != 0)) {
            return;
        }
        new Task.Backgroundable(this, name, startPoint, reset, this.project, GitBundle.message("branches.checkout.and.rebase.onto.current.process", startPoint), true){
            final /* synthetic */ GitCheckoutAndRebaseRemoteBranchWorkflow this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $startPoint;
            final /* synthetic */ boolean $reset;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    indicator.setText2(GitBundle.message("branch.creating.branch.process", this.$name));
                    GitCheckoutAndRebaseRemoteBranchWorkflow.access$doCreateNewBranch(this.this$0, this.$startPoint, this.$name, this.$reset);
                }
                catch (Exception e) {
                    GitBranchUiHandlerImpl gitBranchUiHandlerImpl = new GitBranchUiHandlerImpl(this.getProject(), indicator);
                    String string = GitBundle.message("create.branch.operation.could.not.create.new.branch", this.$name);
                    String string2 = e.getMessage();
                    Intrinsics.checkNotNull((Object)string2);
                    gitBranchUiHandlerImpl.notifyError(string, string2);
                }
                indicator.setText2(GitBundle.message("branch.rebasing.process", this.$name));
                GitCheckoutAndRebaseRemoteBranchWorkflow.access$getBrancher$p(this.this$0).rebaseOnCurrent(GitCheckoutAndRebaseRemoteBranchWorkflow.access$getRepositories$p(this.this$0), this.$name);
            }
            {
                this.this$0 = this$0;
                this.$name = $captured_local_variable$1;
                this.$startPoint = $captured_local_variable$2;
                this.$reset = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private final void doCreateNewBranch(String startPoint, String name, boolean reset) {
        void reposWithLocalBranch;
        Iterable $this$partition$iv = this.repositories;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            if (it.getBranches().findLocalBranch(name) != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Object object = new Pair(first$iv, second$iv);
        List list2 = (List)object.component1();
        List reposWithoutLocalBranch = (List)object.component2();
        object = (Collection)reposWithLocalBranch;
        if (!object.isEmpty() && reset) {
            this.createBranch(name, startPoint, (List<? extends GitRepository>)reposWithLocalBranch, true);
        }
        if (!(object = (Collection)reposWithoutLocalBranch).isEmpty()) {
            this.createBranch(name, startPoint, reposWithoutLocalBranch, false);
        }
    }

    private final void createBranch(String name, String startPoint, List<? extends GitRepository> repositories, boolean force) {
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
        Git git2 = git;
        for (GitRepository gitRepository : repositories) {
            GitCommandResult result2;
            Intrinsics.checkNotNullExpressionValue((Object)git2.branchCreate(gitRepository, name, startPoint, force), (String)"git.branchCreate(reposit\u2026 name, startPoint, force)");
            if (result2.success()) {
                gitRepository.update();
                continue;
            }
            throw (Throwable)new IllegalStateException(result2.getErrorOutputAsHtmlString());
        }
    }

    public GitCheckoutAndRebaseRemoteBranchWorkflow(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        this.project = project;
        this.repositories = repositories;
        this.brancher = GitBrancher.getInstance(this.project);
        Collection collection = this.repositories;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public static final /* synthetic */ void access$doCreateNewBranch(GitCheckoutAndRebaseRemoteBranchWorkflow $this, String startPoint, String name, boolean reset) {
        $this.doCreateNewBranch(startPoint, name, reset);
    }

    public static final /* synthetic */ GitBrancher access$getBrancher$p(GitCheckoutAndRebaseRemoteBranchWorkflow $this) {
        return $this.brancher;
    }

    public static final /* synthetic */ List access$getRepositories$p(GitCheckoutAndRebaseRemoteBranchWorkflow $this) {
        return $this.repositories;
    }
}

