/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageTracker;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\t\u001a\u00020\u0006\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"PROCESSED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "status", "Lgit4idea/index/GitFileStatus;", "Lgit4idea/index/GitStageTracker;", "root", "intellij.vcs.git"})
public final class GitStageTrackerKt {
    private static final Key<Boolean> PROCESSED;

    @Nullable
    public static final VirtualFile getRoot(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof GitIndexVirtualFile ? ((GitIndexVirtualFile)file).getRoot() : (file.isInLocalFileSystem() ? ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file) : null);
    }

    @Nullable
    public static final GitFileStatus status(@NotNull GitStageTracker $this$status, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"$this$status");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = GitStageTrackerKt.getRoot($this$status.getProject(), file);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return GitStageTrackerKt.status($this$status, root, file);
    }

    @Nullable
    public static final GitFileStatus status(@NotNull GitStageTracker $this$status, @NotNull VirtualFile root, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"$this$status");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = GitIndexVirtualFileKt.filePath(file);
        Object object = (GitRepository)GitRepositoryManager.getInstance($this$status.getProject()).getRepositoryForRootQuick(root);
        if (object != null && (object = object.getIgnoredFilesHolder()) != null) {
            if (((GitRepositoryIgnoredFilesHolder)object).containsFile(filePath)) {
                return GitFileStatusKt.ignoredStatus(filePath);
            }
        }
        GitStageTracker.RootState rootState = $this$status.getState().getRootStates().get(root);
        if (rootState == null) {
            return null;
        }
        GitStageTracker.RootState rootState2 = rootState;
        if (!rootState2.getInitialized()) {
            return null;
        }
        GitFileStatus gitFileStatus = rootState2.getStatuses().get(filePath);
        if (gitFileStatus == null) {
            return GitFileStatusKt.notChangedStatus(filePath);
        }
        return gitFileStatus;
    }

    static {
        Key key = Key.create((String)"GitStageTracker.file.processed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Boolean>(\"Git\u2026eTracker.file.processed\")");
        PROCESSED = key;
    }

    public static final /* synthetic */ Key access$getPROCESSED$p() {
        return PROCESSED;
    }
}

