/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformer;
import org.jetbrains.idea.perforce.perforce.login.LoginState;

public class LoginPerformerImpl
implements LoginPerformer {
    private static final Logger LOG = Logger.getInstance(LoginPerformerImpl.class);
    @NonNls
    private static final String LOGGED_IN_MESSAGE = "logged in";
    @NonNls
    private static final String NAVIGATE_MESSAGE = "Navigate to URL";
    @NonNls
    private static final String CONNECT_FAILED = "Connect to server failed; check $P4PORT.";
    @NonNls
    private static final String CONNECTION_REFUSED = "Connection refused";
    @NonNls
    private static final String SSO_REQUIRED = "ssoAuth required";
    @NonNls
    private static final String SSO_OPTIONAL = "ssoAuth optional";
    private final P4Connection myConnection;
    private final PerforceSettings mySettings;
    private static final Pattern ourTicketExpiresPattern = Pattern.compile("User (.*) ticket expires in\\s+((\\d*)\\s+hours\\s+)?(\\d+)\\s+minutes.*", 32);
    private final PerforceConnectionManagerI myConnectionManager;
    private String myRecentCredentials;

    public LoginPerformerImpl(Project project, P4Connection connection, PerforceConnectionManagerI connectionManagerI) {
        this.mySettings = PerforceSettings.getSettings(project);
        this.myConnectionManager = connectionManagerI;
        this.myConnection = connection;
    }

    @Override
    public LoginState getLoginState() {
        try {
            ExecResult result = this.myConnection.runP4CommandLine(this.mySettings, new String[]{"login", "-s"}, null);
            if (result.getExitCode() != 0) {
                Throwable exception;
                String stdErr = result.getStderr();
                if (stdErr.contains(CONNECT_FAILED) || stdErr.contains(CONNECTION_REFUSED) || stdErr.contains("No route to host")) {
                    return new LoginState(false, -1L, stdErr);
                }
                if (StringUtil.isEmpty((String)stdErr) && (exception = result.getException()) != null) {
                    return new LoginState(false, -1L, exception.getMessage());
                }
                return new LoginState(false, -1L, null);
            }
            String stdOut = result.getStdout();
            return LoginPerformerImpl.tryParseTicketExpiresTime(stdOut);
        }
        catch (VcsException e) {
            if (e.getCause() instanceof PerforceTimeoutException) {
                return new LoginState(false, -1L, e.getMessage());
            }
            return new LoginState(false, -1L, null);
        }
    }

    @NotNull
    private static LoginState tryParseTicketExpiresTime(@NotNull String stdOut) {
        Matcher matcher;
        if (stdOut == null) {
            LoginPerformerImpl.$$$reportNull$$$0(0);
        }
        if ((matcher = ourTicketExpiresPattern.matcher(stdOut)).matches()) {
            String hours = matcher.group(3);
            String minutes = matcher.group(4);
            if (minutes != null) {
                try {
                    long hoursInt = hours != null ? (long)Integer.parseInt(hours) : 0L;
                    int minutesInt = Integer.parseInt(minutes);
                    return new LoginState(true, (hoursInt * 60L + (long)minutesInt) * 60L * 1000L, null);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new LoginState(true, -1L, null);
    }

    @TestOnly
    @NotNull
    public static LoginState parseExpirationTicket(@NotNull String stdOut) {
        if (stdOut == null) {
            LoginPerformerImpl.$$$reportNull$$$0(1);
        }
        return LoginPerformerImpl.tryParseTicketExpiresTime(stdOut);
    }

    @Override
    public boolean isCredentialsChanged() {
        if (!this.mySettings.useP4CONFIG) {
            return true;
        }
        if (!Objects.equals(this.mySettings.getPasswd(), this.myRecentCredentials)) {
            this.myRecentCredentials = this.mySettings.getPasswd();
            return true;
        }
        return false;
    }

    @Override
    public LoginState login(@NotNull String password) {
        if (password == null) {
            LoginPerformerImpl.$$$reportNull$$$0(2);
        }
        try {
            StringBuffer data = new StringBuffer();
            data.append(password);
            ExecResult loginResult = this.myConnection.runP4CommandLine(this.mySettings, new String[]{"login"}, data);
            String stdOut = loginResult.getStdout();
            String stdErr = loginResult.getStderr();
            if (stdErr.length() > 0 && !stdErr.contains(NAVIGATE_MESSAGE) || !stdOut.contains(LOGGED_IN_MESSAGE)) {
                Object message;
                Object object = message = !stdOut.isEmpty() && !stdErr.isEmpty() ? stdOut + "\n" + stdErr : stdOut + stdErr;
                if (StringUtil.isEmptyOrSpaces((String)message) && loginResult.getException() != null) {
                    message = loginResult.getException().getMessage();
                }
                LOG.debug("Login failed, message: " + (String)message);
                return new LoginState(false, -1L, (String)message);
            }
            this.myConnectionManager.updateConnections();
            return new LoginState(true, -1L, null);
        }
        catch (VcsException e) {
            if (e.getCause() instanceof PerforceTimeoutException) {
                return new LoginState(false, -1L, e.getMessage());
            }
            return new LoginState(false, -1L, null);
        }
    }

    @Override
    public LoginState loginWithStoredPassword() {
        String password;
        if (this.isSSOAuthRequired()) {
            return this.login("");
        }
        String string = password = this.myConnection instanceof P4ParametersConnection ? ((P4ParametersConnection)this.myConnection).getParameters().getPassword() : this.mySettings.getPasswd();
        if (StringUtil.isNotEmpty((String)password)) {
            return this.login(password);
        }
        return new LoginState(false, -1L, null);
    }

    @Override
    public P4Connection getMyConnection() {
        return this.myConnection;
    }

    private boolean isSSOAuthRequired() {
        try {
            ExecResult infoResult = this.myConnection.runP4CommandLine(this.mySettings, new String[]{"-ztag"}, new String[]{"info"}, null);
            String infoStr = infoResult.getStdout();
            if (infoStr.contains(SSO_REQUIRED) || infoStr.contains(SSO_OPTIONAL)) {
                LOG.debug("Login: ssoAuth enabled");
                return true;
            }
        }
        catch (VcsException e) {
            LOG.warn("Failed to fetch ssoAuth status from 'p4 info': " + e.getMessage());
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdOut";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/login/LoginPerformerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryParseTicketExpiresTime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseExpirationTicket";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "login";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

