/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J0\u0010\r\u001a\u00020\u00072\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\r\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J0\u0010\u0015\u001a\u00020\u00072\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\u0016\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00130\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J0\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001dH\u0002J&\u0010\u001e\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/perforce/actions/ShelfUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "browseShelf", "", "project", "Lcom/intellij/openapi/project/Project;", "shelvedChanges", "", "Lorg/jetbrains/idea/perforce/application/ShelvedChange;", "deleteFromShelf", "paths", "Lcom/intellij/util/containers/MultiMap;", "Lkotlin/Pair;", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "", "", "changes", "doUnshelve", "groupByChangeList", "selected", "handleUnshelveException", "connection", "unshelveException", "Lcom/intellij/openapi/vcs/VcsException;", "specs", "", "unshelveChanges", "delete", "", "intellij.vcs.perforce"})
public final class ShelfUtils {
    private static final Logger LOG;
    @NotNull
    public static final ShelfUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void browseShelf(@NotNull Project project, @NotNull List<? extends ShelvedChange> shelvedChanges) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(shelvedChanges, (String)"shelvedChanges");
        Iterable $this$map$iv = shelvedChanges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShelvedChange shelvedChange = (ShelvedChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Change change = it.toIdeaChange(project);
            collection.add(change);
        }
        List changes = (List)destination$iv$iv;
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        SimpleChangesBrowser browser = new SimpleChangesBrowser(project, true, false);
        browser.setInclusionChangedListener(new Runnable(dialogBuilder, browser){
            final /* synthetic */ DialogBuilder $dialogBuilder;
            final /* synthetic */ SimpleChangesBrowser $browser;

            public final void run() {
                List list = this.$browser.getIncludedChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"browser.includedChanges");
                Collection collection = list;
                this.$dialogBuilder.setOkActionEnabled(!collection.isEmpty());
            }
            {
                this.$dialogBuilder = dialogBuilder;
                this.$browser = simpleChangesBrowser;
            }
        });
        browser.setChangesToDisplay((Collection)changes);
        browser.setIncludedChanges((Collection)changes);
        browser.addToolbarAction((AnAction)new DumbAwareAction(browser, project, PerforceBundle.messagePointer("shelf.unshelve", new Object[0]), PerforceBundle.messagePointer("shelf.unshelve.action.description", new Object[0]), AllIcons.Vcs.Unshelve){
            final /* synthetic */ SimpleChangesBrowser $browser;
            final /* synthetic */ Project $project;

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                List list = this.$browser.getIncludedChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"browser.includedChanges");
                Collection collection = list;
                presentation.setEnabled(!collection.isEmpty());
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileDocumentManager.getInstance().saveAllDocuments();
                List list = this.$browser.getIncludedChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"browser.includedChanges");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Change change = (Change)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.idea.perforce.application.ShelvedChange.IdeaChange");
                    }
                    ShelvedChange shelvedChange = ((ShelvedChange.IdeaChange)v1).getOriginal();
                    collection.add(shelvedChange);
                }
                ShelfUtils.unshelveChanges((List)destination$iv$iv, this.$project, false);
            }
            {
                this.$browser = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        dialogBuilder.setTitle(PerforceBundle.message("shelf.changes", new Object[0]));
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{(DialogBuilder.ActionDescriptor)new DialogBuilder.OkActionDescriptor(), (DialogBuilder.ActionDescriptor)new DialogBuilder.CloseDialogAction()});
        dialogBuilder.getOkAction().setText(PerforceBundle.message("shelf.unshelve.and.delete", new Object[0]));
        dialogBuilder.setOkOperation(new Runnable(browser, project, dialogBuilder){
            final /* synthetic */ SimpleChangesBrowser $browser;
            final /* synthetic */ Project $project;
            final /* synthetic */ DialogBuilder $dialogBuilder;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                List list = this.$browser.getIncludedChanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"browser.includedChanges");
                List selected = list;
                Collection collection = selected;
                if (!collection.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = selected;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Change change = (Change)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        void v1 = it;
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.idea.perforce.application.ShelvedChange.IdeaChange");
                        }
                        ShelvedChange shelvedChange = ((ShelvedChange.IdeaChange)v1).getOriginal();
                        collection2.add(shelvedChange);
                    }
                    ShelfUtils.unshelveChanges((List)destination$iv$iv, this.$project, true);
                    this.$dialogBuilder.getDialogWrapper().close(0);
                }
            }
            {
                this.$browser = simpleChangesBrowser;
                this.$project = project;
                this.$dialogBuilder = dialogBuilder;
            }
        });
        dialogBuilder.setCenterPanel((JComponent)browser);
        dialogBuilder.setPreferredFocusComponent(browser.getPreferredFocusedComponent());
        dialogBuilder.showNotModal();
    }

    @JvmStatic
    @NotNull
    public static final MultiMap<Pair<P4Connection, Long>, String> groupByChangeList(@NotNull List<? extends ShelvedChange> selected) {
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.create<Pair<P4C\u2026nection, Long>, String>()");
        MultiMap paths = multiMap;
        for (ShelvedChange shelvedChange : selected) {
            paths.putValue((Object)TuplesKt.to((Object)shelvedChange.getConnection(), (Object)shelvedChange.getChangeList()), (Object)shelvedChange.getDepotPath());
        }
        return paths;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @JvmStatic
    public static final void unshelveChanges(@NotNull List<? extends ShelvedChange> selected, @NotNull Project project, boolean delete) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(selected, (String)"selected");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MultiMap<Pair<P4Connection, Long>, String> paths = ShelfUtils.groupByChangeList(selected);
        INSTANCE.doUnshelve(paths, project);
        if (delete) {
            ShelfUtils.deleteFromShelf(paths, project);
        }
        Iterable $this$mapNotNull$iv = selected;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FilePath filePath;
            FilePath filePath2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ShelvedChange it = (ShelvedChange)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() != null) {
                File file;
                File file2 = file;
                boolean bl3 = false;
                filePath2 = VcsUtil.getFilePath((File)file2);
            } else {
                filePath2 = null;
            }
            if (filePath2 == null) continue;
            FilePath it$iv$iv = filePath = filePath2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dirtyFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv = dirtyFiles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePath it = (FilePath)element$iv;
            boolean bl = false;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            FilePath filePath = it;
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"it");
            VirtualFile file = localFileSystem.refreshAndFindFileByPath(filePath.getPath());
            if (file == null) continue;
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
        }
        VcsDirtyScopeManager.getInstance((Project)project).filePathsDirty((Collection)dirtyFiles, (Collection)CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final void doUnshelve(MultiMap<Pair<P4Connection, Long>, String> paths, Project project) {
        for (Map.Entry entry : paths.entrySet()) {
            void pair;
            Object object = entry;
            Pair pair2 = (Pair)object.getKey();
            object = entry;
            Collection specs = (Collection)object.getValue();
            void var10_9 = pair;
            object = (P4Connection)var10_9.component1();
            long changeList = ((Number)var10_9.component2()).longValue();
            try {
                void connection;
                PerforceRunner.getInstance(project).unshelve((P4Connection)connection, changeList, specs);
            }
            catch (VcsException e) {
                AbstractVcsHelper.getInstance((Project)project).showError(e, PerforceBundle.message("shelf.unshelve", new Object[0]));
            }
        }
    }

    private final void handleUnshelveException(P4Connection connection, VcsException unshelveException, Project project, Collection<String> specs) {
        String string = unshelveException.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unshelveException.message");
        String msg = string;
        if (StringsKt.contains$default((CharSequence)msg, (CharSequence)"needs resolve", (boolean)false, (int)2, null)) {
            LinkedHashSet<VirtualFile> toResolve = null;
            try {
                LinkedHashSet<VirtualFile> linkedHashSet = PerforceRunner.getInstance(project).getResolvedWithConflicts(connection, specs);
                Intrinsics.checkNotNullExpressionValue(linkedHashSet, (String)"PerforceRunner.getInstan\u2026flicts(connection, specs)");
                toResolve = linkedHashSet;
            }
            catch (VcsException resolveException) {
                AbstractVcsHelper.getInstance((Project)project).showError(unshelveException, PerforceBundle.message("shelf.unshelve", new Object[0]));
                AbstractVcsHelper.getInstance((Project)project).showError(resolveException, PerforceBundle.message("shelf.unshelve", new Object[0]));
                return;
            }
            Collection resolveException = toResolve;
            if (!resolveException.isEmpty()) {
                Collection $this$toTypedArray$iv = toResolve;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
                if (virtualFileArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
                LOG.info((Throwable)unshelveException);
                new PerforceMergeProvider(project).showMergeDialog(CollectionsKt.toList((Iterable)toResolve));
                return;
            }
        }
        AbstractVcsHelper.getInstance((Project)project).showError(unshelveException, PerforceBundle.message("shelf.unshelve", new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void deleteFromShelf(@NotNull MultiMap<Pair<P4Connection, Long>, String> paths, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        for (Map.Entry entry : paths.entrySet()) {
            void connection;
            void pair;
            Object object = entry;
            Pair pair2 = (Pair)object.getKey();
            object = entry;
            Collection specs = (Collection)object.getValue();
            void var9_8 = pair;
            object = (P4Connection)var9_8.component1();
            long changeList = ((Number)var9_8.component2()).longValue();
            try {
                PerforceRunner.getInstance(project).deleteFromShelf((P4Connection)connection, changeList, specs);
            }
            catch (VcsException e) {
                INSTANCE.handleUnshelveException((P4Connection)connection, e, project, specs);
            }
        }
    }

    @JvmStatic
    public static final void deleteFromShelf(@NotNull List<? extends ShelvedChange> changes, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ShelfUtils.deleteFromShelf(ShelfUtils.groupByChangeList(changes), project);
    }

    private ShelfUtils() {
    }

    static {
        ShelfUtils shelfUtils;
        INSTANCE = shelfUtils = new ShelfUtils();
        Logger logger = Logger.getInstance(ShelfUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(ShelfUtils::class.java)");
        LOG = logger;
    }
}

