/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.util.function.Function;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class BuildSessionLifecycleBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final ServiceRegistry globalServices;
    private final GradleUserHomeScopeServiceRegistry userHomeServiceRegistry;

    public BuildSessionLifecycleBuildActionExecuter(GradleUserHomeScopeServiceRegistry userHomeServiceRegistry, ServiceRegistry globalServices) {
        this.userHomeServiceRegistry = userHomeServiceRegistry;
        this.globalServices = globalServices;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        StartParameterInternal startParameter = action.getStartParameter();
        if (action.isCreateModel()) {
            startParameter.setContinuous(false);
        }
        ActionImpl actionWrapper = new ActionImpl(action, requestContext);
        try (CrossBuildSessionState crossBuildSessionState = new CrossBuildSessionState(this.globalServices, startParameter);){
            BuildSessionState buildSessionState = new BuildSessionState(this.userHomeServiceRegistry, crossBuildSessionState, startParameter, requestContext, actionParameters.getInjectedPluginClasspath(), requestContext.getCancellationToken(), requestContext.getClient(), requestContext.getEventConsumer());
            try {
                BuildActionResult buildActionResult = buildSessionState.run(actionWrapper);
                buildSessionState.close();
                return buildActionResult;
            }
            catch (Throwable throwable) {
                try {
                    buildSessionState.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            if (actionWrapper.result == null) {
                throw UncheckedException.throwAsUncheckedException(t);
            }
            throw UncheckedException.throwAsUncheckedException(actionWrapper.result.addFailure(t).getBuildFailure());
        }
    }

    private RuntimeException wrap(Throwable failure) {
        if (failure instanceof RuntimeException) {
            return (RuntimeException)failure;
        }
        return new RuntimeException(failure);
    }

    private static class ActionImpl
    implements Function<BuildSessionContext, BuildActionResult> {
        private final BuildAction action;
        private final BuildRequestContext requestContext;
        private BuildActionRunner.Result result;

        public ActionImpl(BuildAction action, BuildRequestContext requestContext) {
            this.action = action;
            this.requestContext = requestContext;
        }

        @Override
        public BuildActionResult apply(BuildSessionContext context) {
            this.result = context.execute(this.action);
            PayloadSerializer payloadSerializer = context.getServices().get(PayloadSerializer.class);
            if (this.result.getBuildFailure() == null) {
                if (this.result.getClientResult() instanceof SerializedPayload) {
                    return BuildActionResult.of((SerializedPayload)this.result.getClientResult());
                }
                return BuildActionResult.of(payloadSerializer.serialize(this.result.getClientResult()));
            }
            if (this.requestContext.getCancellationToken().isCancellationRequested()) {
                return BuildActionResult.cancelled(payloadSerializer.serialize(this.result.getBuildFailure()));
            }
            return BuildActionResult.failed(payloadSerializer.serialize(this.result.getClientFailure()));
        }
    }
}

