/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.serialize.Serializer;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.MultiRequestClient;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessException;
import org.gradle.process.internal.worker.WorkerProcessSettings;
import org.gradle.process.internal.worker.request.Receiver;
import org.gradle.process.internal.worker.request.Request;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.RequestSerializerRegistry;
import org.gradle.process.internal.worker.request.ResponseProtocol;
import org.gradle.process.internal.worker.request.WorkerAction;

class DefaultMultiRequestWorkerProcessBuilder<IN, OUT>
implements MultiRequestWorkerProcessBuilder<IN, OUT> {
    private final Class<?> workerImplementation;
    private final DefaultWorkerProcessBuilder workerProcessBuilder;
    private Action<WorkerProcess> onFailure = Actions.doNothing();
    private final RequestArgumentSerializers argumentSerializers = new RequestArgumentSerializers();
    private final OutputEventListener outputEventListener;

    public DefaultMultiRequestWorkerProcessBuilder(Class<?> workerImplementation, DefaultWorkerProcessBuilder workerProcessBuilder, OutputEventListener outputEventListener) {
        this.workerImplementation = workerImplementation;
        this.workerProcessBuilder = workerProcessBuilder;
        ClassPath implementationClasspath = ClasspathUtil.getClasspath(workerImplementation.getClassLoader());
        this.outputEventListener = outputEventListener;
        workerProcessBuilder.worker(new WorkerAction(workerImplementation));
        workerProcessBuilder.setImplementationClasspath(implementationClasspath.getAsURLs());
    }

    @Override
    public WorkerProcessSettings applicationClasspath(Iterable<File> files) {
        this.workerProcessBuilder.applicationClasspath((Iterable)files);
        return this;
    }

    @Override
    public WorkerProcessSettings applicationModulePath(Iterable<File> files) {
        this.workerProcessBuilder.applicationModulePath((Iterable)files);
        return this;
    }

    @Override
    public Set<File> getApplicationModulePath() {
        return this.workerProcessBuilder.getApplicationModulePath();
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.workerProcessBuilder.getApplicationClasspath();
    }

    @Override
    public String getBaseName() {
        return this.workerProcessBuilder.getBaseName();
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.workerProcessBuilder.getJavaCommand();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.workerProcessBuilder.getLogLevel();
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.workerProcessBuilder.getSharedPackages();
    }

    @Override
    public <T> void registerArgumentSerializer(Class<T> type, Serializer<T> serializer) {
        this.argumentSerializers.register(type, serializer);
    }

    @Override
    public WorkerProcessSettings setBaseName(String baseName) {
        this.workerProcessBuilder.setBaseName(baseName);
        return this;
    }

    @Override
    public WorkerProcessSettings setLogLevel(LogLevel logLevel) {
        this.workerProcessBuilder.setLogLevel(logLevel);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(Iterable<String> packages) {
        this.workerProcessBuilder.sharedPackages((Iterable)packages);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(String ... packages) {
        this.workerProcessBuilder.sharedPackages(packages);
        return this;
    }

    @Override
    public void onProcessFailure(Action<WorkerProcess> action) {
        this.onFailure = action;
    }

    @Override
    public void useApplicationClassloaderOnly() {
        this.workerProcessBuilder.setImplementationClasspath(Collections.emptyList());
    }

    @Override
    public MultiRequestClient<IN, OUT> build() {
        this.workerProcessBuilder.enableJvmMemoryInfoPublishing(true);
        final WorkerProcess workerProcess = this.workerProcessBuilder.build();
        final Action<WorkerProcess> failureHandler = this.onFailure;
        return new MultiRequestClient<IN, OUT>(){
            private Receiver receiver;
            private RequestProtocol requestProtocol;
            {
                this.receiver = new Receiver(DefaultMultiRequestWorkerProcessBuilder.this.getBaseName(), DefaultMultiRequestWorkerProcessBuilder.this.outputEventListener);
            }

            @Override
            public WorkerProcess start() {
                try {
                    workerProcess.start();
                }
                catch (Exception e) {
                    throw WorkerProcessException.runFailed(DefaultMultiRequestWorkerProcessBuilder.this.getBaseName(), e);
                }
                workerProcess.getConnection().addIncoming(ResponseProtocol.class, this.receiver);
                workerProcess.getConnection().useJavaSerializationForParameters(DefaultMultiRequestWorkerProcessBuilder.this.workerImplementation.getClassLoader());
                workerProcess.getConnection().useParameterSerializers(RequestSerializerRegistry.create(DefaultMultiRequestWorkerProcessBuilder.this.workerImplementation.getClassLoader(), DefaultMultiRequestWorkerProcessBuilder.this.argumentSerializers));
                this.requestProtocol = workerProcess.getConnection().addOutgoing(RequestProtocol.class);
                workerProcess.getConnection().connect();
                return workerProcess;
            }

            @Override
            public ExecResult stop() {
                if (this.requestProtocol != null) {
                    this.requestProtocol.stop();
                }
                try {
                    ExecResult execResult = workerProcess.waitForStop();
                    return execResult;
                }
                finally {
                    this.requestProtocol = null;
                }
            }

            @Override
            public OUT run(IN request) {
                this.requestProtocol.run(new Request(request, CurrentBuildOperationRef.instance().get()));
                boolean hasResult = this.receiver.awaitNextResult();
                if (!hasResult) {
                    try {
                        this.requestProtocol = null;
                        failureHandler.execute(workerProcess);
                        workerProcess.waitForStop();
                        throw new IllegalStateException(String.format("No response was received from %s but the worker process has finished.", DefaultMultiRequestWorkerProcessBuilder.this.getBaseName()));
                    }
                    catch (Exception e) {
                        throw WorkerProcessException.runFailed(DefaultMultiRequestWorkerProcessBuilder.this.getBaseName(), e);
                    }
                }
                return Cast.uncheckedNonnullCast(this.receiver.getNextResult());
            }
        };
    }
}

