/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.plugin.internal.InvalidPluginIdException;
import org.gradle.plugin.internal.InvalidPluginVersionException;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.PluginDependenciesSpec;
import org.gradle.plugin.use.PluginDependency;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.gradle.util.internal.CollectionUtils;

public class PluginRequestCollector {
    public static final String EMPTY_VALUE = "cannot be null or empty";
    private final ScriptSource scriptSource;
    private final List<PluginDependencySpecImpl> specs = new LinkedList<PluginDependencySpecImpl>();

    public PluginRequestCollector(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public PluginDependenciesSpec createSpec(int pluginsBlockLineNumber) {
        return new PluginDependenciesSpecImpl(pluginsBlockLineNumber);
    }

    public PluginRequests getPluginRequests() {
        if (this.specs.isEmpty()) {
            return PluginRequests.EMPTY;
        }
        return PluginRequests.of(this.listPluginRequests());
    }

    @VisibleForTesting
    List<PluginRequestInternal> listPluginRequests() {
        List<PluginRequestInternal> pluginRequests = CollectionUtils.collect(this.specs, new Transformer<PluginRequestInternal, PluginDependencySpecImpl>(){

            @Override
            public PluginRequestInternal transform(PluginDependencySpecImpl original) {
                return new DefaultPluginRequest(original.id, original.version, original.apply, (Integer)original.lineNumber, PluginRequestCollector.this.scriptSource);
            }
        });
        Map<PluginId, Collection<PluginRequestInternal>> groupedById = CollectionUtils.groupBy(pluginRequests, new Transformer<PluginId, PluginRequestInternal>(){

            @Override
            public PluginId transform(PluginRequestInternal pluginRequest) {
                return pluginRequest.getId();
            }
        });
        for (PluginId key : groupedById.keySet()) {
            Collection<PluginRequestInternal> pluginRequestsForId = groupedById.get(key);
            if (pluginRequestsForId.size() <= 1) continue;
            Iterator<PluginRequestInternal> iterator = pluginRequestsForId.iterator();
            PluginRequestInternal first = iterator.next();
            PluginRequestInternal second = iterator.next();
            InvalidPluginRequestException exception = new InvalidPluginRequestException(second, "Plugin with id '" + key + "' was already requested at line " + first.getLineNumber());
            throw new LocationAwareException((Throwable)exception, second.getScriptDisplayName(), second.getLineNumber());
        }
        return pluginRequests;
    }

    private static class PluginDependencySpecImpl
    implements PluginDependencySpec {
        private final PluginId id;
        private String version;
        private boolean apply;
        private final int lineNumber;

        private PluginDependencySpecImpl(String id, int lineNumber) {
            if (Strings.isNullOrEmpty((String)id)) {
                throw new InvalidPluginIdException(id, PluginRequestCollector.EMPTY_VALUE);
            }
            this.id = DefaultPluginId.of(id);
            this.apply = true;
            this.lineNumber = lineNumber;
        }

        @Override
        public PluginDependencySpec version(String version) {
            if (Strings.isNullOrEmpty((String)version)) {
                throw new InvalidPluginVersionException(version, PluginRequestCollector.EMPTY_VALUE);
            }
            this.version = version;
            return this;
        }

        @Override
        public PluginDependencySpec apply(boolean apply) {
            this.apply = apply;
            return this;
        }
    }

    private class PluginDependenciesSpecImpl
    implements PluginDependenciesSpec {
        private final int blockLineNumber;

        public PluginDependenciesSpecImpl(int blockLineNumber) {
            this.blockLineNumber = blockLineNumber;
        }

        @Override
        public PluginDependencySpec id(String id) {
            return this.id(id, this.blockLineNumber);
        }

        public PluginDependencySpec id(String id, int requestLineNumber) {
            PluginDependencySpecImpl spec = new PluginDependencySpecImpl(id, requestLineNumber);
            PluginRequestCollector.this.specs.add(spec);
            return spec;
        }

        @Override
        public PluginDependencySpec alias(Provider<PluginDependency> notation) {
            PluginDependency pluginDependency = notation.get();
            return this.id(pluginDependency.getPluginId()).version(pluginDependency.getVersion().getRequiredVersion());
        }

        @Override
        public PluginDependencySpec alias(ProviderConvertible<PluginDependency> notation) {
            return this.alias(notation.asProvider());
        }
    }
}

