/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshottingException;

public class JavaSerializedValueSnapshot
implements ValueSnapshot {
    private final HashCode implementationHash;
    private final byte[] serializedValue;

    public JavaSerializedValueSnapshot(@Nullable HashCode implementationHash, byte[] serializedValue) {
        this.implementationHash = implementationHash;
        this.serializedValue = serializedValue;
    }

    @Nullable
    public HashCode getImplementationHash() {
        return this.implementationHash;
    }

    public byte[] getValue() {
        return this.serializedValue;
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (this.hasSameSerializedValue(value, snapshot)) {
            return this;
        }
        return snapshot;
    }

    private boolean hasSameSerializedValue(Object value, ValueSnapshot snapshot) {
        if (snapshot instanceof JavaSerializedValueSnapshot) {
            JavaSerializedValueSnapshot newSnapshot = (JavaSerializedValueSnapshot)snapshot;
            if (!Objects.equal((Object)this.implementationHash, (Object)newSnapshot.implementationHash)) {
                return false;
            }
            if (Arrays.equals(this.serializedValue, newSnapshot.serializedValue)) {
                return true;
            }
            Object oldValue = this.populateClass(value.getClass());
            if (oldValue.equals(value)) {
                ((DeprecationMessageBuilder)((DeprecationMessageBuilder)DeprecationLogger.deprecateIndirectUsage("Using objects as inputs that have a different serialized form but are equal").withContext("Type '" + value.getClass().getName() + "' has a custom implementation for equals().")).withAdvice("Declare the property as @Nested instead to expose its properties as inputs.")).willBeRemovedInGradle8().withUserManual("upgrading_version_7", "equals_up_to_date_deprecation").nagUser();
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        if (this.implementationHash == null) {
            hasher.putNull();
        } else {
            hasher.putHash(this.implementationHash);
        }
        hasher.putBytes(this.serializedValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JavaSerializedValueSnapshot other = (JavaSerializedValueSnapshot)obj;
        return Objects.equal((Object)this.implementationHash, (Object)other.implementationHash) && Arrays.equals(this.serializedValue, other.serializedValue);
    }

    protected Object populateClass(Class<?> originalClass) {
        try {
            return new ClassLoaderObjectInputStream(new ByteArrayInputStream(this.serializedValue), originalClass.getClassLoader()).readObject();
        }
        catch (Exception e) {
            throw new ValueSnapshottingException("Couldn't populate class " + originalClass.getName(), e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedValue);
    }
}

