/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.gradle.cache.CacheDecorator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultPreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultPreviousExecutionStateSerializer;
import org.gradle.internal.execution.history.impl.FileCollectionFingerprintSerializer;
import org.gradle.internal.execution.history.impl.FileSystemSnapshotSerializer;
import org.gradle.internal.execution.history.impl.SerializableFileCollectionFingerprint;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultExecutionHistoryStore
implements ExecutionHistoryStore {
    private final PersistentIndexedCache<String, PreviousExecutionState> store;

    public DefaultExecutionHistoryStore(Supplier<PersistentCache> cache, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, Interner<String> stringInterner, ClassLoaderHierarchyHasher classLoaderHasher) {
        DefaultPreviousExecutionStateSerializer serializer = new DefaultPreviousExecutionStateSerializer(new FileCollectionFingerprintSerializer(stringInterner), new FileSystemSnapshotSerializer(stringInterner), classLoaderHasher);
        CacheDecorator inMemoryCacheDecorator = inMemoryCacheDecoratorFactory.decorator(10000, false);
        this.store = cache.get().createCache(PersistentIndexedCacheParameters.of("executionHistory", String.class, serializer).withCacheDecorator(inMemoryCacheDecorator));
    }

    @Override
    public Optional<PreviousExecutionState> load(String key) {
        return Optional.ofNullable(this.store.getIfPresent(key));
    }

    @Override
    public void store(String key, boolean successful, AfterExecutionState executionState) {
        this.store.put(key, new DefaultPreviousExecutionState(executionState.getOriginMetadata(), executionState.getImplementation(), executionState.getAdditionalImplementations(), executionState.getInputProperties(), DefaultExecutionHistoryStore.prepareForSerialization(executionState.getInputFileProperties()), executionState.getOutputFilesProducedByWork(), successful));
    }

    @Override
    public void remove(String key) {
        this.store.remove(key);
    }

    private static ImmutableSortedMap<String, FileCollectionFingerprint> prepareForSerialization(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprints) {
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformValues(fingerprints, value -> value.archive(SerializableFileCollectionFingerprint::new)));
    }
}

