/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.ivypublish;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.internal.Pair;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.ivypublish.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModuleDescriptorWriter;
import org.gradle.internal.component.external.ivypublish.IvyModulePublishMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.xml.SimpleXmlWriter;

public class DefaultIvyModuleDescriptorWriter
implements IvyModuleDescriptorWriter {
    public static final String IVY_DATE_PATTERN = "yyyyMMddHHmmss";
    private final ComponentSelectorConverter componentSelectorConverter;

    public DefaultIvyModuleDescriptorWriter(ComponentSelectorConverter componentSelectorConverter) {
        this.componentSelectorConverter = componentSelectorConverter;
    }

    @Override
    public void write(IvyModulePublishMetadata module, File output) {
        try {
            output.getParentFile().mkdirs();
            try (FileOutputStream outputStream = new FileOutputStream(output);){
                SimpleXmlWriter xmlWriter = new SimpleXmlWriter(outputStream, "  ");
                this.writeTo(module, xmlWriter);
                xmlWriter.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeTo(IvyModulePublishMetadata metadata, SimpleXmlWriter writer2) throws IOException {
        writer2.startElement("ivy-module");
        writer2.attribute("version", "2.0");
        writer2.attribute("xmlns:m", "http://ant.apache.org/ivy/maven");
        DefaultIvyModuleDescriptorWriter.printInfoTag(metadata, writer2);
        this.printConfigurations(metadata, writer2);
        DefaultIvyModuleDescriptorWriter.printPublications(metadata.getArtifacts(), writer2);
        this.printDependencies(metadata, writer2);
        writer2.endElement();
    }

    private static void printInfoTag(IvyModulePublishMetadata metadata, SimpleXmlWriter writer2) throws IOException {
        ModuleComponentIdentifier id = metadata.getComponentId();
        writer2.startElement("info");
        writer2.attribute("organisation", id.getGroup());
        writer2.attribute("module", id.getModule());
        writer2.attribute("revision", id.getVersion());
        writer2.attribute("status", metadata.getStatus());
        DefaultIvyModuleDescriptorWriter.printUnusedContent(metadata, writer2);
        writer2.endElement();
    }

    private static void printUnusedContent(IvyModulePublishMetadata metadata, SimpleXmlWriter writer2) throws IOException {
        SimpleDateFormat ivyDateFormat = new SimpleDateFormat(IVY_DATE_PATTERN);
        writer2.attribute("publication", ivyDateFormat.format(new Date()));
    }

    private void printConfigurations(IvyModulePublishMetadata metadata, SimpleXmlWriter writer2) throws IOException {
        Collection<Configuration> configurations = metadata.getConfigurations().values();
        if (!configurations.isEmpty()) {
            writer2.startElement("configurations");
            for (Configuration configuration2 : configurations) {
                this.printConfiguration(configuration2, writer2);
            }
            writer2.endElement();
        }
    }

    private void printConfiguration(Configuration conf, SimpleXmlWriter writer2) throws IOException {
        writer2.startElement("conf");
        writer2.attribute("name", conf.getName());
        writer2.attribute("visibility", conf.isVisible() ? "public" : "private");
        List<String> exts = conf.getExtendsFrom();
        if (exts.size() > 0) {
            writer2.attribute("extends", Joiner.on((char)',').join(exts));
        }
        if (!conf.isTransitive()) {
            writer2.attribute("transitive", "false");
        }
        writer2.endElement();
    }

    private static void printPublications(Collection<IvyModuleArtifactPublishMetadata> artifacts2, SimpleXmlWriter writer2) throws IOException {
        writer2.startElement("publications");
        for (IvyModuleArtifactPublishMetadata artifactMetadata : artifacts2) {
            IvyArtifactName artifact = artifactMetadata.getArtifactName();
            writer2.startElement("artifact");
            writer2.attribute("name", artifact.getName());
            writer2.attribute("type", artifact.getType());
            writer2.attribute("ext", artifact.getExtension() == null ? "" : artifact.getExtension());
            writer2.attribute("conf", Joiner.on((String)",").join(artifactMetadata.getConfigurations()));
            if (artifact.getClassifier() != null) {
                DefaultIvyModuleDescriptorWriter.printExtraAttributes(Collections.singletonMap("m:classifier", artifact.getClassifier()), writer2);
            }
            writer2.endElement();
        }
        writer2.endElement();
    }

    private void printDependencies(IvyModulePublishMetadata metadata, SimpleXmlWriter writer2) throws IOException {
        Collection<LocalOriginDependencyMetadata> dependencies = metadata.getDependencies();
        if (dependencies.size() > 0) {
            writer2.startElement("dependencies");
            for (LocalOriginDependencyMetadata dd : dependencies) {
                this.printDependency(dd, writer2);
            }
            DefaultIvyModuleDescriptorWriter.printAllExcludes(metadata, writer2);
            writer2.endElement();
        }
    }

    protected void printDependency(LocalOriginDependencyMetadata dep, SimpleXmlWriter writer2) throws IOException {
        writer2.startElement("dependency");
        ModuleVersionSelector requested = this.componentSelectorConverter.getSelector(dep.getSelector());
        writer2.attribute("org", requested.getGroup());
        writer2.attribute("name", requested.getName());
        writer2.attribute("rev", requested.getVersion());
        if (dep.isForce()) {
            writer2.attribute("force", "true");
        }
        if (dep.isChanging()) {
            writer2.attribute("changing", "true");
        }
        if (!dep.isTransitive()) {
            writer2.attribute("transitive", "false");
        }
        writer2.attribute("conf", this.getConfMapping(dep));
        for (IvyArtifactName dependencyArtifact : dep.getArtifacts()) {
            DefaultIvyModuleDescriptorWriter.printDependencyArtifact(writer2, dependencyArtifact, dep.getModuleConfiguration());
        }
        DefaultIvyModuleDescriptorWriter.printDependencyExcludeRules(writer2, dep.getExcludes());
        writer2.endElement();
    }

    private String getConfMapping(LocalOriginDependencyMetadata dependency) {
        return dependency.getModuleConfiguration() + "->" + dependency.getDependencyConfiguration();
    }

    private static void printAllExcludes(IvyModulePublishMetadata metadata, SimpleXmlWriter writer2) throws IOException {
        for (Pair<ExcludeMetadata, String> excludePair : metadata.getExcludes()) {
            ExcludeMetadata exclude = excludePair.getLeft();
            writer2.startElement("exclude");
            writer2.attribute("org", exclude.getModuleId().getGroup());
            writer2.attribute("module", exclude.getModuleId().getName());
            IvyArtifactName artifact = exclude.getArtifact();
            if (artifact != null) {
                writer2.attribute("artifact", artifact.getName());
                writer2.attribute("type", artifact.getType());
                writer2.attribute("ext", artifact.getExtension());
            }
            writer2.attribute("conf", excludePair.getRight());
            writer2.endElement();
        }
    }

    private static void printDependencyExcludeRules(SimpleXmlWriter writer2, Collection<ExcludeMetadata> excludes) throws IOException {
        for (ExcludeMetadata exclude : excludes) {
            writer2.startElement("exclude");
            writer2.attribute("org", exclude.getModuleId().getGroup());
            writer2.attribute("module", exclude.getModuleId().getName());
            IvyArtifactName artifact = exclude.getArtifact();
            if (artifact != null) {
                writer2.attribute("name", artifact.getName());
                writer2.attribute("type", artifact.getType());
                writer2.attribute("ext", artifact.getExtension());
            }
            writer2.endElement();
        }
    }

    private static void printDependencyArtifact(SimpleXmlWriter writer2, IvyArtifactName artifact, String configuration2) throws IOException {
        writer2.startElement("artifact");
        writer2.attribute("name", artifact.getName());
        writer2.attribute("type", artifact.getType());
        writer2.attribute("ext", artifact.getExtension());
        if (artifact.getClassifier() != null) {
            DefaultIvyModuleDescriptorWriter.printExtraAttributes(Collections.singletonMap("m:classifier", artifact.getClassifier()), writer2);
        }
        writer2.attribute("conf", configuration2);
        writer2.endElement();
    }

    private static void printExtraAttributes(Map<String, ?> extra, SimpleXmlWriter writer2) throws IOException {
        if (extra == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : extra.entrySet()) {
            writer2.attribute(entry.getKey(), entry.getValue().toString());
        }
    }
}

