/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.gradle.api.specs.Spec;
import org.gradle.configuration.ScriptTarget;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.BuildScriptData;
import org.gradle.groovy.scripts.internal.FilteringScriptTransformer;
import org.gradle.groovy.scripts.internal.FixMainScriptTransformer;
import org.gradle.groovy.scripts.internal.ImperativeStatementDetectingTransformer;
import org.gradle.groovy.scripts.internal.StatementLabelsScriptTransformer;
import org.gradle.groovy.scripts.internal.TaskDefinitionScriptTransformer;
import org.gradle.internal.Factory;
import org.gradle.model.dsl.internal.transform.ModelBlockTransformer;

public class BuildScriptTransformer
implements Transformer,
Factory<BuildScriptData> {
    private final Spec<? super Statement> filter;
    private final ScriptSource scriptSource;
    private final ImperativeStatementDetectingTransformer imperativeStatementDetectingTransformer = new ImperativeStatementDetectingTransformer();

    public BuildScriptTransformer(ScriptSource scriptSource, ScriptTarget scriptTarget) {
        final List<String> blocksToIgnore = Arrays.asList(scriptTarget.getClasspathBlockName(), "plugins", "pluginManagement");
        this.filter = new Spec<Statement>(){

            @Override
            public boolean isSatisfiedBy(Statement statement) {
                return AstUtils.detectScriptBlock(statement, blocksToIgnore) != null;
            }
        };
        this.scriptSource = scriptSource;
    }

    @Override
    public void register(CompilationUnit compilationUnit) {
        new FilteringScriptTransformer(this.filter).register(compilationUnit);
        new TaskDefinitionScriptTransformer().register(compilationUnit);
        new FixMainScriptTransformer().register(compilationUnit);
        new StatementLabelsScriptTransformer().register(compilationUnit);
        new ModelBlockTransformer(this.scriptSource.getDisplayName(), this.scriptSource.getResource().getLocation().getURI()).register(compilationUnit);
        this.imperativeStatementDetectingTransformer.register(compilationUnit);
    }

    @Override
    public BuildScriptData create() {
        return new BuildScriptData(this.imperativeStatementDetectingTransformer.isImperativeStatementDetected());
    }
}

