/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.execution.TaskSelection;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.internal.CollectionUtils;

@NonNullApi
public class TaskDetailPrinter {
    private final String taskPath;
    private final TaskSelection selection;
    private static final String INDENT = "     ";
    private final OptionReader optionReader;

    public TaskDetailPrinter(String taskPath, TaskSelection selection, OptionReader optionReader) {
        this.taskPath = taskPath;
        this.selection = selection;
        this.optionReader = optionReader;
    }

    public void print(StyledTextOutput output) {
        List<Task> tasks = CollectionUtils.sort(this.selection.getTasks());
        output.text("Detailed task information for ").withStyle(StyledTextOutput.Style.UserInput).println(this.taskPath);
        ListMultimap<Class<?>, Task> classListMap = this.groupTasksByType(tasks);
        Set classes = classListMap.keySet();
        boolean multipleClasses = classes.size() > 1;
        List<Class> sortedClasses = CollectionUtils.sort(classes, Comparator.comparing(Class::getSimpleName));
        for (Class clazz : sortedClasses) {
            output.println();
            List tasksByType = classListMap.get((Object)clazz);
            LinePrefixingStyledTextOutput pathOutput = this.createIndentedOutput(output, INDENT);
            pathOutput.println(tasksByType.size() > 1 ? "Paths" : "Path");
            for (Task task : tasksByType) {
                pathOutput.withStyle(StyledTextOutput.Style.UserInput).println(task.getPath());
            }
            output.println();
            LinePrefixingStyledTextOutput typeOutput = this.createIndentedOutput(output, INDENT);
            typeOutput.println("Type");
            typeOutput.withStyle(StyledTextOutput.Style.UserInput).text(clazz.getSimpleName());
            typeOutput.println(" (" + clazz.getName() + ")");
            this.printlnCommandlineOptions(output, tasksByType);
            output.println();
            this.printTaskDescription(output, tasksByType);
            output.println();
            this.printTaskGroup(output, tasksByType);
            if (!multipleClasses) continue;
            output.println();
            output.println("----------------------");
        }
    }

    private ListMultimap<Class<?>, Task> groupTasksByType(List<Task> tasks) {
        TreeSet<Class> taskTypes = new TreeSet<Class>(Comparator.comparing(Class::getSimpleName));
        taskTypes.addAll(CollectionUtils.collect(tasks, this::getDeclaredTaskType));
        ArrayListMultimap tasksGroupedByType = ArrayListMultimap.create();
        for (Class taskType : taskTypes) {
            tasksGroupedByType.putAll((Object)taskType, CollectionUtils.filter(tasks, element -> this.getDeclaredTaskType((Task)element).equals(taskType)));
        }
        return tasksGroupedByType;
    }

    private Class<?> getDeclaredTaskType(Task original) {
        Class<?> clazz = new DslObject(original).getDeclaredType();
        if (clazz.equals(DefaultTask.class)) {
            return Task.class;
        }
        return clazz;
    }

    private void printTaskDescription(StyledTextOutput output, List<Task> tasks) {
        this.printTaskAttribute(output, "Description", tasks, Task::getDescription);
    }

    private void printTaskGroup(StyledTextOutput output, List<Task> tasks) {
        this.printTaskAttribute(output, "Group", tasks, Task::getGroup);
    }

    private void printTaskAttribute(StyledTextOutput output, String attributeHeader, List<Task> tasks, Transformer<String, Task> transformer) {
        int count = CollectionUtils.collect(tasks, new HashSet(), transformer).size();
        LinePrefixingStyledTextOutput attributeOutput = this.createIndentedOutput(output, INDENT);
        if (count == 1) {
            attributeOutput.println(attributeHeader);
            Task task = tasks.iterator().next();
            String value = transformer.transform(task);
            attributeOutput.println(value == null ? "-" : value);
        } else {
            attributeOutput.println(attributeHeader + "s");
            for (Task task : tasks) {
                attributeOutput.withStyle(StyledTextOutput.Style.UserInput).text("(" + task.getPath() + ") ");
                String value = transformer.transform(task);
                attributeOutput.println(value == null ? "-" : value);
            }
        }
    }

    private void printlnCommandlineOptions(StyledTextOutput output, List<Task> tasks) {
        ArrayList<OptionDescriptor> allOptions = new ArrayList<OptionDescriptor>();
        for (Task task : tasks) {
            allOptions.addAll(this.optionReader.getOptions(task));
        }
        if (!allOptions.isEmpty()) {
            output.println();
            output.text("Options").println();
        }
        Map<String, Set<String>> optionToAvailableOptionsValues = this.optionToAvailableValues(allOptions);
        Map<String, String> optionToDescription = this.optionToDescription(allOptions);
        Iterator<String> optionNames = optionToAvailableOptionsValues.keySet().iterator();
        while (optionNames.hasNext()) {
            String currentOption = optionNames.next();
            Set<String> availableValues = optionToAvailableOptionsValues.get(currentOption);
            String optionString = "--" + currentOption;
            output.text(INDENT).withStyle(StyledTextOutput.Style.UserInput).text(optionString);
            output.text(INDENT).text(optionToDescription.get(currentOption));
            if (!availableValues.isEmpty()) {
                int optionDescriptionOffset = 2 * INDENT.length() + optionString.length();
                LinePrefixingStyledTextOutput prefixedOutput = this.createIndentedOutput(output, optionDescriptionOffset);
                prefixedOutput.println();
                prefixedOutput.println("Available values are:");
                for (String value : availableValues) {
                    prefixedOutput.text(INDENT);
                    prefixedOutput.withStyle(StyledTextOutput.Style.UserInput).println(value);
                }
            } else {
                output.println();
            }
            if (!optionNames.hasNext()) continue;
            output.println();
        }
    }

    private Map<String, Set<String>> optionToAvailableValues(List<OptionDescriptor> allOptions) {
        LinkedHashMap<String, Set<String>> result2 = new LinkedHashMap<String, Set<String>>();
        for (OptionDescriptor optionDescriptor : allOptions) {
            if (result2.containsKey(optionDescriptor.getName())) {
                Sets.SetView commonValues = Sets.intersection(optionDescriptor.getAvailableValues(), (Set)((Set)result2.get(optionDescriptor.getName())));
                result2.put(optionDescriptor.getName(), new TreeSet(commonValues));
                continue;
            }
            result2.put(optionDescriptor.getName(), optionDescriptor.getAvailableValues());
        }
        return result2;
    }

    private Map<String, String> optionToDescription(List<OptionDescriptor> allOptions) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (OptionDescriptor optionDescriptor : allOptions) {
            result2.put(optionDescriptor.getName(), optionDescriptor.getDescription());
        }
        return result2;
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, int offset) {
        return this.createIndentedOutput(output, StringUtils.leftPad((String)"", (int)offset, (char)' '));
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, String prefix) {
        return new LinePrefixingStyledTextOutput(output, prefix, false);
    }
}

