/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.BuildController;
import org.gradle.composite.internal.BuildControllers;
import org.gradle.composite.internal.DefaultBuildController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildControllers
implements BuildControllers {
    private final Map<BuildIdentifier, BuildController> controllers = new TreeMap<BuildIdentifier, BuildController>(this.idComparator());
    private final ManagedExecutor executorService;
    private final WorkerLeaseService workerLeaseService;

    DefaultBuildControllers(ManagedExecutor executorService, WorkerLeaseService workerLeaseService) {
        this.executorService = executorService;
        this.workerLeaseService = workerLeaseService;
    }

    @Override
    public BuildController getBuildController(BuildState build) {
        BuildController buildController = this.controllers.get(build.getBuildIdentifier());
        if (buildController != null) {
            return buildController;
        }
        DefaultBuildController newBuildController = new DefaultBuildController(build, this.workerLeaseService);
        this.controllers.put(build.getBuildIdentifier(), newBuildController);
        return newBuildController;
    }

    @Override
    public void populateWorkGraphs() {
        boolean tasksDiscovered = true;
        while (tasksDiscovered) {
            tasksDiscovered = false;
            for (BuildController buildController : ImmutableList.copyOf(this.controllers.values())) {
                if (!buildController.scheduleQueuedTasks()) continue;
                tasksDiscovered = true;
            }
        }
        for (BuildController buildController : this.controllers.values()) {
            buildController.finalizeWorkGraph();
        }
    }

    @Override
    public void startExecution() {
        for (BuildController buildController : this.controllers.values()) {
            buildController.startExecution(this.executorService);
        }
    }

    @Override
    public ExecutionResult<Void> awaitCompletion() {
        ExecutionResult<Void> result2 = ExecutionResult.succeeded();
        for (BuildController buildController : this.controllers.values()) {
            result2 = result2.withFailures(buildController.awaitCompletion());
        }
        return result2;
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.controllers.values()).stop();
    }

    private Comparator<BuildIdentifier> idComparator() {
        return (id1, id2) -> {
            if (id1.equals(DefaultBuildIdentifier.ROOT)) {
                if (id2.equals(DefaultBuildIdentifier.ROOT)) {
                    return 0;
                }
                return 1;
            }
            if (id2.equals(DefaultBuildIdentifier.ROOT)) {
                return -1;
            }
            return id1.getName().compareTo(id2.getName());
        };
    }
}

