/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Map;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultBuildCacheCommandFactory
implements BuildCacheCommandFactory {
    private final BuildCacheEntryPacker packer;
    private final OriginMetadataFactory originMetadataFactory;
    private final FileSystemAccess fileSystemAccess;
    private final Interner<String> stringInterner;

    public DefaultBuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, FileSystemAccess fileSystemAccess, Interner<String> stringInterner) {
        this.packer = packer;
        this.originMetadataFactory = originMetadataFactory;
        this.fileSystemAccess = fileSystemAccess;
        this.stringInterner = stringInterner;
    }

    @Override
    public BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> createLoad(BuildCacheKey cacheKey, CacheableEntity entity) {
        return new LoadCommand(cacheKey, entity);
    }

    @Override
    public BuildCacheStoreCommand createStore(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, ? extends FileSystemSnapshot> snapshots, Duration executionTime) {
        return new StoreCommand(cacheKey, entity, snapshots, executionTime);
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Map<String, ? extends FileSystemSnapshot> snapshots;
        private final Duration executionTime;

        private StoreCommand(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, ? extends FileSystemSnapshot> snapshots, Duration executionTime) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.snapshots = snapshots;
            this.executionTime = executionTime;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            BuildCacheEntryPacker.PackResult packResult = DefaultBuildCacheCommandFactory.this.packer.pack(this.entity, this.snapshots, output, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.entity, this.executionTime));
            return packResult::getEntries;
        }
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;

        private LoadCommand(BuildCacheKey cacheKey, CacheableEntity entity) {
            this.cacheKey = cacheKey;
            this.entity = entity;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> load(InputStream input) throws IOException {
            ImmutableList.Builder roots = ImmutableList.builder();
            this.entity.visitOutputTrees((name, type, root) -> roots.add((Object)root.getAbsolutePath()));
            DefaultBuildCacheCommandFactory.this.fileSystemAccess.write((Iterable<String>)roots.build(), () -> {});
            final BuildCacheEntryPacker.UnpackResult unpackResult = DefaultBuildCacheCommandFactory.this.packer.unpack(this.entity, input, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createReader(this.entity));
            final ImmutableSortedMap<String, FileSystemSnapshot> snapshots = this.snapshotUnpackedData(unpackResult.getSnapshots());
            return new BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata>(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                @Override
                public BuildCacheCommandFactory.LoadMetadata getMetadata() {
                    return new BuildCacheCommandFactory.LoadMetadata(){

                        @Override
                        public OriginMetadata getOriginMetadata() {
                            return unpackResult.getOriginMetadata();
                        }

                        @Override
                        public ImmutableSortedMap<String, FileSystemSnapshot> getResultingSnapshots() {
                            return snapshots;
                        }
                    };
                }
            };
        }

        private ImmutableSortedMap<String, FileSystemSnapshot> snapshotUnpackedData(Map<String, ? extends FileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            this.entity.visitOutputTrees((treeName, type, root) -> {
                FileSystemLocationSnapshot resultingSnapshot;
                FileSystemLocationSnapshot treeSnapshot = (FileSystemLocationSnapshot)treeSnapshots.get(treeName);
                if (treeSnapshot == null) {
                    String internedAbsolutePath = (String)DefaultBuildCacheCommandFactory.this.stringInterner.intern((Object)root.getAbsolutePath());
                    resultingSnapshot = new MissingFileSnapshot(internedAbsolutePath, FileMetadata.AccessType.DIRECT);
                } else {
                    if (type == TreeType.FILE && treeSnapshot.getType() != FileType.RegularFile) {
                        throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", new Object[]{treeName, treeSnapshot.getType()}));
                    }
                    resultingSnapshot = treeSnapshot;
                }
                DefaultBuildCacheCommandFactory.this.fileSystemAccess.record(resultingSnapshot);
                builder.put((Object)treeName, (Object)resultingSnapshot);
            });
            return builder.build();
        }
    }
}

