/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.metadata.DependencyAttributesValidator;
import org.gradle.api.publish.internal.metadata.InvalidPublicationChecker;
import org.gradle.api.publish.internal.metadata.ModuleMetadataJsonWriter;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpecBuilder;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.impldep.com.google.gson.stream.JsonWriter;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;

public class GradleModuleMetadataWriter {
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ChecksumService checksumService;
    private final String taskPath;
    private final List<DependencyAttributesValidator> dependencyAttributeValidators;

    public GradleModuleMetadataWriter(BuildInvocationScopeId buildInvocationScopeId, ProjectDependencyPublicationResolver projectDependencyResolver, ChecksumService checksumService, String taskPath, List<DependencyAttributesValidator> dependencyAttributeValidators) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.projectDependencyResolver = projectDependencyResolver;
        this.checksumService = checksumService;
        this.taskPath = taskPath;
        this.dependencyAttributeValidators = dependencyAttributeValidators;
    }

    public void writeTo(Writer writer2, PublicationInternal<?> publication, Collection<? extends PublicationInternal<?>> publications) throws IOException {
        this.writeTo(writer2, this.moduleMetadataSpecFor(publication, publications));
    }

    public void writeTo(Writer writer2, ModuleMetadataSpec metadata) throws IOException {
        JsonWriter jsonWriter = new JsonWriter(writer2);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setIndent("  ");
        new ModuleMetadataJsonWriter(jsonWriter, metadata, metadata.mustIncludeBuildId ? this.buildInvocationScopeId.getId().asString() : null, this.checksumService).write();
        jsonWriter.flush();
        writer2.append('\n');
    }

    public ModuleMetadataSpec moduleMetadataSpecFor(PublicationInternal<?> publication, Collection<? extends PublicationInternal<?>> publications) {
        InvalidPublicationChecker checker = new InvalidPublicationChecker(publication.getName(), this.taskPath);
        ModuleMetadataSpec spec = new ModuleMetadataSpecBuilder(publication, publications, checker, this.projectDependencyResolver, this.dependencyAttributeValidators).build();
        checker.validate();
        return spec;
    }
}

