/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.internal.JvmModelingServices;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectTestFixtures;

public class JavaTestFixturesPlugin
implements Plugin<Project> {
    private final JvmModelingServices jvmEcosystemUtilities;

    @Inject
    public JavaTestFixturesPlugin(JvmModelingServices jvmModelingServices) {
        this.jvmEcosystemUtilities = jvmModelingServices;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            this.jvmEcosystemUtilities.createJvmVariant("testFixtures", builder -> builder.exposesApi().published());
            this.createImplicitTestFixturesDependencies(project, this.findJavaExtension(project));
        });
    }

    private void createImplicitTestFixturesDependencies(Project project, JavaPluginExtension extension) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("testFixturesApi", dependencies.create(project));
        SourceSet testSourceSet = this.findTestSourceSet(extension);
        ProjectDependency testDependency = (ProjectDependency)dependencies.add(testSourceSet.getImplementationConfigurationName(), dependencies.create(project));
        testDependency.capabilities(new ProjectTestFixtures(project));
        ConfigurationContainer configurations = project.getConfigurations();
        testSourceSet.setCompileClasspath(project.getObjects().fileCollection().from(configurations.getByName("testCompileClasspath")));
        testSourceSet.setRuntimeClasspath(project.getObjects().fileCollection().from(testSourceSet.getOutput(), configurations.getByName("testRuntimeClasspath")));
    }

    private SourceSet findTestSourceSet(JavaPluginExtension extension) {
        return (SourceSet)extension.getSourceSets().getByName("test");
    }

    private JavaPluginExtension findJavaExtension(Project project) {
        return project.getExtensions().getByType(JavaPluginExtension.class);
    }
}

