/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.io.Serializable;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.TestState;
import org.gradle.api.tasks.testing.TestResult;

public class DefaultTestResult
implements TestResult,
Serializable {
    private final List<Throwable> failures;
    private final TestResult.ResultType resultType;
    private final long startTime;
    private final long endTime;
    private final long testCount;
    private final long successfulCount;
    private final long failedCount;

    public DefaultTestResult(TestState state2) {
        this(state2.resultType, state2.getStartTime(), state2.getEndTime(), state2.testCount, state2.successfulCount, state2.failedCount, state2.failures);
    }

    public DefaultTestResult(TestResult.ResultType resultType, long startTime, long endTime, long testCount, long successfulCount, long failedCount, List<Throwable> failures) {
        this.resultType = resultType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.testCount = testCount;
        this.successfulCount = successfulCount;
        this.failedCount = failedCount;
        this.failures = failures;
    }

    @Override
    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    @Override
    public Throwable getException() {
        return this.failures.isEmpty() ? null : this.failures.get(0);
    }

    @Override
    public List<Throwable> getExceptions() {
        return this.failures;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getTestCount() {
        return this.testCount;
    }

    @Override
    public long getSuccessfulTestCount() {
        return this.successfulCount;
    }

    @Override
    public long getSkippedTestCount() {
        return this.testCount - this.successfulCount - this.failedCount;
    }

    @Override
    public long getFailedTestCount() {
        return this.failedCount;
    }

    public String toString() {
        return this.resultType.toString();
    }
}

