/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.taskgraph.TaskListenerInternal;
import org.gradle.internal.logging.slf4j.ContextAwareTaskLogger;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CallableBuildOperation;

public class EventFiringTaskExecuter
implements TaskExecuter {
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskExecutionListener taskExecutionListener;
    private final TaskListenerInternal taskListener;
    private final TaskExecuter delegate;

    public EventFiringTaskExecuter(BuildOperationExecutor buildOperationExecutor, TaskExecutionListener taskExecutionListener, TaskListenerInternal taskListener, TaskExecuter delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.taskExecutionListener = taskExecutionListener;
        this.taskListener = taskListener;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(final TaskInternal task, final TaskStateInternal state2, final TaskExecutionContext context) {
        return this.buildOperationExecutor.call(new CallableBuildOperation<TaskExecuterResult>(){

            @Override
            public TaskExecuterResult call(BuildOperationContext operationContext) {
                TaskExecuterResult result2 = this.executeTask(operationContext);
                operationContext.setStatus(state2.getFailure() != null ? "FAILED" : state2.getSkipMessage());
                operationContext.failed(state2.getFailure());
                return result2;
            }

            private TaskExecuterResult executeTask(BuildOperationContext operationContext) {
                Logger logger = task.getLogger();
                ContextAwareTaskLogger contextAwareTaskLogger = null;
                try {
                    EventFiringTaskExecuter.this.taskListener.beforeExecute(task.getTaskIdentity());
                    EventFiringTaskExecuter.this.taskExecutionListener.beforeExecute(task);
                    if (logger instanceof ContextAwareTaskLogger) {
                        contextAwareTaskLogger = (ContextAwareTaskLogger)logger;
                        BuildOperationRef currentOperation = EventFiringTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                        contextAwareTaskLogger.setFallbackBuildOperationId(currentOperation.getId());
                    }
                }
                catch (Throwable t) {
                    state2.setOutcome(new TaskExecutionException(task, t));
                    return TaskExecuterResult.WITHOUT_OUTPUTS;
                }
                TaskExecuterResult result2 = EventFiringTaskExecuter.this.delegate.execute(task, state2, context);
                if (contextAwareTaskLogger != null) {
                    contextAwareTaskLogger.setFallbackBuildOperationId(null);
                }
                operationContext.setResult(new ExecuteTaskBuildOperationResult(state2, result2.getCachingState(), result2.getReusedOutputOriginMetadata().orElse(null), result2.executedIncrementally(), result2.getExecutionReasons()));
                try {
                    EventFiringTaskExecuter.this.taskExecutionListener.afterExecute(task, state2);
                    EventFiringTaskExecuter.this.taskListener.afterExecute(task.getTaskIdentity(), state2);
                }
                catch (Throwable t) {
                    state2.addFailure(new TaskExecutionException(task, t));
                }
                return result2;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                ExecuteTaskBuildOperationDetails taskOperation = new ExecuteTaskBuildOperationDetails(context.getLocalTaskNode());
                return BuildOperationDescriptor.displayName("Task " + task.getIdentityPath()).name(task.getIdentityPath().toString()).progressDisplayName(task.getIdentityPath().toString()).metadata(BuildOperationCategory.TASK).details(taskOperation);
            }
        });
    }
}

