/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.FileNameDerivingClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.base.MoreObjects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.work.FileChange;

abstract class AbstractRecompilationSpecProvider
implements RecompilationSpecProvider {
    private final Deleter deleter;
    private final FileOperations fileOperations;
    private final FileTree sourceTree;
    private final Iterable<FileChange> sourceChanges;
    private final boolean incremental;

    public AbstractRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sourceTree, Iterable<FileChange> sourceChanges, boolean incremental) {
        this.deleter = deleter;
        this.fileOperations = fileOperations;
        this.sourceTree = sourceTree;
        this.sourceChanges = sourceChanges;
        this.incremental = incremental;
    }

    @Override
    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec(previous);
        SourceFileClassNameConverter sourceFileClassNameConverter = this.getSourceFileClassNameConverter(previous);
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(current, previous, spec, sourceFileClassNameConverter);
        spec.addClassesToProcess(previous.getTypesToReprocess(spec.getClassesToCompile()));
        return spec;
    }

    @Override
    public boolean initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable<File>)ImmutableSet.of());
            spec.setClasses(Collections.emptySet());
            return false;
        }
        PatternSet classesToDelete = this.fileOperations.patternSet();
        PatternSet sourceToCompile = this.fileOperations.patternSet();
        SourceFileClassNameConverter sourceFileClassNameConverter = this.getSourceFileClassNameConverter(recompilationSpec.getPreviousCompilation());
        this.prepareFilePatterns(recompilationSpec.getClassesToCompile(), classesToDelete, sourceToCompile, sourceFileClassNameConverter);
        spec.setSourceFiles(this.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        boolean cleanedAnyOutput = this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
        cleanedAnyOutput |= this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory());
        cleanedAnyOutput |= this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getHeaderOutputDirectory());
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = AbstractRecompilationSpecProvider.prepareResourcePatterns(recompilationSpec.getResourcesToGenerate(), this.fileOperations);
        cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), spec.getDestinationDir());
        cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory(), (Object)spec.getDestinationDir()));
        return cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), spec.getCompileOptions().getHeaderOutputDirectory());
    }

    private Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching(sourceToCompile);
    }

    private static Map<GeneratedResource.Location, PatternSet> prepareResourcePatterns(Collection<GeneratedResource> staleResources, FileOperations fileOperations) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        for (GeneratedResource.Location location : GeneratedResource.Location.values()) {
            resourcesByLocation.put(location, fileOperations.patternSet());
        }
        for (GeneratedResource resource : staleResources) {
            ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(resource.getPath());
        }
        return resourcesByLocation;
    }

    private void processOtherChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec, SourceFileClassNameConverter sourceFileClassNameConverter) {
        if (spec.isFullRebuildNeeded()) {
            return;
        }
        SourceFileChangeProcessor sourceFileChangeProcessor = new SourceFileChangeProcessor(previous);
        for (FileChange fileChange : this.sourceChanges) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            if (fileChange.getFileType() != FileType.FILE) continue;
            String relativeFilePath = fileChange.getNormalizedPath();
            Set<String> changedClasses = sourceFileClassNameConverter.getClassNames(relativeFilePath);
            if (changedClasses.isEmpty() && !this.isIncrementalOnResourceChanges(current)) {
                spec.setFullRebuildCause(this.rebuildClauseForChangedNonSourceFile(fileChange));
            }
            sourceFileChangeProcessor.processChange(changedClasses, spec);
        }
    }

    protected abstract boolean isIncrementalOnResourceChanges(CurrentCompilation var1);

    private void prepareFilePatterns(Collection<String> staleClasses, PatternSet filesToDelete, PatternSet sourceToCompile, SourceFileClassNameConverter sourceFileClassNameConverter) {
        for (String staleClass : staleClasses) {
            for (String sourcePath : sourceFileClassNameConverter.getRelativeSourcePaths(staleClass)) {
                filesToDelete.include(sourcePath);
                sourceToCompile.include(sourcePath);
            }
            filesToDelete.include(staleClass.replaceAll("\\.", "/").concat(".class"));
            filesToDelete.include(staleClass.replaceAll("[.$]", "_").concat(".h"));
        }
    }

    private void processClasspathChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        DependentsSet dependents = current.findDependentsOfClasspathChanges(previous);
        if (dependents.isDependencyToAll()) {
            spec.setFullRebuildCause(dependents.getDescription());
            return;
        }
        spec.addClassesToCompile(dependents.getPrivateDependentClasses());
        spec.addClassesToCompile(dependents.getAccessibleDependentClasses());
        spec.addResourcesToGenerate(dependents.getDependentResources());
    }

    private boolean deleteStaleFilesIn(PatternSet filesToDelete, File destinationDir) {
        if (filesToDelete == null || filesToDelete.isEmpty() || destinationDir == null) {
            return false;
        }
        Set<File> toDelete = this.fileOperations.fileTree(destinationDir).matching(filesToDelete).getFiles();
        return StaleOutputCleaner.cleanOutputs(this.deleter, toDelete, destinationDir);
    }

    private void addClassesToProcess(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        HashSet<String> classesToProcess = new HashSet<String>(recompilationSpec.getClassesToProcess());
        classesToProcess.removeAll(recompilationSpec.getClassesToCompile());
        spec.setClasses(classesToProcess);
    }

    private void includePreviousCompilationOutputOnClasspath(JavaCompileSpec spec) {
        ArrayList<File> classpath = new ArrayList<File>(spec.getCompileClasspath());
        File destinationDir = spec.getDestinationDir();
        classpath.add(destinationDir);
        spec.setCompileClasspath(classpath);
    }

    private String rebuildClauseForChangedNonSourceFile(FileChange fileChange) {
        return String.format("%s '%s' has been %s", "resource", fileChange.getFile().getName(), fileChange.getChangeType().name().toLowerCase(Locale.US));
    }

    private SourceFileClassNameConverter getSourceFileClassNameConverter(PreviousCompilation previousCompilation) {
        return new FileNameDerivingClassNameConverter(previousCompilation.getSourceToClassConverter(), this.getFileExtensions());
    }

    protected abstract Set<String> getFileExtensions();

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }
}

