/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.gradle.api.GradleException;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.GroovyCompileTransformingClassLoader;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.internal.VersionNumber;

public class ApiGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec>,
Serializable {
    private final Compiler<JavaCompileSpec> javaCompiler;
    private final ProjectLayout projectLayout;

    public ApiGroovyCompiler(Compiler<JavaCompileSpec> javaCompiler, ProjectLayout projectLayout) {
        this.javaCompiler = javaCompiler;
        this.projectLayout = projectLayout;
    }

    private File[] getSortedSourceFiles(GroovyJavaJointCompileSpec spec) {
        Object[] sortedSourceFiles = (File[])Iterables.toArray(spec.getSourceFiles(), File.class);
        Arrays.sort(sortedSourceFiles);
        return sortedSourceFiles;
    }

    @Override
    public WorkResult execute(final GroovyJavaJointCompileSpec spec) {
        ApiCompilerResult apiCompilerResult;
        final ApiCompilerResult result2 = new ApiCompilerResult();
        result2.getAnnotationProcessingResult().setFullRebuildCause("Incremental annotation processing is not supported by Groovy.");
        GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
        ClassLoader compilerClassLoader = this.getClass().getClassLoader();
        GroovySystemLoader compilerGroovyLoader = groovySystemLoaderFactory.forClassLoader(compilerClassLoader);
        CompilerConfiguration configuration2 = new CompilerConfiguration();
        configuration2.setVerbose(spec.getGroovyCompileOptions().isVerbose());
        configuration2.setSourceEncoding(spec.getGroovyCompileOptions().getEncoding());
        configuration2.setTargetBytecode(spec.getTargetCompatibility());
        configuration2.setTargetDirectory(spec.getDestinationDir());
        this.canonicalizeValues(spec.getGroovyCompileOptions().getOptimizationOptions());
        VersionNumber version = this.parseGroovyVersion();
        if (version.compareTo(VersionNumber.parse("2.5")) >= 0) {
            configuration2.setParameters(spec.getGroovyCompileOptions().isParameters());
        } else if (spec.getGroovyCompileOptions().isParameters()) {
            throw new GradleException("Using Groovy compiler flag '--parameters' requires Groovy 2.5+ but found Groovy " + version);
        }
        IncrementalCompilationCustomizer customizer = IncrementalCompilationCustomizer.fromSpec(spec, result2);
        customizer.addToConfiguration(configuration2);
        if (spec.getGroovyCompileOptions().getConfigurationScript() != null) {
            this.applyConfigurationScript(spec.getGroovyCompileOptions().getConfigurationScript(), configuration2);
        }
        try {
            configuration2.setOptimizationOptions(spec.getGroovyCompileOptions().getOptimizationOptions());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            configuration2.setDisabledGlobalASTTransformations(spec.getGroovyCompileOptions().getDisabledGlobalASTTransformations());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        HashMap<String, Comparable<File>> jointCompilationOptions = new HashMap<String, Comparable<File>>();
        final File stubDir = spec.getGroovyCompileOptions().getStubDir();
        stubDir.mkdirs();
        jointCompilationOptions.put("stubDir", stubDir);
        jointCompilationOptions.put("keepStubs", Boolean.valueOf(spec.getGroovyCompileOptions().isKeepStubs()));
        configuration2.setJointCompilationOptions(jointCompilationOptions);
        ClassLoader classPathLoader = version.compareTo(VersionNumber.parse("2.0")) < 0 ? new GroovyCompileTransformingClassLoader(this.getExtClassLoader(), DefaultClassPath.of(spec.getCompileClasspath())) : new DefaultClassLoaderFactory().createIsolatedClassLoader("api-groovy-compile-loader", DefaultClassPath.of(spec.getCompileClasspath()));
        GroovyClassLoader compileClasspathClassLoader = new GroovyClassLoader(classPathLoader, null);
        GroovySystemLoader compileClasspathLoader = groovySystemLoaderFactory.forClassLoader(classPathLoader);
        FilteringClassLoader.Spec groovyCompilerClassLoaderSpec = new FilteringClassLoader.Spec();
        groovyCompilerClassLoaderSpec.allowPackage("org.codehaus.groovy");
        groovyCompilerClassLoaderSpec.allowPackage("groovy");
        groovyCompilerClassLoaderSpec.allowPackage("groovyjarjarasm");
        groovyCompilerClassLoaderSpec.disallowClass("groovy.util.GroovyTestCase");
        groovyCompilerClassLoaderSpec.disallowClass("org.codehaus.groovy.transform.NotYetImplementedASTTransformation");
        groovyCompilerClassLoaderSpec.disallowPackage("groovy.servlet");
        FilteringClassLoader groovyCompilerClassLoader = new FilteringClassLoader(GroovyClassLoader.class.getClassLoader(), groovyCompilerClassLoaderSpec);
        final GroovyClassLoader astTransformClassLoader = new GroovyClassLoader((ClassLoader)groovyCompilerClassLoader, null);
        for (File file : spec.getCompileClasspath()) {
            astTransformClassLoader.addClasspath(file.getPath());
        }
        JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(configuration2, compileClasspathClassLoader){

            public GroovyClassLoader getTransformLoader() {
                return astTransformClassLoader;
            }
        };
        final boolean shouldProcessAnnotations = ApiGroovyCompiler.shouldProcessAnnotations(spec);
        if (shouldProcessAnnotations) {
            unit.addSources(new File[]{new File("ForceStubGeneration.java")});
        }
        unit.addSources(this.getSortedSourceFiles(spec));
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        if (shouldProcessAnnotations) {
                            spec.setSourceFiles(Iterables.concat(spec.getSourceFiles(), (Iterable)ApiGroovyCompiler.this.projectLayout.files(stubDir).getAsFileTree()));
                        } else {
                            ImmutableList.Builder sourcepathBuilder = ImmutableList.builder();
                            sourcepathBuilder.add((Object)stubDir);
                            if (spec.getCompileOptions().getSourcepath() != null) {
                                sourcepathBuilder.addAll(spec.getCompileOptions().getSourcepath());
                            }
                            spec.getCompileOptions().setSourcepath((List<File>)sourcepathBuilder.build());
                        }
                        spec.setSourceFiles(Iterables.filter(spec.getSourceFiles(), (Predicate)new Predicate<File>(){

                            public boolean apply(File file) {
                                return FileUtils.hasExtension(file, ".java");
                            }
                        }));
                        try {
                            WorkResult javaCompilerResult = ApiGroovyCompiler.this.javaCompiler.execute(spec);
                            if (javaCompilerResult instanceof ApiCompilerResult) {
                                result2.getSourceClassesMapping().putAll(((ApiCompilerResult)javaCompilerResult).getSourceClassesMapping());
                            }
                        }
                        catch (CompilationFailedException e) {
                            cu.getErrorCollector().addFatalError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)cu));
                        }
                    }
                };
            }
        });
        try {
            unit.compile();
            apiCompilerResult = result2;
            compilerGroovyLoader.discardTypesFrom(classPathLoader);
            compilerGroovyLoader.discardTypesFrom((ClassLoader)astTransformClassLoader);
            compileClasspathLoader.shutdown();
        }
        catch (org.codehaus.groovy.control.CompilationFailedException e) {
            try {
                System.err.println(e.getMessage());
                System.err.flush();
                throw new CompilationFailedException();
            }
            catch (Throwable throwable) {
                compilerGroovyLoader.discardTypesFrom(classPathLoader);
                compilerGroovyLoader.discardTypesFrom((ClassLoader)astTransformClassLoader);
                compileClasspathLoader.shutdown();
                CompositeStoppable.stoppable(classPathLoader, astTransformClassLoader).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable(classPathLoader, astTransformClassLoader).stop();
        return apiCompilerResult;
    }

    private static boolean shouldProcessAnnotations(GroovyJavaJointCompileSpec spec) {
        return spec.getGroovyCompileOptions().isJavaAnnotationProcessing() && spec.annotationProcessingConfigured();
    }

    private void applyConfigurationScript(File configScript, CompilerConfiguration configuration2) {
        VersionNumber version = this.parseGroovyVersion();
        if (version.compareTo(VersionNumber.parse("2.1")) < 0) {
            throw new GradleException("Using a Groovy compiler configuration script requires Groovy 2.1+ but found Groovy " + version + "");
        }
        Binding binding = new Binding();
        binding.setVariable("configuration", (Object)configuration2);
        CompilerConfiguration configuratorConfig = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars(new String[]{"org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder"});
        configuratorConfig.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        GroovyShell shell = new GroovyShell(binding, configuratorConfig);
        try {
            shell.evaluate(configScript);
        }
        catch (Exception e) {
            throw new GradleException("Could not execute Groovy compiler configuration script: " + configScript.getAbsolutePath(), e);
        }
    }

    private VersionNumber parseGroovyVersion() {
        String version;
        try {
            version = GroovySystem.getVersion();
        }
        catch (NoSuchMethodError e) {
            try {
                Class<?> ih = Class.forName("org.codehaus.groovy.runtime.InvokerHelper");
                Method getVersion = ih.getDeclaredMethod("getVersion", new Class[0]);
                version = (String)getVersion.invoke(ih, new Object[0]);
            }
            catch (Exception e1) {
                throw new GradleException("Unable to determine Groovy version.", e1);
            }
        }
        return VersionNumber.parse(version);
    }

    private void canonicalizeValues(Map<String, Boolean> options) {
        for (String key : options.keySet()) {
            boolean value = options.get(key);
            options.put(key, value);
        }
    }

    private ClassLoader getExtClassLoader() {
        return ClassLoaderUtils.getPlatformClassLoader();
    }

    private static class TrackingClassGenerationCompilationCustomizer
    extends IncrementalCompilationCustomizer {
        private final CompilationSourceDirs compilationSourceDirs;
        private final ApiCompilerResult result;

        private TrackingClassGenerationCompilationCustomizer(CompilationSourceDirs compilationSourceDirs, ApiCompilerResult result2) {
            this.compilationSourceDirs = compilationSourceDirs;
            this.result = result2;
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
            this.inspectClassNode(source, classNode);
        }

        private void inspectClassNode(SourceUnit sourceUnit, ClassNode classNode) {
            String relativePath = this.compilationSourceDirs.relativize(new File(sourceUnit.getSource().getURI().getPath())).orElseThrow(IllegalStateException::new);
            this.result.getSourceClassesMapping().computeIfAbsent(relativePath, key -> new HashSet()).add(classNode.getName());
            Iterator iterator = classNode.getInnerClasses();
            while (iterator.hasNext()) {
                this.inspectClassNode(sourceUnit, (ClassNode)iterator.next());
            }
        }

        @Override
        public void addToConfiguration(CompilerConfiguration configuration2) {
            configuration2.addCompilationCustomizers(new CompilationCustomizer[]{this});
        }
    }

    private static class NoOpCompilationCustomizer
    extends IncrementalCompilationCustomizer {
        private NoOpCompilationCustomizer() {
        }

        @Override
        public void addToConfiguration(CompilerConfiguration configuration2) {
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws org.codehaus.groovy.control.CompilationFailedException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class IncrementalCompilationCustomizer
    extends CompilationCustomizer {
        static IncrementalCompilationCustomizer fromSpec(GroovyJavaJointCompileSpec spec, ApiCompilerResult result2) {
            if (spec.incrementalCompilationEnabled()) {
                return new TrackingClassGenerationCompilationCustomizer(new CompilationSourceDirs(spec), result2);
            }
            return new NoOpCompilationCustomizer();
        }

        public IncrementalCompilationCustomizer() {
            super(CompilePhase.CLASS_GENERATION);
        }

        abstract void addToConfiguration(CompilerConfiguration var1);
    }
}

