/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.model;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class Checksum {
    private final ChecksumKind kind;
    private final String value;
    private final Set<String> alternatives;
    private final String origin;
    private final int hashCode;

    public Checksum(ChecksumKind kind, String value, @Nullable Set<String> alternatives, @Nullable String origin) {
        this.kind = kind;
        this.value = value;
        this.alternatives = alternatives == null ? null : ImmutableSet.copyOf(alternatives);
        this.origin = origin;
        this.hashCode = this.computeHashcode();
    }

    private int computeHashcode() {
        int result2 = this.kind.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        result2 = 31 * result2 + (this.alternatives != null ? this.alternatives.hashCode() : 0);
        result2 = 31 * result2 + (this.origin != null ? this.origin.hashCode() : 0);
        return result2;
    }

    public ChecksumKind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public Set<String> getAlternatives() {
        return this.alternatives;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checksum checksum = (Checksum)o;
        if (this.kind != checksum.kind) {
            return false;
        }
        if (!this.value.equals(checksum.value)) {
            return false;
        }
        if (!Objects.equals(this.alternatives, checksum.alternatives)) {
            return false;
        }
        return Objects.equals(this.origin, checksum.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

