/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.PatternBasedResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.MetadataSourcedComponentArtifacts;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class IvyResolver
extends ExternalResourceResolver<IvyModuleResolveMetadata>
implements PatternBasedResolver {
    private final boolean dynamicResolve;
    private boolean m2Compatible;
    private final IvyLocalRepositoryAccess localRepositoryAccess;
    private final IvyRemoteRepositoryAccess remoteRepositoryAccess;

    public IvyResolver(String name, RepositoryTransport transport, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, boolean dynamicResolve, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, @Nullable InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory, @Nullable InstantiatingAction<ComponentMetadataListerDetails> componentMetadataVersionListerFactory, ImmutableMetadataSources repositoryContentFilter, MetadataArtifactProvider metadataArtifactProvider, Instantiator injector, ChecksumService checksumService) {
        super(name, transport.isLocal(), transport.getRepository(), transport.getResourceAccessor(), locallyAvailableResourceFinder, artifactFileStore, repositoryContentFilter, metadataArtifactProvider, componentMetadataSupplierFactory, componentMetadataVersionListerFactory, injector, checksumService);
        this.dynamicResolve = dynamicResolve;
        this.localRepositoryAccess = new IvyLocalRepositoryAccess();
        this.remoteRepositoryAccess = new IvyRemoteRepositoryAccess();
    }

    public String toString() {
        return "Ivy repository '" + this.getName() + "'";
    }

    @Override
    protected void appendId(Hasher hasher) {
        super.appendId(hasher);
        hasher.putBoolean(this.isM2compatible());
    }

    @Override
    protected Class<IvyModuleResolveMetadata> getSupportedMetadataType() {
        return IvyModuleResolveMetadata.class;
    }

    @Override
    public boolean isDynamicResolveMode() {
        return this.dynamicResolve;
    }

    @Override
    protected boolean isMetaDataArtifact(ArtifactType artifactType) {
        return artifactType == ArtifactType.IVY_DESCRIPTOR;
    }

    public boolean isM2compatible() {
        return this.m2Compatible;
    }

    @Override
    public void setM2compatible(boolean m2compatible) {
        this.m2Compatible = m2compatible;
    }

    @Override
    public void addArtifactLocation(URI baseUri, String pattern) {
        this.addArtifactPattern(this.toResourcePattern(baseUri, pattern));
    }

    @Override
    public void addDescriptorLocation(URI baseUri, String pattern) {
        this.addIvyPattern(this.toResourcePattern(baseUri, pattern));
    }

    private ResourcePattern toResourcePattern(URI baseUri, String pattern) {
        return this.isM2compatible() ? new M2ResourcePattern(baseUri, pattern) : new IvyResourcePattern(baseUri, pattern);
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.localRepositoryAccess;
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remoteRepositoryAccess;
    }

    private class IvyRemoteRepositoryAccess
    extends ExternalResourceResolver.RemoteRepositoryAccess {
        private IvyRemoteRepositoryAccess() {
        }

        protected void resolveModuleArtifacts(IvyModuleResolveMetadata module, ConfigurationMetadata variant, BuildableComponentArtifactsResolveResult result2) {
        }

        protected void resolveJavadocArtifacts(IvyModuleResolveMetadata module, BuildableArtifactSetResolveResult result2) {
            result2.resolved(IvyResolver.this.findOptionalArtifacts(module, "javadoc", "javadoc"));
        }

        protected void resolveSourceArtifacts(IvyModuleResolveMetadata module, BuildableArtifactSetResolveResult result2) {
            result2.resolved(IvyResolver.this.findOptionalArtifacts(module, "source", "sources"));
        }
    }

    private class IvyLocalRepositoryAccess
    extends ExternalResourceResolver.LocalRepositoryAccess {
        private IvyLocalRepositoryAccess() {
        }

        protected void resolveModuleArtifacts(IvyModuleResolveMetadata module, ConfigurationMetadata variant, BuildableComponentArtifactsResolveResult result2) {
            result2.resolved(new MetadataSourcedComponentArtifacts());
        }

        protected void resolveJavadocArtifacts(IvyModuleResolveMetadata module, BuildableArtifactSetResolveResult result2) {
            ConfigurationMetadata configuration2 = module.getConfiguration("javadoc");
            if (configuration2 != null) {
                result2.resolved(configuration2.getArtifacts());
            }
        }

        protected void resolveSourceArtifacts(IvyModuleResolveMetadata module, BuildableArtifactSetResolveResult result2) {
            ConfigurationMetadata configuration2 = module.getConfiguration("sources");
            if (configuration2 != null) {
                result2.resolved(configuration2.getArtifacts());
            }
        }
    }
}

