/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.util.concurrent.ExecutionException;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.internal.Describables;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;

public class CachingComponentSelectionDescriptorFactory
implements ComponentSelectionDescriptorFactory {
    private final Cache<Key, ComponentSelectionDescriptor> descriptors = CacheBuilder.newBuilder().maximumSize(10000L).build();

    @Override
    public ComponentSelectionDescriptor newDescriptor(ComponentSelectionCause cause, String reason) {
        return this.getOrCreate(cause, reason);
    }

    @Override
    public ComponentSelectionDescriptor newDescriptor(ComponentSelectionCause cause) {
        try {
            return (ComponentSelectionDescriptor)this.descriptors.get((Object)new Key(cause, cause.getDefaultReason()), () -> new DefaultComponentSelectionDescriptor(cause));
        }
        catch (ExecutionException e) {
            return new DefaultComponentSelectionDescriptor(cause);
        }
    }

    private ComponentSelectionDescriptor getOrCreate(ComponentSelectionCause cause, String description) {
        try {
            return (ComponentSelectionDescriptor)this.descriptors.get((Object)new Key(cause, description), () -> this.newDescriptorInstance(cause, description));
        }
        catch (ExecutionException e) {
            return this.newDescriptorInstance(cause, description);
        }
    }

    private ComponentSelectionDescriptor newDescriptorInstance(ComponentSelectionCause cause, String description) {
        return new DefaultComponentSelectionDescriptor(cause, Describables.of(description));
    }

    private static class Key {
        private final ComponentSelectionCause cause;
        private final String description;

        private Key(ComponentSelectionCause cause, String description) {
            this.cause = cause;
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.cause != key.cause) {
                return false;
            }
            return this.description.equals(key.description);
        }

        public int hashCode() {
            int result2 = this.cause.hashCode();
            result2 = 31 * result2 + this.description.hashCode();
            return result2;
        }
    }
}

