/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.projector;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.lang.ClassPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/projector/PluginClassPathRuntimeCustomizer;", "Lcom/intellij/ide/ApplicationInitializedListener;", "()V", "componentsInitialized", "", "intellij.cwm.plugin.projector"})
public final class PluginClassPathRuntimeCustomizer
implements ApplicationInitializedListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentsInitialized() {
        boolean shouldAddProjectorLibsToPluginClassloader = false;
        ClassLoader classLoader = PluginClassPathRuntimeCustomizer.class.getClassLoader();
        if (!(classLoader instanceof PluginClassLoader)) {
            classLoader = null;
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)classLoader;
        if (pluginClassLoader == null) {
            return;
        }
        PluginClassLoader myClassLoader = pluginClassLoader;
        try {
            Class.forName("org.jetbrains.projector.server.ProjectorServer", false, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            shouldAddProjectorLibsToPluginClassloader = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            shouldAddProjectorLibsToPluginClassloader = true;
        }
        if (shouldAddProjectorLibsToPluginClassloader) {
            Path projectorLibsPath;
            ClassPath classPath = myClassLoader.getClassPath();
            Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"myClassLoader.classPath");
            List list = classPath.getBaseUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"myClassLoader.classPath.baseUrls");
            List baseUrls = list;
            PluginDescriptor pluginDescriptor = myClassLoader.getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"myClassLoader.pluginDescriptor");
            Path path = projectorLibsPath = pluginDescriptor.getPluginPath().resolve("lib/projector");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectorLibsPath");
            Object object = path;
            Object object2 = new LinkOption[]{};
            if (Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
                object = Files.list(projectorLibsPath);
                object2 = null;
                try {
                    Stream libs = (Stream)object;
                    boolean bl = false;
                    List list2 = libs.collect(Collectors.toList());
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"libs.collect(Collectors.toList())");
                    boolean bl2 = baseUrls.addAll(list2);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
                }
            }
            myClassLoader.getClassPath().reset(baseUrls);
            if (myClassLoader.getLoadedClassCount() != 1L) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(PluginClassPathRuntimeCustomizer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("There was more than one class loaded in Projector Plugin classloader - this is likely a bug!");
            }
        }
    }
}

