/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.JumpInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.data.instructions.SwitchInstructions;
import com.intellij.rt.coverage.util.ClassListSection;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionsSection
extends ClassListSection {
    final ProjectData myProjectData;

    public InstructionsSection(ProjectData projectData) {
        this.myProjectData = projectData;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isEngaged(ProjectData projectData) {
        return !projectData.isSampling() && projectData.isInstructionsCoverageEnabled();
    }

    @Override
    public void load(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict, int version) throws IOException {
        projectData.setInstructionsCoverage(true);
        super.load(projectData, in, dict, version);
    }

    @Override
    protected void loadClass(DataInputStream in, ClassData classData, int version) throws IOException {
        LineData[] lines = (LineData[])classData.getLines();
        LineInstructions[] instructions = new LineInstructions[lines.length];
        for (LineData lineData : lines) {
            int i;
            LineInstructions lineInstructions;
            if (lineData == null) continue;
            instructions[lineData.getLineNumber()] = lineInstructions = new LineInstructions();
            lineInstructions.setInstructions(CoverageIOUtil.readINT(in));
            for (i = 0; i < lineData.jumpsCount(); ++i) {
                JumpInstructions jump = new JumpInstructions();
                lineInstructions.addJump(jump);
                jump.setInstructions(true, CoverageIOUtil.readINT(in));
                jump.setInstructions(false, CoverageIOUtil.readINT(in));
            }
            for (i = 0; i < lineData.switchesCount(); ++i) {
                SwitchData switchData = lineData.getSwitchData(i);
                int size = switchData.getKeys().length;
                SwitchInstructions switchInstructions = new SwitchInstructions(size);
                lineInstructions.addSwitch(switchInstructions);
                for (int key = -1; key < size; ++key) {
                    switchInstructions.setInstructions(key, CoverageIOUtil.readINT(in));
                }
            }
        }
        this.myProjectData.getInstructions().put(classData.getName(), new ClassInstructions(instructions));
    }

    @Override
    protected void saveClass(ClassData classData, DataOutput out, int index) throws IOException {
        ClassInstructions classInstructions = this.myProjectData.getInstructions().get(classData.getName());
        LineData[] lines = (LineData[])classData.getLines();
        if (lines == null) {
            return;
        }
        CoverageIOUtil.writeINT(out, index);
        LineInstructions[] lineInstructions = classInstructions.getlines();
        for (int line = 0; line < lines.length; ++line) {
            LineData lineData = lines[line];
            if (lineData == null) continue;
            LineInstructions lineInstruction = line >= lineInstructions.length ? null : lineInstructions[line];
            CoverageIOUtil.writeINT(out, lineInstruction == null ? 0 : lineInstruction.getInstructions());
            List<JumpInstructions> jumps = lineInstruction == null ? null : lineInstruction.getJumps();
            for (int i = 0; i < lineData.jumpsCount(); ++i) {
                JumpInstructions jumpInstructions = jumps == null || i >= jumps.size() ? null : jumps.get(i);
                CoverageIOUtil.writeINT(out, jumpInstructions == null ? 0 : jumpInstructions.getInstructions(true));
                CoverageIOUtil.writeINT(out, jumpInstructions == null ? 0 : jumpInstructions.getInstructions(false));
            }
            List<SwitchInstructions> switches = lineInstruction == null ? null : lineInstruction.getSwitches();
            for (int i = 0; i < lineData.switchesCount(); ++i) {
                SwitchInstructions switchInstructions = switches == null || i >= switches.size() ? null : switches.get(i);
                for (int key = -1; key < lineData.getSwitchData(i).getKeys().length; ++key) {
                    CoverageIOUtil.writeINT(out, switchInstructions == null ? 0 : switchInstructions.getInstructions(key));
                }
            }
        }
    }
}

