/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.coverage.gnu.trove.THashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntellijClassfileTransformer
implements ClassFileTransformer {
    private final boolean computeFrames = this.computeFrames();
    private final WeakHashMap<ClassLoader, Map<String, ClassReader>> classReaders = new WeakHashMap();
    private long ourTime;
    private int ourClassCount;

    protected AbstractIntellijClassfileTransformer() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                double allTime = 1.0 * (double)AbstractIntellijClassfileTransformer.this.ourTime / 1.0E9;
                ErrorReporter.logInfo("Class transformation time: " + allTime + "s for " + AbstractIntellijClassfileTransformer.this.ourClassCount + " classes or " + allTime / (double)AbstractIntellijClassfileTransformer.this.ourClassCount + "s per class");
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        long s = System.nanoTime();
        try {
            byte[] byArray = this.transformInner(loader, className, classFileBuffer);
            return byArray;
        }
        finally {
            ++this.ourClassCount;
            this.ourTime += System.nanoTime() - s;
        }
    }

    private byte[] transformInner(ClassLoader loader, String className, byte[] classFileBuffer) {
        if (this.isStopped()) {
            return null;
        }
        try {
            if (className == null) {
                return null;
            }
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            if ((className = ClassNameUtil.convertToFQName(className)).startsWith("com.intellij.rt.") || className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("jdk.") || className.startsWith("org.jetbrains.coverage.gnu.trove.") || className.startsWith("org.jetbrains.coverage.org.objectweb.")) {
                return null;
            }
            if (this.shouldExclude(className)) {
                return null;
            }
            this.visitClassLoader(loader);
            InclusionPattern inclusionPattern = this.getInclusionPattern();
            if (inclusionPattern == null ? loader != null : inclusionPattern.accept(className)) {
                return this.instrument(classFileBuffer, className, loader, this.computeFrames);
            }
        }
        catch (Throwable e) {
            ErrorReporter.reportError("Error during class instrumentation: " + className, e);
        }
        return null;
    }

    public byte[] instrument(byte[] classfileBuffer, String className, ClassLoader loader, boolean computeFrames) {
        MyClassWriter cw;
        ClassReader cr = new ClassReader(classfileBuffer);
        if (computeFrames) {
            int version = AbstractIntellijClassfileTransformer.getClassFileVersion(cr);
            int flags = (version & 0xFFFF) >= 50 && version != 196653 ? 2 : 1;
            cw = new MyClassWriter(flags, loader);
        } else {
            cw = new MyClassWriter(1, loader);
        }
        ClassVisitor cv = this.createClassVisitor(className, loader, cr, cw);
        cr.accept(cv, 8);
        return cw.toByteArray();
    }

    protected abstract ClassVisitor createClassVisitor(String var1, ClassLoader var2, ClassReader var3, ClassVisitor var4);

    protected abstract boolean shouldExclude(String var1);

    protected InclusionPattern getInclusionPattern() {
        return null;
    }

    protected void visitClassLoader(ClassLoader classLoader) {
    }

    protected boolean isStopped() {
        return false;
    }

    private boolean computeFrames() {
        return System.getProperty("idea.coverage.no.frames") == null;
    }

    private static int getClassFileVersion(ClassReader reader) {
        return reader.readInt(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ClassReader getOrLoadClassReader(String className, ClassLoader classLoader) throws IOException {
        ClassReader classReader;
        Map<String, ClassReader> loaderClassReaders = this.classReaders.get(classLoader);
        if (loaderClassReaders == null) {
            loaderClassReaders = new THashMap<String, ClassReader>();
            this.classReaders.put(classLoader, loaderClassReaders);
        }
        if ((classReader = loaderClassReaders.get(className)) == null) {
            InputStream is = null;
            try {
                String resource = className + ".class";
                InputStream inputStream = is = classLoader == null ? ClassLoader.getSystemResourceAsStream(resource) : classLoader.getResourceAsStream(resource);
                if (is == null) {
                    throw new IOException("Class " + className + " not found");
                }
                classReader = new ClassReader(is);
                loaderClassReaders.put(className, classReader);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return classReader;
    }

    private class MyClassWriter
    extends ClassWriter {
        private static final String JAVA_LANG_OBJECT = "java/lang/Object";
        private final ClassLoader classLoader;

        MyClassWriter(int flags, ClassLoader classLoader) {
            super(flags);
            this.classLoader = classLoader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            try {
                String result;
                block5: {
                    ClassReader info1 = AbstractIntellijClassfileTransformer.this.getOrLoadClassReader(type1, this.classLoader);
                    ClassReader info2 = AbstractIntellijClassfileTransformer.this.getOrLoadClassReader(type2, this.classLoader);
                    String superType = this.checkImplementInterface(type1, type2, info1, info2);
                    if (superType != null) {
                        return superType;
                    }
                    superType = this.checkImplementInterface(type2, type1, info2, info1);
                    if (superType != null) {
                        return superType;
                    }
                    StringBuilder b1 = this.typeAncestors(type1, info1);
                    StringBuilder b2 = this.typeAncestors(type2, info2);
                    result = JAVA_LANG_OBJECT;
                    int end1 = b1.length();
                    int end2 = b2.length();
                    while (true) {
                        String p2;
                        int start1 = b1.lastIndexOf(";", end1 - 1);
                        int start2 = b2.lastIndexOf(";", end2 - 1);
                        if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block5;
                        String p1 = b1.substring(start1 + 1, end1);
                        if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                        result = p1;
                        end1 = start1;
                        end2 = start2;
                    }
                    return result;
                }
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
        }

        private String checkImplementInterface(String type1, String type2, ClassReader info1, ClassReader info2) throws IOException {
            if ((info1.getAccess() & 0x200) != 0) {
                if (this.typeImplements(type2, info2, type1)) {
                    return type1;
                }
                return JAVA_LANG_OBJECT;
            }
            return null;
        }

        private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
            StringBuilder b = new StringBuilder();
            while (!JAVA_LANG_OBJECT.equals(type)) {
                b.append(';').append(type);
                type = info.getSuperName();
                info = AbstractIntellijClassfileTransformer.this.getOrLoadClassReader(type, this.classLoader);
            }
            return b;
        }

        private boolean typeImplements(String type, ClassReader classReader, String interfaceName) throws IOException {
            while (!JAVA_LANG_OBJECT.equals(type)) {
                String[] interfaces;
                for (String itf1 : interfaces = classReader.getInterfaces()) {
                    if (!itf1.equals(interfaceName)) continue;
                    return true;
                }
                for (String itf : interfaces) {
                    if (!this.typeImplements(itf, AbstractIntellijClassfileTransformer.this.getOrLoadClassReader(itf, this.classLoader), interfaceName)) continue;
                    return true;
                }
                type = classReader.getSuperName();
                classReader = AbstractIntellijClassfileTransformer.this.getOrLoadClassReader(type, this.classLoader);
            }
            return false;
        }
    }

    public static interface InclusionPattern {
        public boolean accept(String var1);
    }
}

