/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import java.util.Map;

public class InstructionsUtil {
    public static void merge(ProjectData source, ProjectData target, ClassFilter classFilter) {
        if (!target.isInstructionsCoverageEnabled()) {
            return;
        }
        Map<String, ClassInstructions> instructions = target.getInstructions();
        for (Map.Entry<String, ClassInstructions> entry : source.getInstructions().entrySet()) {
            String key = entry.getKey();
            if (classFilter != null && !classFilter.shouldInclude(key)) continue;
            ClassInstructions mergedInstructions = entry.getValue();
            ClassInstructions classInstructions = instructions.get(key);
            if (classInstructions == null) {
                classInstructions = new ClassInstructions();
                instructions.put(key, classInstructions);
            }
            classInstructions.merge(mergedInstructions);
        }
    }

    public static void applyInstructionsSMAP(ProjectData projectData, LineMapData[] linesMap, String sourceClass, String targetClass) {
        LineInstructions[] lineInstructions;
        if (!projectData.isInstructionsCoverageEnabled()) {
            return;
        }
        int maxMappedSourceLineNumber = ClassData.maxSourceLineNumber(linesMap);
        ClassInstructions old = projectData.getInstructions().get(targetClass);
        if (sourceClass == targetClass || old == null || old.getlines().length == 0) {
            lineInstructions = new LineInstructions[1 + maxMappedSourceLineNumber];
        } else {
            int size = Math.max(1 + maxMappedSourceLineNumber, old.getlines().length);
            lineInstructions = new LineInstructions[size];
            System.arraycopy(old.getlines(), 0, lineInstructions, 0, old.getlines().length);
        }
        LineInstructions[] otherLines = projectData.getInstructions().get(sourceClass).getlines();
        for (LineMapData mapData : linesMap) {
            if (mapData == null) continue;
            int sourceLineNumber = mapData.getSourceLineNumber();
            if (lineInstructions[sourceLineNumber] == null && mapData.getTargetMinLine() < otherLines.length && otherLines[mapData.getTargetMinLine()] != null) {
                lineInstructions[sourceLineNumber] = new LineInstructions();
            }
            for (int i = mapData.getTargetMinLine(); i <= mapData.getTargetMaxLine(); ++i) {
                if (i < 0 || i >= otherLines.length) continue;
                if (lineInstructions[sourceLineNumber] != null && otherLines[i] != null) {
                    lineInstructions[sourceLineNumber].merge(otherLines[i]);
                }
                otherLines[i] = null;
            }
        }
        projectData.getInstructions().put(targetClass, new ClassInstructions(lineInstructions));
    }

    public static void applyInstructionsSMAPUnloaded(ProjectData projectData, String className, FileMapData[] mappings) {
        if (!projectData.isInstructionsCoverageEnabled()) {
            return;
        }
        ClassInstructions classInstructions = projectData.getInstructions().get(className);
        LineInstructions[] instructions = classInstructions.getlines();
        for (FileMapData mapData : mappings) {
            boolean isThisClass = className.equals(mapData.getClassName());
            for (LineMapData lineMapData : mapData.getLines()) {
                int sourceLineNumber = lineMapData.getSourceLineNumber();
                for (int i = lineMapData.getTargetMinLine(); i <= lineMapData.getTargetMaxLine() && i < instructions.length; ++i) {
                    LineInstructions lineInstructions = instructions[i];
                    instructions[i] = null;
                    if (!isThisClass || lineInstructions == null || sourceLineNumber >= instructions.length) continue;
                    if (instructions[sourceLineNumber] == null) {
                        instructions[sourceLineNumber] = lineInstructions;
                        continue;
                    }
                    instructions[sourceLineNumber].merge(lineInstructions);
                }
            }
        }
    }
}

