/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.events.scheme.EventSchemeValidator;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsScheme;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDataType;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter;", "Lcom/intellij/openapi/application/ApplicationStarter;", "()V", "getCommandName", "", "logEnabledPlugins", "", "pluginsFile", "main", "args", "", "Companion", "FieldDataTypeSerializer", "intellij.platform.statistics"})
public final class EventsSchemeBuilderAppStarter
implements ApplicationStarter {
    private static final String outputFileParameter = "--outputFile=";
    private static final String pluginsFileParameter = "--pluginsFile=";
    private static final String pluginIdParameter = "--pluginId=";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getCommandName() {
        return "buildEventsScheme";
    }

    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        String outputFile = null;
        String pluginsFile = null;
        String pluginId = null;
        for (String arg : args) {
            if (StringsKt.startsWith$default((String)arg, (String)outputFileParameter, (boolean)false, (int)2, null)) {
                outputFile = StringsKt.substringAfter$default((String)arg, (String)outputFileParameter, null, (int)2, null);
                continue;
            }
            if (StringsKt.startsWith$default((String)arg, (String)pluginsFileParameter, (boolean)false, (int)2, null)) {
                pluginsFile = StringsKt.substringAfter$default((String)arg, (String)pluginsFileParameter, null, (int)2, null);
                continue;
            }
            if (!StringsKt.startsWith$default((String)arg, (String)pluginIdParameter, (boolean)false, (int)2, null)) continue;
            pluginId = StringsKt.substringAfter$default((String)arg, (String)pluginIdParameter, null, (int)2, null);
        }
        List<GroupDescriptor> groups = EventsSchemeBuilder.buildEventsScheme(null, pluginId);
        List<String> errors = EventSchemeValidator.validateEventScheme(groups);
        Collection collection = errors;
        if (!collection.isEmpty()) {
            throw (Throwable)new IllegalStateException(CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        EventsScheme eventsScheme = new EventsScheme(System.getenv("INSTALLER_LAST_COMMIT_HASH"), System.getenv("IDEA_BUILD_NUMBER"), groups);
        String text = new GsonBuilder().registerTypeAdapter((Type)((Object)FieldDataType.class), (Object)FieldDataTypeSerializer.INSTANCE).setPrettyPrinting().create().toJson((Object)eventsScheme);
        this.logEnabledPlugins(pluginsFile);
        if (outputFile != null) {
            FileUtil.writeToFile((File)new File(outputFile), (String)text);
        } else {
            System.out.println((Object)text);
        }
        int n = 0;
        System.exit(n);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void logEnabledPlugins(String pluginsFile) {
        CharSequence charSequence;
        StringBuilder $this$buildString = charSequence = new StringBuilder();
        boolean bl = false;
        Iterator iterator = PluginManagerCore.getLoadedPlugins().iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptor descriptor;
            IdeaPluginDescriptor ideaPluginDescriptor = descriptor = (IdeaPluginDescriptor)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"descriptor");
            if (!ideaPluginDescriptor.isEnabled()) continue;
            StringBuilder stringBuilder = $this$buildString;
            PluginId pluginId = descriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"descriptor.pluginId");
            String string = pluginId.getIdString();
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = charSequence.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String text = string;
        if (pluginsFile != null) {
            FileUtil.writeToFile((File)new File(pluginsFile), (String)text);
        } else {
            charSequence = "Enabled plugins:";
            System.out.println(charSequence);
            System.out.println((Object)text);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter$FieldDataTypeSerializer;", "Lcom/google/gson/JsonSerializer;", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDataType;", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "intellij.platform.statistics"})
    public static final class FieldDataTypeSerializer
    implements JsonSerializer<FieldDataType> {
        @NotNull
        public static final FieldDataTypeSerializer INSTANCE;

        @NotNull
        public JsonElement serialize(@Nullable FieldDataType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
            if (src == FieldDataType.PRIMITIVE || src == null) {
                JsonSerializationContext jsonSerializationContext = context;
                Intrinsics.checkNotNull((Object)jsonSerializationContext);
                JsonElement jsonElement = jsonSerializationContext.serialize(null);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"context!!.serialize(null)");
                return jsonElement;
            }
            JsonSerializationContext jsonSerializationContext = context;
            Intrinsics.checkNotNull((Object)jsonSerializationContext);
            JsonElement jsonElement = jsonSerializationContext.serialize((Object)src.name());
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"context!!.serialize(src.name)");
            return jsonElement;
        }

        private FieldDataTypeSerializer() {
        }

        static {
            FieldDataTypeSerializer fieldDataTypeSerializer;
            INSTANCE = fieldDataTypeSerializer = new FieldDataTypeSerializer();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilderAppStarter$Companion;", "", "()V", "outputFileParameter", "", "pluginIdParameter", "pluginsFileParameter", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

