/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.metadata;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.Metadata;

public final class DefaultMetadata
extends AbstractMetadata {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final Metadata.Nature nature;
    private final File file;
    private final Map<String, String> properties;

    public DefaultMetadata(String type2, Metadata.Nature nature) {
        this("", "", "", type2, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String type2, Metadata.Nature nature) {
        this(groupId, "", "", type2, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String type2, Metadata.Nature nature) {
        this(groupId, artifactId, "", type2, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type2, Metadata.Nature nature) {
        this(groupId, artifactId, version, type2, nature, null, (File)null);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type2, Metadata.Nature nature, File file) {
        this(groupId, artifactId, version, type2, nature, null, file);
    }

    public DefaultMetadata(String groupId, String artifactId, String version, String type2, Metadata.Nature nature, Map<String, String> properties2, File file) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type2);
        this.nature = Objects.requireNonNull(nature, "metadata nature cannot be null");
        this.file = file;
        this.properties = DefaultMetadata.copyProperties(properties2);
    }

    DefaultMetadata(String groupId, String artifactId, String version, String type2, Metadata.Nature nature, File file, Map<String, String> properties2) {
        this.groupId = DefaultMetadata.emptify(groupId);
        this.artifactId = DefaultMetadata.emptify(artifactId);
        this.version = DefaultMetadata.emptify(version);
        this.type = DefaultMetadata.emptify(type2);
        this.nature = nature;
        this.file = file;
        this.properties = properties2;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Metadata.Nature getNature() {
        return this.nature;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

