/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.intellij.plugins.markdown.lang.index.MarkdownHeadersIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.stubs.MarkdownStubElementType;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.jetbrains.annotations.NotNull;

public class MarkdownHeaderStubElementType
extends MarkdownStubElementType<MarkdownHeaderStubElement, MarkdownHeader> {
    private static final Logger LOG = Logger.getInstance(MarkdownHeaderStubElementType.class);

    public MarkdownHeaderStubElementType(@NotNull String debugName) {
        if (debugName == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(1);
        }
        return new MarkdownHeader(node);
    }

    public MarkdownHeader createPsi(@NotNull MarkdownHeaderStubElement stub) {
        if (stub == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(2);
        }
        return new MarkdownHeader(stub, this);
    }

    @NotNull
    public MarkdownHeaderStubElement createStub(@NotNull MarkdownHeader psi, StubElement parentStub) {
        if (psi == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(3);
        }
        return new MarkdownHeaderStubElement(parentStub, this, psi.getName());
    }

    public void serialize(@NotNull MarkdownHeaderStubElement stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(5);
        }
        MarkdownHeaderStubElementType.writeUTFFast(dataStream, stub.getIndexedName());
    }

    private static void writeUTFFast(@NotNull StubOutputStream dataStream, String text) throws IOException {
        if (dataStream == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(6);
        }
        if (text == null) {
            text = "";
        }
        dataStream.writeUTFFast(text);
    }

    @NotNull
    public MarkdownHeaderStubElement deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) {
        if (dataStream == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(7);
        }
        String indexedName = null;
        try {
            indexedName = dataStream.readUTFFast();
        }
        catch (IOException e) {
            LOG.error("Cannot read data stream; ", new String[]{e.getMessage()});
        }
        String finalIndexedString = StringUtil.isEmpty((String)indexedName) ? null : indexedName;
        return new MarkdownHeaderStubElement(parentStub, this, finalIndexedString);
    }

    public void indexStub(@NotNull MarkdownHeaderStubElement stub, @NotNull IndexSink sink) {
        String indexedName;
        if (stub == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            MarkdownHeaderStubElementType.$$$reportNull$$$0(9);
        }
        if ((indexedName = stub.getIndexedName()) != null) {
            sink.occurrence(MarkdownHeadersIndex.Companion.getKEY(), (Object)indexedName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeUTFFast";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

