/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.AccountManager;
import com.intellij.collaboration.auth.ui.AccountsDetailsLoader;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.collaboration.auth.ui.AccountsPanelFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.GoogleAppCredentialsException;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsDetailsLoader;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsListModel;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequestKt;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.authorization.GoogleRefreshTokenRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleRefreshTokenRequestKt;
import org.intellij.plugins.markdown.google.ui.GoogleChooseAccountDialog;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0003R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "chooseAccount", "Lcom/google/api/client/auth/oauth2/Credential;", "project", "Lcom/intellij/openapi/project/Project;", "createCredentialsForGoogleApi", "credentials", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "createGoogleAccountPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "accountsListModel", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "accountManager", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "getGoogleAppCredentials", "Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;", "getOrUpdateUserCredentials", "oAuthService", "Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;", "account", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "getTokenResponse", "Lcom/google/api/client/auth/oauth2/TokenResponse;", "tryToReLogin", "updateAccountsList", "", "GoogleAppCredentials", "intellij.markdown.core"})
public final class GoogleAccountsUtils {
    private static final Logger LOG;
    @NotNull
    public static final GoogleAccountsUtils INSTANCE;

    @NotNull
    public final ObjectMapper getJacksonMapper() {
        return ExtensionsKt.jacksonObjectMapper();
    }

    @RequiresEdt
    @Nullable
    public final Credential chooseAccount(@NotNull Project project) {
        Credential credential;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GoogleAccountsListModel accountsListModel = new GoogleAccountsListModel();
        boolean $i$f$service = false;
        Class<GoogleAccountManager> serviceClass$iv = GoogleAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleAccountManager accountManager = (GoogleAccountManager)((Object)object);
        boolean $i$f$service2 = false;
        Object serviceClass$iv2 = GoogleOAuthService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + ((Class)serviceClass$iv2).getName() + " (classloader=" + ((Class)serviceClass$iv2).getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleOAuthService oAuthService = (GoogleOAuthService)((Object)object2);
        if (!new GoogleChooseAccountDialog(project, accountsListModel, accountManager).showAndGet()) {
            return null;
        }
        this.updateAccountsList(accountsListModel, accountManager);
        try {
            GoogleAccount googleAccount = (GoogleAccount)accountsListModel.getSelectedAccount();
            if (googleAccount == null) {
                serviceClass$iv2 = "The selected account cannot be null";
                throw new IllegalStateException(serviceClass$iv2.toString());
            }
            GoogleAccount selectedAccount = googleAccount;
            GoogleCredentials googleCredentials = this.getOrUpdateUserCredentials(oAuthService, accountManager, selectedAccount);
            if (googleCredentials == null) {
                googleCredentials = this.tryToReLogin(project);
            }
            if (googleCredentials == null) {
                return null;
            }
            GoogleCredentials accountCredentials = googleCredentials;
            credential = this.createCredentialsForGoogleApi(accountCredentials);
        }
        catch (TimeoutException e) {
            LOG.debug((Throwable)e);
            credential = null;
        }
        catch (IllegalStateException e) {
            LOG.debug((Throwable)e);
            credential = null;
        }
        return credential;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GoogleCredentials tryToReLogin(@NotNull Project project) {
        GoogleCredentials googleCredentials;
        void credentialsFuture;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new CompletableFuture();
        try {
            googleCredentials = (GoogleCredentials)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable((Ref.ObjectRef)credentialsFuture){
                final /* synthetic */ Ref.ObjectRef $credentialsFuture;

                public final GoogleCredentials compute() {
                    GoogleOAuthRequest request = GoogleOAuthRequestKt.getGoogleAuthRequest();
                    boolean $i$f$service = false;
                    Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    this.$credentialsFuture.element = ((GoogleOAuthService)((Object)object)).authorize(request);
                    return (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((CompletableFuture)this.$credentialsFuture.element));
                }
                {
                    this.$credentialsFuture = objectRef;
                }
            }, MarkdownBundle.message("markdown.google.account.login.progress.title", new Object[0]), true, project);
        }
        catch (Throwable t) {
            ((CompletableFuture)credentialsFuture.element).cancel(true);
            googleCredentials = null;
        }
        return googleCredentials;
    }

    @RequiresEdt
    @Nullable
    public final GoogleCredentials getOrUpdateUserCredentials(@NotNull GoogleOAuthService oAuthService, @NotNull GoogleAccountManager accountManager, @NotNull GoogleAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)oAuthService), (String)"oAuthService");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        GoogleCredentials googleCredentials = (GoogleCredentials)accountManager.findCredentials(account);
        if (googleCredentials != null) {
            GoogleCredentials googleCredentials2;
            GoogleCredentials googleCredentials3;
            GoogleCredentials credentials = googleCredentials3 = googleCredentials;
            boolean bl = false;
            if (credentials.isAccessTokenValid()) {
                return credentials;
            }
            GoogleRefreshTokenRequest refreshRequest = GoogleRefreshTokenRequestKt.getGoogleRefreshRequest(credentials.getRefreshToken());
            CompletableFuture<GoogleCredentials> credentialFuture = oAuthService.updateAccessToken(refreshRequest);
            try {
                googleCredentials2 = (GoogleCredentials)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(credentialFuture, oAuthService, accountManager, account){
                    final /* synthetic */ CompletableFuture $credentialFuture;
                    final /* synthetic */ GoogleOAuthService $oAuthService$inlined;
                    final /* synthetic */ GoogleAccountManager $accountManager$inlined;
                    final /* synthetic */ GoogleAccount $account$inlined;
                    {
                        this.$credentialFuture = completableFuture;
                        this.$oAuthService$inlined = googleOAuthService;
                        this.$accountManager$inlined = googleAccountManager;
                        this.$account$inlined = googleAccount;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final GoogleCredentials compute() {
                        void var1_1;
                        GoogleCredentials newCred = (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)this.$credentialFuture);
                        Account account = this.$account$inlined;
                        GoogleCredentials googleCredentials = newCred;
                        Intrinsics.checkNotNullExpressionValue((Object)googleCredentials, (String)"newCred");
                        this.$accountManager$inlined.updateAccount(account, googleCredentials);
                        return var1_1;
                    }
                }, MarkdownBundle.message("markdown.google.account.update.credentials.progress.title", new Object[0]), true, null);
            }
            catch (RuntimeException e) {
                Throwable throwable = e.getCause();
                String $this$alsoIfNull$iv = throwable != null && (throwable = throwable.getCause()) != null ? throwable.getLocalizedMessage() : null;
                boolean $i$f$alsoIfNull = false;
                if ($this$alsoIfNull$iv == null) {
                    boolean bl2 = false;
                    e.getLocalizedMessage();
                }
                String message = $this$alsoIfNull$iv;
                LOG.warn("Failed to update user credentials:\n" + message);
                googleCredentials2 = null;
            }
            return googleCredentials2;
        }
        return null;
    }

    @NotNull
    public final DialogPanel createGoogleAccountPanel(@NotNull Disposable disposable, @NotNull GoogleAccountsListModel accountsListModel, @NotNull GoogleAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)((Object)accountsListModel), (String)"accountsListModel");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        boolean $i$f$service = false;
        Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleOAuthService oAuthService = (GoogleOAuthService)((Object)object);
        boolean $i$f$service2 = false;
        CoroutineScope serviceClass$iv2 = GoogleUserInfoService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleUserInfoService userInfoService = (GoogleUserInfoService)object2;
        CoroutineScope it = serviceClass$iv2 = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        boolean bl = false;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(it){
            final /* synthetic */ CoroutineScope $it;

            public final void dispose() {
                CoroutineScopeKt.cancel$default((CoroutineScope)this.$it, null, (int)1, null);
            }
            {
                this.$it = coroutineScope;
            }
        });
        CoroutineScope scope2 = serviceClass$iv2;
        GoogleAccountsDetailsLoader detailsLoader = new GoogleAccountsDetailsLoader(scope2, accountManager, accountsListModel, oAuthService, userInfoService);
        AccountsPanelFactory panelFactory = new AccountsPanelFactory((AccountManager)accountManager, (AccountsListModel)accountsListModel, (AccountsDetailsLoader)detailsLoader, disposable);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(panelFactory){
            final /* synthetic */ AccountsPanelFactory $panelFactory;

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$receiver");
                Panel.DefaultImpls.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                    final /* synthetic */ createGoogleAccountPanel.1 this$0;

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        AccountsPanelFactory.accountsPanelCell$default((AccountsPanelFactory)this.this$0.$panelFactory, (Row)$this$row, (boolean)false, null, (int)4, null).horizontalAlign(HorizontalAlign.FILL).verticalAlign(VerticalAlign.FILL);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)1, null).resizableRow();
            }
            {
                this.$panelFactory = accountsPanelFactory;
                super(1);
            }
        }));
    }

    @RequiresBackgroundThread
    @Nullable
    public final GoogleAppCredentials getGoogleAppCredentials() {
        String googleAppCredUrl = "https://www.jetbrains.com/config/markdown.json";
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(googleAppCredUrl)).header("Content-Type", "application/json").GET().build();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"HttpRequest.newBuilder()\u2026  .GET()\n        .build()");
            HttpRequest httpRequest2 = httpRequest;
            HttpResponse<String> response = client.send(httpRequest2, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                ObjectMapper objectMapper;
                ObjectMapper $this$with = objectMapper = this.getJacksonMapper();
                boolean bl = false;
                JsonNode credentials = $this$with.readTree(response.body()).get("google").get("auth");
                String clientId = credentials.get("secret-id").asText();
                String clientSecret = credentials.get("client-secret").asText();
                String string = clientId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clientId");
                String string2 = clientSecret;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clientSecret");
                return new GoogleAppCredentials(string, string2);
            }
            LOG.info("Status code: " + response.statusCode() + "\n" + response.body());
            return null;
        }
        catch (ConnectException e) {
            LOG.info((Throwable)new GoogleAppCredentialsException());
            return null;
        }
    }

    @NotNull
    public final Credential createCredentialsForGoogleApi(@NotNull GoogleCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        TokenResponse tokenResponse = this.getTokenResponse(credentials);
        GoogleCredential googleCredential = new GoogleCredential().setFromTokenResponse(tokenResponse);
        Intrinsics.checkNotNullExpressionValue((Object)googleCredential, (String)"GoogleCredential().setFr\u2026enResponse(tokenResponse)");
        return googleCredential;
    }

    @RequiresEdt
    private final void updateAccountsList(GoogleAccountsListModel accountsListModel, GoogleAccountManager accountManager) {
        Map newTokensMap = new LinkedHashMap();
        newTokensMap.putAll(accountsListModel.getNewCredentials());
        for (GoogleAccount account : accountsListModel.getAccounts()) {
            newTokensMap.putIfAbsent(account, null);
        }
        accountManager.updateAccounts(newTokensMap);
        accountsListModel.clearNewCredentials();
    }

    private final TokenResponse getTokenResponse(GoogleCredentials credentials) {
        TokenResponse tokenResponse;
        TokenResponse $this$apply = tokenResponse = new TokenResponse();
        boolean bl = false;
        $this$apply.setAccessToken(credentials.getAccessToken());
        $this$apply.setTokenType(credentials.getTokenType());
        $this$apply.setScope(credentials.getScope());
        $this$apply.setExpiresInSeconds(credentials.getExpiresIn());
        return tokenResponse;
    }

    private GoogleAccountsUtils() {
    }

    static {
        GoogleAccountsUtils googleAccountsUtils;
        INSTANCE = googleAccountsUtils = new GoogleAccountsUtils();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleOAuthService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;", "", "clientId", "", "clientSecret", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getClientSecret", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown.core"})
    public static final class GoogleAppCredentials {
        @NotNull
        private final String clientId;
        @NotNull
        private final String clientSecret;

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        public GoogleAppCredentials(@NotNull String clientId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final String component2() {
            return this.clientSecret;
        }

        @NotNull
        public final GoogleAppCredentials copy(@NotNull String clientId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            return new GoogleAppCredentials(clientId, clientSecret);
        }

        public static /* synthetic */ GoogleAppCredentials copy$default(GoogleAppCredentials googleAppCredentials, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = googleAppCredentials.clientId;
            }
            if ((n & 2) != 0) {
                string2 = googleAppCredentials.clientSecret;
            }
            return googleAppCredentials.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "GoogleAppCredentials(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ")";
        }

        public int hashCode() {
            String string = this.clientId;
            String string2 = this.clientSecret;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GoogleAppCredentials)) break block3;
                    GoogleAppCredentials googleAppCredentials = (GoogleAppCredentials)object;
                    if (!Intrinsics.areEqual((Object)this.clientId, (Object)googleAppCredentials.clientId) || !Intrinsics.areEqual((Object)this.clientSecret, (Object)googleAppCredentials.clientSecret)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

