/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.toc;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Companion$collectHeaders$;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$actionPerformed$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.markdown.core"})
public final class GenerateTableOfContentsAction
extends AnAction {
    @NlsSafe
    private static final String sectionDelimiter = "<!-- TOC -->";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.PSI_FILE);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile");
        }
        MarkdownFile file = (MarkdownFile)object;
        Object object2 = event.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor2 = (Editor)object2;
        String content2 = GenerateTableOfContentsAction.Companion.buildToc(file);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.primaryCaret");
        int caretOffset = caret.getOffset();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        List existingRanges = SequencesKt.toList((Sequence)GenerateTableOfContentsAction.Companion.findExistingTocs(file));
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(project, editor2, existingRanges, caretOffset, content2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ List $existingRanges$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ String $content$inlined;
            {
                this.$project$inlined = project;
                this.$editor$inlined = editor2;
                this.$existingRanges$inlined = list2;
                this.$caretOffset$inlined = n;
                this.$content$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                Project project$iv = this.$project$inlined;
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                    final /* synthetic */ actionPerformed$$inlined$runWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        Document document = this.this$0.$editor$inlined.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                        Document document2 = document;
                        if (CollectionsKt.none((Iterable)this.this$0.$existingRanges$inlined)) {
                            document2.insertString(this.this$0.$caretOffset$inlined, (CharSequence)this.this$0.$content$inlined);
                        } else {
                            Iterable $this$forEach$iv = CollectionsKt.asReversed((List)this.this$0.$existingRanges$inlined);
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                TextRange it = (TextRange)element$iv;
                                boolean bl2 = false;
                                org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Companion.access$replaceString(GenerateTableOfContentsAction.Companion, document2, it, this.this$0.$content$inlined);
                            }
                        }
                    }
                }, name$iv, (Object)groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(CommonDataKeys.PSI_FILE);
        if (!(object instanceof MarkdownFile)) {
            object = null;
        }
        MarkdownFile file = (MarkdownFile)object;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (file == null || editor2 == null) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setEnabled(false);
            return;
        }
        if (SequencesKt.any((Sequence)GenerateTableOfContentsAction.Companion.findExistingTocs(file))) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setText(MarkdownBundle.message("action.Markdown.GenerateTableOfContents.update.text", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public GenerateTableOfContentsAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), 1.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u001c\u0010\u0017\u001a\u00020\u0013*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Companion;", "", "()V", "sectionDelimiter", "", "buildToc", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "collectHeaders", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "collectTopLevelElements", "Lcom/intellij/psi/PsiElement;", "findExistingTocs", "Lcom/intellij/openapi/util/TextRange;", "isTocBlock", "", "element", "appendHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "header", "replaceString", "Lcom/intellij/openapi/editor/Document;", "range", "replacement", "intellij.markdown.core"})
    public static final class Companion {
        private final void replaceString(Document $this$replaceString, TextRange range, String replacement) {
            $this$replaceString.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        private final Sequence<TextRange> findExistingTocs(MarkdownFile file) {
            Sequence<PsiElement> elements2 = this.collectTopLevelElements(file);
            Sequence blockElements2 = SequencesKt.windowed$default((Sequence)SequencesKt.filter(elements2, (Function1)((Function1)new Function1<PsiElement, Boolean>(this){

                public final boolean invoke(@NotNull PsiElement p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Companion.access$isTocBlock((Companion)this.receiver, p1);
                }
            })), (int)2, (int)2, (boolean)false, (int)4, null);
            return SequencesKt.map((Sequence)blockElements2, (Function1)findExistingTocs.1.INSTANCE);
        }

        private final boolean isTocBlock(PsiElement element2) {
            block2: {
                Object object;
                block4: {
                    block3: {
                        PsiElement psiElement;
                        IElementType iElementType = MarkdownElementTypes.HTML_BLOCK;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownElementTypes.HTML_BLOCK");
                        if (!PsiUtilsKt.hasType(element2, iElementType)) break block2;
                        object = element2.getFirstChild();
                        if (object == null) break block3;
                        PsiElement it = psiElement = object;
                        boolean bl = false;
                        IElementType iElementType2 = MarkdownTokenTypes.HTML_BLOCK_CONTENT;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"MarkdownTokenTypes.HTML_BLOCK_CONTENT");
                        object = PsiUtilsKt.hasType(it, iElementType2) ? psiElement : null;
                        if (object != null) break block4;
                    }
                    return false;
                }
                PsiElement child = object;
                return child.textMatches((CharSequence)GenerateTableOfContentsAction.sectionDelimiter);
            }
            return false;
        }

        private final String buildToc(MarkdownFile file) {
            StringBuilder stringBuilder;
            Sequence<MarkdownHeader> headers = this.collectHeaders(file);
            StringBuilder $this$buildString = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$buildString;
            String string = GenerateTableOfContentsAction.sectionDelimiter;
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            for (MarkdownHeader header : headers) {
                Companion.appendHeader($this$buildString, header);
                StringBuilder stringBuilder4 = $this$buildString;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            }
            $this$buildString.append(GenerateTableOfContentsAction.sectionDelimiter);
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        private final Sequence<PsiElement> collectTopLevelElements(MarkdownFile file) {
            PsiElement psiElement = file.getFirstChild();
            Sequence elements2 = psiElement != null && (psiElement = psiElement.getFirstChild()) != null ? PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true) : null;
            Sequence sequence = elements2;
            Sequence sequence2 = sequence;
            if (sequence2 == null) {
                sequence2 = SequencesKt.emptySequence();
            }
            return sequence2;
        }

        private final Sequence<MarkdownHeader> collectHeaders(MarkdownFile file) {
            Sequence<PsiElement> topLevelElements;
            Sequence<PsiElement> $this$filterIsInstance$iv = topLevelElements = this.collectTopLevelElements(file);
            boolean $i$f$filterIsInstance = false;
            return SequencesKt.filter($this$filterIsInstance$iv, (Function1)Companion$collectHeaders$$inlined$filterIsInstance$1.INSTANCE);
        }

        private final void appendHeader(StringBuilder $this$appendHeader, MarkdownHeader header) {
            String string = header.buildVisibleText(false);
            if (string == null) {
                return;
            }
            String text = string;
            String string2 = header.getAnchorText();
            if (string2 == null) {
                return;
            }
            String reference = string2;
            int n = header.getLevel() - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                $this$appendHeader.append("  ");
            }
            $this$appendHeader.append("* [");
            $this$appendHeader.append(text);
            $this$appendHeader.append("](");
            $this$appendHeader.append(reference);
            $this$appendHeader.append(")");
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$replaceString(Companion $this, Document $this$access_u24replaceString, TextRange range, String replacement) {
            $this.replaceString($this$access_u24replaceString, range, replacement);
        }

        public static final /* synthetic */ boolean access$isTocBlock(Companion $this, PsiElement element2) {
            return $this.isTocBlock(element2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

