/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.images;

import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.util.MarkdownFileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/images/MarkdownImageFileDropHandler;", "Lcom/intellij/openapi/editor/CustomFileDropHandler;", "()V", "canHandle", "", "transferable", "Ljava/awt/datatransfer/Transferable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleDrop", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.markdown.core"})
public final class MarkdownImageFileDropHandler
extends CustomFileDropHandler {
    private static final Set<String> IMAGE_EXTENSIONS;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public boolean canHandle(@NotNull Transferable transferable, @Nullable Editor editor2) {
        boolean bl;
        block5: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getDocument()) == null || !editor3.isWritable()) {
                return false;
            }
            List list2 = FileCopyPasteUtil.getFileList((Transferable)transferable);
            if (list2 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"FileCopyPasteUtil.getFil\u2026sferable) ?: return false");
            List droppedFiles = list2;
            Iterable iterable = droppedFiles;
            Companion companion = Companion;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    File p1 = (File)element$iv;
                    boolean bl2 = false;
                    if (companion.isImage(p1)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleDrop(@NotNull Transferable transferable, @Nullable Editor editor2, @Nullable Project project) {
        boolean bl;
        List droppedFiles;
        block9: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getDocument()) == null || !editor3.isWritable()) {
                return false;
            }
            List list2 = FileCopyPasteUtil.getFileList((Transferable)transferable);
            if (list2 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"FileCopyPasteUtil.getFil\u2026sferable) ?: return false");
            droppedFiles = list2;
            Iterable iterable = droppedFiles;
            Companion companion = Companion;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    File p1 = (File)element$iv;
                    boolean bl2 = false;
                    if (companion.isImage(p1)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        File currentDirectory = MarkdownFileUtil.INSTANCE.getDirectory(project, document2);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        Caret caret2 = caret;
        try {
            String string = MarkdownBundle.message("markdown.image.file.drop.handler.drop.command.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ndler.drop.command.name\")");
            String commandName = string;
            WriteCommandAction.runWriteCommandAction((Project)project, (String)commandName, null, (Runnable)new Runnable(droppedFiles, currentDirectory, document2, caret2){
                final /* synthetic */ List $droppedFiles;
                final /* synthetic */ File $currentDirectory;
                final /* synthetic */ Document $document;
                final /* synthetic */ Caret $caret;

                public final void run() {
                    Iterator<E> iterator = this.$droppedFiles.iterator();
                    while (iterator.hasNext()) {
                        File droppedFile;
                        File file = droppedFile = (File)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"droppedFile");
                        String string = file.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"droppedFile.path");
                        String imageText = ImageUtils.createMarkdownImageText$default(null, MarkdownFileUtil.INSTANCE.getPathForMarkdownImage(string, this.$currentDirectory), null, 5, null);
                        this.$document.insertString(this.$caret.getOffset(), (CharSequence)imageText);
                        this.$caret.moveToOffset(this.$caret.getOffset() + imageText.length());
                    }
                }
                {
                    this.$droppedFiles = list2;
                    this.$currentDirectory = file;
                    this.$document = document;
                    this.$caret = caret;
                }
            }, (PsiFile[])new PsiFile[0]);
        }
        catch (ReadOnlyModificationException exception) {
            Messages.showErrorDialog((Project)project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
        }
        catch (ReadOnlyFragmentModificationException exception) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document2).handle(exception);
        }
        return true;
    }

    static {
        Companion = new Companion(null);
        IMAGE_EXTENSIONS = SetsKt.setOf((Object[])new String[]{"bmp", "gif", "jpeg", "jpg", "png", "webp"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/editor/images/MarkdownImageFileDropHandler$Companion;", "", "()V", "IMAGE_EXTENSIONS", "", "", "isImage", "", "file", "Ljava/io/File;", "intellij.markdown.core"})
    public static final class Companion {
        private final boolean isImage(File file) {
            return IMAGE_EXTENSIONS.contains(FilesKt.getExtension((File)file));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

