/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.core.service;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.Versions;
import org.jetbrains.kotlin.tools.projectWizard.core.service.CoreKotlinVersionProviderService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.IdeaIndependentWizardService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.JvmTargetVersionsProviderService;
import org.jetbrains.kotlin.tools.projectWizard.moduleConfigurators.TargetJvmVersion;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.version.Version;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u00012\u00020\u0002:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/CoreJvmTargetVersionsProviderService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/JvmTargetVersionsProviderService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/IdeaIndependentWizardService;", "()V", "listSupportedJvmTargetVersions", "", "Lorg/jetbrains/kotlin/tools/projectWizard/moduleConfigurators/TargetJvmVersion;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "Companion", "kotlin.project-wizard.core"})
public final class CoreJvmTargetVersionsProviderService
extends JvmTargetVersionsProviderService
implements IdeaIndependentWizardService {
    private static final Set<TargetJvmVersion> KOTLIN_14_JVM_TARGETS;
    private static final Map<Version, Set<TargetJvmVersion>> kotlinToJvmTargetVersions;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Set<TargetJvmVersion> listSupportedJvmTargetVersions(@NotNull ProjectKind projectKind) {
        Intrinsics.checkNotNullParameter((Object)projectKind, (String)"projectKind");
        Version version2 = CoreKotlinVersionProviderService.Companion.getKotlinVersion$kotlin_project_wizard_core(projectKind);
        return CoreJvmTargetVersionsProviderService.Companion.listSupportedJvmTargetVersions(version2);
    }

    static {
        Companion = new Companion(null);
        KOTLIN_14_JVM_TARGETS = SetsKt.setOf((Object[])new TargetJvmVersion[]{TargetJvmVersion.JVM_1_8, TargetJvmVersion.JVM_9, TargetJvmVersion.JVM_10, TargetJvmVersion.JVM_11, TargetJvmVersion.JVM_12, TargetJvmVersion.JVM_13, TargetJvmVersion.JVM_14, TargetJvmVersion.JVM_15});
        kotlinToJvmTargetVersions = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)Versions.INSTANCE.getKOTLIN(), KOTLIN_14_JVM_TARGETS), TuplesKt.to((Object)Versions.INSTANCE.getKOTLIN_VERSION_FOR_COMPOSE(), KOTLIN_14_JVM_TARGETS)});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/CoreJvmTargetVersionsProviderService$Companion;", "", "()V", "KOTLIN_14_JVM_TARGETS", "", "Lorg/jetbrains/kotlin/tools/projectWizard/moduleConfigurators/TargetJvmVersion;", "kotlinToJvmTargetVersions", "", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/version/Version;", "listSupportedJvmTargetVersions", "kotlinVersion", "kotlin.project-wizard.core"})
    public static final class Companion {
        private final Set<TargetJvmVersion> listSupportedJvmTargetVersions(Version kotlinVersion2) {
            Set set2 = (Set)kotlinToJvmTargetVersions.get(kotlinVersion2);
            if (set2 == null) {
                String string = "Kotlin version " + kotlinVersion2 + " is not associated with any jvm targets";
                throw new IllegalStateException(string.toString());
            }
            return set2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

