/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinTodoOccurrence;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTodoSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/search/IndexPatternOccurrence;", "Lcom/intellij/psi/search/searches/IndexPatternSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "kotlin.fir.frontend-independent"})
public final class KotlinTodoSearcher
extends QueryExecutorBase<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    /*
     * WARNING - void declaration
     */
    public void processQuery(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<? super IndexPatternOccurrence> consumer2) {
        int count;
        void pattern2;
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        PsiFile psiFile2 = queryParameters.getFile();
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return;
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = queryParameters.getPattern();
        if ((IndexPattern)pattern2.element != null) {
            String string = ((IndexPattern)pattern2.element).getPatternString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern.patternString");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)"TODO", (boolean)true)) {
                return;
            }
        }
        if ((IndexPattern)pattern2.element == null) {
            Object var14_15;
            Object v8;
            block9: {
                void $this$firstOrNull$iv;
                IndexPatternProvider indexPatternProvider = queryParameters.getPatternProvider();
                Intrinsics.checkNotNullExpressionValue((Object)indexPatternProvider, (String)"queryParameters.patternProvider");
                IndexPattern[] indexPatternArray = indexPatternProvider.getIndexPatterns();
                Intrinsics.checkNotNullExpressionValue((Object)indexPatternArray, (String)"queryParameters.patternProvider.indexPatterns");
                IndexPattern[] indexPatternArray2 = indexPatternArray;
                void var13_7 = pattern2;
                boolean $i$f$firstOrNull = false;
                int n = ((void)$this$firstOrNull$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    void v6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                    String string = v6.getPatternString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.patternString");
                    if (!StringsKt.contains((CharSequence)string, (CharSequence)"TODO", (boolean)true)) continue;
                    v8 = element$iv;
                    break block9;
                }
                v8 = null;
            }
            Object v9 = var14_15 = v8;
            if (v9 == null) {
                return;
            }
            var13_7.element = v9;
        }
        TodoCacheManager cacheManager = TodoCacheManager.getInstance((Project)file2.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int n = count = patternProvider != null ? cacheManager.getTodoCount(virtualFile3, patternProvider) : cacheManager.getTodoCount(virtualFile3, (IndexPattern)pattern2.element);
        if (count == 0) {
            return;
        }
        file2.accept((PsiElementVisitor)new KtTreeVisitorVoid(consumer2, file2, (Ref.ObjectRef)pattern2){
            final /* synthetic */ Processor $consumer;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Ref.ObjectRef $pattern;

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitCallExpression(expression2);
                KtExpression ktExpression = expression2.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"TODO")) {
                    PsiFile psiFile2 = (PsiFile)this.$file;
                    TextRange textRange = expression2.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expression.textRange");
                    this.$consumer.process((Object)new KotlinTodoOccurrence(psiFile2, textRange, (IndexPattern)this.$pattern.element));
                }
            }
            {
                this.$consumer = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
                this.$pattern = $captured_local_variable$2;
            }
        });
    }
}

