/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/references/KotlinWebReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "spaceSymbolsSplitter", "Lkotlin/text/Regex;", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "kotlin.core"})
public final class KotlinWebReferenceContributor
extends PsiReferenceContributor {
    private final Regex spaceSymbolsSplitter = new Regex("\\s");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(KtStringTemplateExpression.class), new PsiReferenceProvider(this){
            final /* synthetic */ KotlinWebReferenceContributor this$0;

            public boolean acceptsTarget(@NotNull PsiElement target2) {
                Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
                return false;
            }

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element3, @NotNull ProcessingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                PsiElement psiElement2 = element3;
                if (!(psiElement2 instanceof KtStringTemplateExpression)) {
                    psiElement2 = null;
                }
                KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)psiElement2;
                if (ktStringTemplateExpression == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
                    return PsiReference.EMPTY_ARRAY;
                }
                KtStringTemplateExpression stringTemplateExpression = ktStringTemplateExpression;
                if (!stringTemplateExpression.textContains(':')) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
                    return PsiReference.EMPTY_ARRAY;
                }
                SmartList results2 = new SmartList();
                KtStringTemplateEntry[] ktStringTemplateEntryArray = stringTemplateExpression.getEntries();
                int n = ktStringTemplateEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    KtStringTemplateEntry entry;
                    KtStringTemplateEntry ktStringTemplateEntry = entry = ktStringTemplateEntryArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntry, (String)"entry");
                    if (ktStringTemplateEntry.getExpression() != null) continue;
                    String string = entry.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.text");
                    CharSequence charSequence = string;
                    Regex regex = KotlinWebReferenceContributor.access$getSpaceSymbolsSplitter$p(this.this$0);
                    int n2 = 0;
                    List texts2 = regex.split(charSequence, n2);
                    int startIndex = entry.getStartOffsetInParent();
                    for (String text2 : texts2) {
                        CharSequence charSequence2 = text2;
                        if (charSequence2.length() > 0 && GlobalPathReferenceProvider.isWebReferenceUrl((String)text2)) {
                            results2.add((Object)new WebReference((PsiElement)stringTemplateExpression, new TextRange(startIndex, startIndex + text2.length()), text2));
                        }
                        startIndex += text2.length() + 1;
                    }
                }
                Object[] objectArray = results2.toArray((Object[])PsiReference.EMPTY_ARRAY);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"results.toArray(PsiReference.EMPTY_ARRAY)");
                return (PsiReference[])objectArray;
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public static final /* synthetic */ Regex access$getSpaceSymbolsSplitter$p(KotlinWebReferenceContributor $this) {
        return $this.spaceSymbolsSplitter;
    }
}

