/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "getFamilyName", "", "getName", "renameWithoutEditor", "startInWriteAction", "", "kotlin.idea"})
public class RenameIdentifierFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("rename.identifier.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        block6: {
            RenameHandler renameHandler;
            DataContext dataContext;
            PsiElement element3;
            block5: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (psiElement2 == null) {
                    return;
                }
                element3 = psiElement2;
                PsiFile psiFile2 = element3.getContainingFile();
                if (psiFile2 == null) {
                    return;
                }
                PsiFile file2 = psiFile2;
                if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                    return;
                }
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project2);
                FileEditor fileEditor = editorManager.getSelectedEditor(file2.getVirtualFile());
                if (fileEditor == null) {
                    this.renameWithoutEditor(element3);
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"editorManager.getSelecte\u2026ameWithoutEditor(element)");
                FileEditor fileEditor2 = fileEditor;
                DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)fileEditor2.getComponent());
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"DataManager.getInstance(\u2026ext(fileEditor.component)");
                dataContext = dataContext2;
                renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
                FileEditorManager fileEditorManager = editorManager;
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"editorManager");
                Editor editor2 = fileEditorManager.getSelectedTextEditor();
                if (editor2 == null) break block5;
                RenameHandler renameHandler2 = renameHandler;
                if (renameHandler2 == null) break block6;
                renameHandler2.invoke(project2, editor2, file2, dataContext);
                break block6;
            }
            PsiElement psiElement3 = this.getElementToRename(element3);
            if (psiElement3 == null) {
                return;
            }
            PsiElement elementToRename = psiElement3;
            RenameHandler renameHandler3 = renameHandler;
            if (renameHandler3 == null) break block6;
            renameHandler3.invoke(project2, new PsiElement[]{elementToRename}, dataContext);
        }
    }

    @Nullable
    protected PsiElement getElementToRename(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3.getParent();
    }

    private final void renameWithoutEditor(PsiElement element3) {
        PsiElement psiElement2 = this.getElementToRename(element3);
        if (psiElement2 == null) {
            return;
        }
        PsiElement elementToRename = psiElement2;
        RefactoringFactory factory2 = RefactoringFactory.getInstance((Project)element3.getProject());
        RenameRefactoring renameRefactoring = factory2.createRename(elementToRename, null, true, true);
        renameRefactoring.run();
    }
}

