/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Companion", "kotlin.idea"})
public final class MoveWhenElseBranchFix
extends KotlinQuickFixAction<KtWhenExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("move.else.branch.to.the.end", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtWhenExpression ktWhenExpression = (KtWhenExpression)this.getElement();
        if (ktWhenExpression == null) {
            return false;
        }
        KtWhenExpression element3 = ktWhenExpression;
        return KtPsiUtil.checkWhenExpressionHasSingleElse((KtWhenExpression)element3);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Object v4;
        KtWhenEntry lastEntry;
        KtWhenExpression element3;
        block7: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtWhenExpression ktWhenExpression = (KtWhenExpression)this.getElement();
            if (ktWhenExpression == null) {
                return;
            }
            element3 = ktWhenExpression;
            List list2 = element3.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.entries");
            List entries2 = list2;
            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.lastOrNull((List)entries2);
            if (ktWhenEntry == null) {
                return;
            }
            lastEntry = ktWhenEntry;
            Iterable $this$singleOrNull$iv = entries2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KtWhenEntry it = (KtWhenEntry)element$iv;
                boolean bl = false;
                KtWhenEntry ktWhenEntry2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry2, (String)"it");
                if (!ktWhenEntry2.isElse()) continue;
                if (found$iv) {
                    v4 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        KtWhenEntry ktWhenEntry = v4;
        if (ktWhenEntry == null) {
            return;
        }
        KtWhenEntry elseEntry = ktWhenEntry;
        Editor editor3 = editor2;
        Intrinsics.checkNotNull((Object)editor3);
        CaretModel caretModel = editor3.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor!!.caretModel");
        int cursorOffset = caretModel.getOffset() - elseEntry.getTextOffset();
        PsiElement psiElement2 = element3.addAfter((PsiElement)elseEntry, (PsiElement)lastEntry);
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenEntry");
        }
        KtWhenEntry insertedBranch = (KtWhenEntry)psiElement2;
        elseEntry.delete();
        KtWhenEntry ktWhenEntry3 = (KtWhenEntry)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)insertedBranch));
        if (ktWhenEntry3 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry3, (String)"CodeInsightUtilCore.forc\u2026insertedBranch) ?: return");
        KtWhenEntry insertedWhenEntry = ktWhenEntry3;
        editor2.getCaretModel().moveToOffset(insertedWhenEntry.getTextOffset() + cursorOffset);
    }

    public MoveWhenElseBranchFix(@NotNull KtWhenExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected MoveWhenElseBranchFix createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$getNonStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtWhenExpression.class, (boolean)false);
            if (ktWhenExpression == null) {
                return null;
            }
            KtWhenExpression whenExpression2 = ktWhenExpression;
            return new MoveWhenElseBranchFix(whenExpression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

