/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.AddJvmStaticIntention;
import org.jetbrains.kotlin.idea.intentions.MoveMemberToCompanionObjectIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.MakeMemberStaticFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
public final class MakeMemberStaticFix
extends KotlinQuickFixAction<KtNamedDeclaration> {
    private final KtNamedDeclaration declaration;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        var $fun$makeStaticAndReformat$1 = new Function1<KtNamedDeclaration, Unit>(editor2){
            final /* synthetic */ Editor $editor;

            public final void invoke(@NotNull KtNamedDeclaration declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                AddJvmStaticIntention makeStaticIntention = new AddJvmStaticIntention();
                if (makeStaticIntention.applicabilityRange(declaration2) != null) {
                    new AddJvmStaticIntention().applyTo(declaration2, this.$editor);
                }
                CodeStyleManager.getInstance((Project)declaration2.getProject()).reformat((PsiElement)declaration2, true);
            }
            {
                this.$editor = editor2;
                super(1);
            }
        };
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)this.declaration));
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject containingClass2 = ktClassOrObject;
        if (containingClass2 instanceof KtClass) {
            void externalUsages;
            void conflicts2;
            MoveMemberToCompanionObjectIntention moveMemberToCompanionObjectIntention = new MoveMemberToCompanionObjectIntention();
            Triple<MultiMap<PsiElement, String>, List<UsageInfo>, List<UsageInfo>> triple = moveMemberToCompanionObjectIntention.retrieveConflictsAndUsages(project2, editor2, this.declaration, (KtClass)containingClass2);
            if (triple == null) {
                return;
            }
            Triple<MultiMap<PsiElement, String>, List<UsageInfo>, List<UsageInfo>> triple2 = triple;
            MultiMap multiMap = (MultiMap)triple2.component1();
            List list2 = (List)triple2.component2();
            List outerInstanceUsages = (List)triple2.component3();
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(project2, (MultiMap)conflicts2, null, (Function0)new Function0<Unit>(this, project2, moveMemberToCompanionObjectIntention, (List)externalUsages, outerInstanceUsages, editor2, $fun$makeStaticAndReformat$1){
                final /* synthetic */ MakeMemberStaticFix this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ MoveMemberToCompanionObjectIntention $moveMemberToCompanionObjectIntention;
                final /* synthetic */ List $externalUsages;
                final /* synthetic */ List $outerInstanceUsages;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ invoke.1 $makeStaticAndReformat$1;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    block0: {
                        KtNamedDeclaration ktNamedDeclaration;
                        void movedDeclaration;
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = null;
                        ApplicationManagerEx.getApplicationEx().runWriteActionWithNonCancellableProgressInDispatchThread(KotlinBundle.message("moving.to.companion.object", new Object[0]), this.$project, null, new Consumer(this, (Ref.ObjectRef)movedDeclaration){
                            final /* synthetic */ invoke.2 this$0;
                            final /* synthetic */ Ref.ObjectRef $movedDeclaration;

                            public final void accept(ProgressIndicator it) {
                                MoveMemberToCompanionObjectIntention moveMemberToCompanionObjectIntention = this.this$0.$moveMemberToCompanionObjectIntention;
                                ProgressIndicator progressIndicator = it;
                                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"it");
                                this.$movedDeclaration.element = moveMemberToCompanionObjectIntention.doMove(progressIndicator, MakeMemberStaticFix.access$getDeclaration$p(this.this$0.this$0), this.this$0.$externalUsages, this.this$0.$outerInstanceUsages, this.this$0.$editor);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$movedDeclaration = objectRef;
                            }
                        });
                        KtNamedDeclaration ktNamedDeclaration2 = (KtNamedDeclaration)movedDeclaration.element;
                        if (ktNamedDeclaration2 == null) break block0;
                        KtNamedDeclaration it = ktNamedDeclaration = ktNamedDeclaration2;
                        boolean bl = false;
                        this.$makeStaticAndReformat$1.invoke(it);
                    }
                }
                {
                    this.this$0 = makeMemberStaticFix;
                    this.$project = project2;
                    this.$moveMemberToCompanionObjectIntention = moveMemberToCompanionObjectIntention;
                    this.$externalUsages = list2;
                    this.$outerInstanceUsages = list3;
                    this.$editor = editor2;
                    this.$makeStaticAndReformat$1 = var7_7;
                    super(0);
                }
            }, 2, null);
        } else {
            $fun$makeStaticAndReformat$1.invoke(this.declaration);
        }
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        String string = this.declaration.getName();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name ?: \"\"");
        objectArray[0] = string;
        return KotlinBundle.message("make.member.static.quickfix", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public MakeMemberStaticFix(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        super((PsiElement)declaration2);
        this.declaration = declaration2;
    }

    public static final /* synthetic */ KtNamedDeclaration access$getDeclaration$p(MakeMemberStaticFix $this) {
        return $this.declaration;
    }
}

