/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J#\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0094\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u0014*\u00020\u00022\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0002J\f\u0010$\u001a\u00020\u0014*\u00020\u0002H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "candidateMembers", "", "Lorg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix$MemberData;", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Ljava/util/List;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "kind", "", "getKind", "()Ljava/lang/String;", "actionName", "memberData", "addMember", "", "project", "Lcom/intellij/openapi/project/Project;", "createMemberPopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "copyAnnotationEntriesFrom", "member", "removeDefaultParameterValues", "MemberData", "kotlin.idea"})
public abstract class AddMemberToSupertypeFix
extends KotlinQuickFixAction<KtCallableDeclaration>
implements LowPriorityAction {
    private final List<MemberData> candidateMembers;

    @NotNull
    public abstract String getKind();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                MemberData memberData;
                object = (MemberData)CollectionsKt.singleOrNull(this.candidateMembers);
                if (object == null) break block2;
                MemberData it = memberData = object;
                boolean bl = false;
                object = this.actionName(it);
                if (object != null) break block3;
            }
            object = KotlinBundle.message("fix.add.member.supertype.text", this.getKind());
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.member.supertype.family", this.getKind());
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this, editor2, project2){
            final /* synthetic */ AddMemberToSupertypeFix this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;

            /*
             * Enabled aggressive block sorting
             */
            public final void run() {
                if (AddMemberToSupertypeFix.access$getCandidateMembers$p(this.this$0).size() != 1 && this.$editor != null) {
                    JComponent jComponent = this.$editor.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
                    if (jComponent.isShowing()) {
                        JBPopupFactory.getInstance().createListPopup(AddMemberToSupertypeFix.access$createMemberPopup(this.this$0, this.$project)).showInBestPositionFor(this.$editor);
                        return;
                    }
                }
                AddMemberToSupertypeFix.access$addMember(this.this$0, (MemberData)CollectionsKt.first((List)AddMemberToSupertypeFix.access$getCandidateMembers$p(this.this$0)), this.$project);
            }
            {
                this.this$0 = addMemberToSupertypeFix;
                this.$editor = editor2;
                this.$project = project2;
            }
        });
    }

    private final void addMember(MemberData memberData, Project project2) {
        ApplicationUtilsKt.executeWriteCommand(project2, KotlinBundle.message("fix.add.member.supertype.progress", this.getKind()), (Function0<Unit>)((Function0)new Function0<Unit>(this, memberData, project2){
            final /* synthetic */ AddMemberToSupertypeFix this$0;
            final /* synthetic */ MemberData $memberData;
            final /* synthetic */ Project $project;

            public final void invoke() {
                IElementType iElementType;
                KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this.this$0.getElement();
                if (ktCallableDeclaration != null) {
                    AddMemberToSupertypeFix.access$removeDefaultParameterValues(this.this$0, ktCallableDeclaration);
                }
                KtClassBody classBody = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)((KtClassOrObject)this.$memberData.getTargetClass()));
                KtCallableDeclaration memberElement = (KtCallableDeclaration)new KtPsiFactory(this.$project, false, 2, null).createDeclaration(this.$memberData.getSourceCode());
                AddMemberToSupertypeFix.access$copyAnnotationEntriesFrom(this.this$0, memberElement, (KtCallableDeclaration)this.this$0.getElement());
                PsiElement psiElement2 = classBody.addBefore((PsiElement)memberElement, classBody.getRBrace());
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                }
                KtCallableDeclaration insertedMemberElement = (KtCallableDeclaration)psiElement2;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)insertedMemberElement, null, 2, null);
                PsiElement psiElement3 = KtPsiUtilKt.modalityModifier((KtDeclaration)((KtDeclaration)insertedMemberElement));
                if (!((psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : (iElementType = null)) instanceof KtModifierKeywordToken)) {
                    iElementType = null;
                }
                KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)iElementType;
                if (ktModifierKeywordToken == null) {
                    return;
                }
                KtModifierKeywordToken modifierToken = ktModifierKeywordToken;
                if (Intrinsics.areEqual((Object)PsiModificationUtilsKt.implicitModality((KtDeclaration)insertedMemberElement), (Object)modifierToken)) {
                    new RemoveModifierFixBase((KtModifierListOwner)insertedMemberElement, modifierToken, true).invoke();
                }
            }
            {
                this.this$0 = addMemberToSupertypeFix;
                this.$memberData = memberData;
                this.$project = project2;
                super(0);
            }
        }));
    }

    private final void removeDefaultParameterValues(KtCallableDeclaration $this$removeDefaultParameterValues) {
        List list2 = $this$removeDefaultParameterValues.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"valueParameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            KtParameter ktParameter = it;
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"it");
            KtExpression ktExpression = ktParameter.getDefaultValue();
            if (ktExpression != null) {
                ktExpression.delete();
            }
            PsiElement psiElement2 = it.getEqualsToken();
            if (psiElement2 == null) continue;
            psiElement2.delete();
        }
    }

    private final void copyAnnotationEntriesFrom(KtCallableDeclaration $this$copyAnnotationEntriesFrom, KtCallableDeclaration member) {
        Object object = member;
        if (object != null && (object = object.getAnnotationEntries()) != null && (object = CollectionsKt.reversed((Iterable)((Iterable)object))) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                $this$copyAnnotationEntriesFrom.addAnnotationEntry(it);
            }
        }
    }

    private final ListPopupStep<?> createMemberPopup(Project project2) {
        return (ListPopupStep)new BaseListPopupStep<MemberData>(this, project2, KotlinBundle.message("fix.add.member.supertype.choose.type", new Object[0]), this.candidateMembers){
            final /* synthetic */ AddMemberToSupertypeFix this$0;
            final /* synthetic */ Project $project;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            @Nullable
            public PopupStep<?> onChosen(@NotNull MemberData selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                if (finalChoice) {
                    AddMemberToSupertypeFix.access$addMember(this.this$0, selectedValue, this.$project);
                }
                return PopupStep.FINAL_CHOICE;
            }

            @NotNull
            public Icon getIconFor(@NotNull MemberData value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.this$0.getIcon();
            }

            @NotNull
            public String getTextFor(@NotNull MemberData value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return AddMemberToSupertypeFix.access$actionName(this.this$0, value2);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    @Nls
    private final String actionName(MemberData memberData) {
        return KotlinBundle.message("fix.add.member.supertype.add.to", memberData.getSignaturePreview(), String.valueOf(memberData.getTargetClass().getName()));
    }

    public AddMemberToSupertypeFix(@NotNull KtCallableDeclaration element3, @NotNull List<MemberData> candidateMembers) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(candidateMembers, (String)"candidateMembers");
        super((PsiElement)element3);
        this.candidateMembers = candidateMembers;
        Collection collection = this.candidateMembers;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public static final /* synthetic */ List access$getCandidateMembers$p(AddMemberToSupertypeFix $this) {
        return $this.candidateMembers;
    }

    public static final /* synthetic */ void access$addMember(AddMemberToSupertypeFix $this, MemberData memberData, Project project2) {
        $this.addMember(memberData, project2);
    }

    public static final /* synthetic */ ListPopupStep access$createMemberPopup(AddMemberToSupertypeFix $this, Project project2) {
        return $this.createMemberPopup(project2);
    }

    public static final /* synthetic */ void access$removeDefaultParameterValues(AddMemberToSupertypeFix $this, KtCallableDeclaration $this$access_u24removeDefaultParameterValues) {
        $this.removeDefaultParameterValues($this$access_u24removeDefaultParameterValues);
    }

    public static final /* synthetic */ void access$copyAnnotationEntriesFrom(AddMemberToSupertypeFix $this, KtCallableDeclaration $this$access_u24copyAnnotationEntriesFrom, KtCallableDeclaration member) {
        $this.copyAnnotationEntriesFrom($this$access_u24copyAnnotationEntriesFrom, member);
    }

    public static final /* synthetic */ String access$actionName(AddMemberToSupertypeFix $this, MemberData memberData) {
        return $this.actionName(memberData);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddMemberToSupertypeFix$MemberData;", "", "signaturePreview", "", "sourceCode", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtClass;)V", "getSignaturePreview", "()Ljava/lang/String;", "getSourceCode", "getTargetClass", "()Lorg/jetbrains/kotlin/psi/KtClass;", "kotlin.idea"})
    public static final class MemberData {
        @NotNull
        private final String signaturePreview;
        @NotNull
        private final String sourceCode;
        @NotNull
        private final KtClass targetClass;

        @NotNull
        public final String getSignaturePreview() {
            return this.signaturePreview;
        }

        @NotNull
        public final String getSourceCode() {
            return this.sourceCode;
        }

        @NotNull
        public final KtClass getTargetClass() {
            return this.targetClass;
        }

        public MemberData(@NotNull String signaturePreview, @NotNull String sourceCode, @NotNull KtClass targetClass) {
            Intrinsics.checkNotNullParameter((Object)signaturePreview, (String)"signaturePreview");
            Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            this.signaturePreview = signaturePreview;
            this.sourceCode = sourceCode;
            this.targetClass = targetClass;
        }
    }
}

