/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitLambdaParameterTypesIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitLambdaParameterTypesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
public final class RemoveExplicitLambdaParameterTypesIntention
extends SelfTargetingIntention<KtLambdaExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtLambdaExpression element3, int caretOffset) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            List list2 = element3.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.valueParameters");
            Iterable $this$none$iv = list2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtParameter it = (KtParameter)element$iv;
                    boolean bl2 = false;
                    KtParameter ktParameter = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"it");
                    if (!(ktParameter.getTypeReference() != null)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        KtFunctionLiteral ktFunctionLiteral = element3.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"element.functionLiteral");
        PsiElement psiElement2 = ktFunctionLiteral.getArrow();
        if (psiElement2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.functionLiteral.arrow ?: return false");
        PsiElement arrow2 = psiElement2;
        return caretOffset <= PsiUtilsKt.getEndOffset((PsiElement)arrow2);
    }

    @Override
    public void applyTo(@NotNull KtLambdaExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtFunctionLiteral ktFunctionLiteral = element3.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"element.functionLiteral");
        KtParameterList ktParameterList = ktFunctionLiteral.getValueParameterList();
        Intrinsics.checkNotNull((Object)ktParameterList);
        Intrinsics.checkNotNullExpressionValue((Object)ktParameterList, (String)"element.functionLiteral.valueParameterList!!");
        KtParameterList oldParameterList = ktParameterList;
        List list2 = oldParameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"oldParameterList.parameters");
        String parameterString2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)applyTo.parameterString.1.INSTANCE), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        KtParameterList newParameterList = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null).createLambdaParameterList(parameterString2);
        oldParameterList.replace((PsiElement)newParameterList);
    }

    public RemoveExplicitLambdaParameterTypesIntention() {
        super(KtLambdaExpression.class, KotlinBundle.lazyMessage("remove.explicit.lambda.parameter.types.may.break.code", new Object[0]), null, 4, null);
    }
}

