/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.coroutines;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.UnusedReceiverParameterInspection;
import org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertReceiverToParameterIntention;
import org.jetbrains.kotlin.idea.intentions.MoveMemberToCompanionObjectIntention;
import org.jetbrains.kotlin.idea.util.PsiUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/SuspendFunctionOnCoroutineScopeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "WrapWithCoroutineScopeFix", "kotlin.idea"})
public final class SuspendFunctionOnCoroutineScopeInspection
extends AbstractKotlinInspection {
    private static final String COROUTINE_SCOPE = "kotlinx.coroutines.CoroutineScope";
    private static final String COROUTINE_SCOPE_WRAPPER = "kotlinx.coroutines.coroutineScope";
    private static final String COROUTINE_CONTEXT = "coroutineContext";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtNamedFunction function2) {
                PsiElement $this$forEachDescendantOfType$iv;
                void extensionOfCoroutineScope;
                SimpleFunctionDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (!function2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    return;
                }
                if (!function2.hasBody()) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyzeWithContent((KtDeclaration)function2);
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)function2);
                if (simpleFunctionDescriptor == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"context[BindingContext.F\u2026TION, function] ?: return");
                SimpleFunctionDescriptor $this$with = descriptor2 = simpleFunctionDescriptor;
                boolean $i$a$-with-SuspendFunctionOnCoroutineScopeInspection$buildVisitor$1$22 = false;
                Pair pair = TuplesKt.to((Object)org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$ofCoroutineScopeType(SuspendFunctionOnCoroutineScopeInspection.Companion, $this$with.getExtensionReceiverParameter()), (Object)org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$ofCoroutineScopeType(SuspendFunctionOnCoroutineScopeInspection.Companion, $this$with.getDispatchReceiverParameter()));
                boolean bl = (Boolean)pair.component1();
                boolean memberOfCoroutineScope = (Boolean)pair.component2();
                if (extensionOfCoroutineScope == false && !memberOfCoroutineScope) {
                    return;
                }
                Function1<DeclarationDescriptor, Boolean> $fun$isReceiverOfAnalyzedFunction$2 = new Function1<DeclarationDescriptor, Boolean>((boolean)extensionOfCoroutineScope, descriptor2, memberOfCoroutineScope){
                    final /* synthetic */ boolean $extensionOfCoroutineScope;
                    final /* synthetic */ SimpleFunctionDescriptor $descriptor;
                    final /* synthetic */ boolean $memberOfCoroutineScope;

                    public final boolean invoke(@NotNull DeclarationDescriptor $this$isReceiverOfAnalyzedFunction) {
                        Intrinsics.checkNotNullParameter((Object)$this$isReceiverOfAnalyzedFunction, (String)"$this$isReceiverOfAnalyzedFunction");
                        if (this.$extensionOfCoroutineScope && Intrinsics.areEqual((Object)$this$isReceiverOfAnalyzedFunction, (Object)this.$descriptor)) {
                            return true;
                        }
                        return this.$memberOfCoroutineScope && Intrinsics.areEqual((Object)$this$isReceiverOfAnalyzedFunction, (Object)this.$descriptor.getContainingDeclaration());
                    }
                    {
                        this.$extensionOfCoroutineScope = bl;
                        this.$descriptor = simpleFunctionDescriptor;
                        this.$memberOfCoroutineScope = bl2;
                        super(1);
                    }
                };
                Function2<ReceiverValue, KtExpression, Unit> $fun$checkSuspiciousReceiver$3 = new Function2<ReceiverValue, KtExpression, Unit>(this, $fun$isReceiverOfAnalyzedFunction$2, context2, (boolean)extensionOfCoroutineScope, memberOfCoroutineScope, function2){
                    final /* synthetic */ buildVisitor.1 this$0;
                    final /* synthetic */ buildVisitor.2 $isReceiverOfAnalyzedFunction$2;
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ boolean $extensionOfCoroutineScope;
                    final /* synthetic */ boolean $memberOfCoroutineScope;
                    final /* synthetic */ KtNamedFunction $function;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ReceiverValue receiver2, @NotNull KtExpression problemExpression) {
                        PsiElement psiElement2;
                        void $this$with;
                        KtClassOrObject containingDeclaration2;
                        KtCallExpression ktCallExpression;
                        Object instanceReference2;
                        Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
                        Intrinsics.checkNotNullParameter((Object)problemExpression, (String)"problemExpression");
                        ReceiverValue receiverValue = receiver2;
                        if (receiverValue instanceof ImplicitReceiver) {
                            if (!this.$isReceiverOfAnalyzedFunction$2.invoke(((ImplicitReceiver)receiver2).getDeclarationDescriptor())) {
                                return;
                            }
                        } else if (receiverValue instanceof ExpressionReceiver) {
                            KtExpression ktExpression = ((ExpressionReceiver)receiver2).getExpression();
                            if (!(ktExpression instanceof KtThisExpression)) {
                                ktExpression = null;
                            }
                            KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                            if (ktThisExpression == null) {
                                return;
                            }
                            KtThisExpression receiverThisExpression = ktThisExpression;
                            if (receiverThisExpression.getTargetLabel() != null) {
                                KtReferenceExpression ktReferenceExpression = receiverThisExpression.getInstanceReference();
                                Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"receiverThisExpression.instanceReference");
                                instanceReference2 = ktReferenceExpression;
                                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.$context.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, instanceReference2);
                                if (declarationDescriptor == null || !this.$isReceiverOfAnalyzedFunction$2.invoke(declarationDescriptor)) {
                                    return;
                                }
                            }
                        }
                        List fixes2 = new ArrayList<E>();
                        KtExpression ktExpression = problemExpression;
                        if (!(ktExpression instanceof KtCallExpression)) {
                            ktExpression = null;
                        }
                        if ((ktCallExpression = (KtCallExpression)ktExpression) == null || (ktCallExpression = ktCallExpression.getCalleeExpression()) == null) {
                            ktCallExpression = problemExpression;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)ktCallExpression, (String)"(problemExpression as? K\u2026sion ?: problemExpression");
                        KtCallExpression reportElement = ktCallExpression;
                        this.this$0.$holder.registerProblem((PsiElement)reportElement, org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$getMESSAGE$p(SuspendFunctionOnCoroutineScopeInspection.Companion), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new WrapWithCoroutineScopeFix(false, true)});
                        instanceReference2 = fixes2;
                        Object object = new WrapWithCoroutineScopeFix(this.$extensionOfCoroutineScope, false);
                        instanceReference2.add(object);
                        if (this.$extensionOfCoroutineScope) {
                            instanceReference2 = fixes2;
                            object = new IntentionWrapper((IntentionAction)new ConvertReceiverToParameterIntention());
                            instanceReference2.add(object);
                        }
                        if (this.$memberOfCoroutineScope && (containingDeclaration2 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)this.$function))) instanceof KtClass && !((KtClass)containingDeclaration2).isInterface() && this.$function.hasBody()) {
                            object = fixes2;
                            IntentionWrapper intentionWrapper = new IntentionWrapper((IntentionAction)new MoveMemberToCompanionObjectIntention());
                            object.add(intentionWrapper);
                        }
                        containingDeclaration2 = this.$function;
                        object = containingDeclaration2;
                        ProblemsHolder problemsHolder = this.this$0.$holder;
                        boolean bl = false;
                        KtTypeReference ktTypeReference = $this$with.getReceiverTypeReference();
                        PsiElement psiElement3 = ktTypeReference != null ? (PsiElement)ktTypeReference : $this$with.getNameIdentifier();
                        if (psiElement3 == null) {
                            psiElement3 = psiElement2 = $this$with.getFunKeyword();
                        }
                        if (psiElement3 == null) {
                            psiElement2 = (PsiElement)$this$with;
                        }
                        PsiElement psiElement4 = psiElement2;
                        String string = org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$getMESSAGE$p(SuspendFunctionOnCoroutineScopeInspection.Companion);
                        Collection $this$toTypedArray$iv = fixes2;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                        Intrinsics.checkNotNull((Object)localQuickFixArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        problemsHolder.registerProblem(psiElement4, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$isReceiverOfAnalyzedFunction$2 = var2_2;
                        this.$context = bindingContext2;
                        this.$extensionOfCoroutineScope = bl;
                        this.$memberOfCoroutineScope = bl2;
                        this.$function = ktNamedFunction;
                        super(2);
                    }
                };
                PsiElement $i$a$-with-SuspendFunctionOnCoroutineScopeInspection$buildVisitor$1$22 = (PsiElement)function2;
                Function1 action$iv = (Function1)new Function1<KtCallExpression, Unit>(context2, $fun$checkSuspiciousReceiver$3){
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ buildVisitor.3 $checkSuspiciousReceiver$3;

                    public final void invoke(@NotNull KtCallExpression callExpression2) {
                        Intrinsics.checkNotNullParameter((Object)callExpression2, (String)"callExpression");
                        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression2), (BindingContext)this.$context);
                        if (resolvedCall2 == null) {
                            return;
                        }
                        ResolvedCall resolvedCall3 = resolvedCall2;
                        ReceiverParameterDescriptor receiverParameterDescriptor = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
                        if (receiverParameterDescriptor == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"resolvedCall.resultingDe\u2026ceiverParameter ?: return");
                        ReceiverParameterDescriptor extensionReceiverParameter = receiverParameterDescriptor;
                        KotlinType kotlinType = extensionReceiverParameter.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"extensionReceiverParameter.type");
                        if (!org.jetbrains.kotlin.idea.inspections.coroutines.SuspendFunctionOnCoroutineScopeInspection$Companion.access$isCoroutineScope(SuspendFunctionOnCoroutineScopeInspection.Companion, kotlinType)) {
                            return;
                        }
                        ReceiverValue receiverValue = resolvedCall3.getExtensionReceiver();
                        if (receiverValue == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"resolvedCall.extensionReceiver ?: return");
                        ReceiverValue extensionReceiver = receiverValue;
                        this.$checkSuspiciousReceiver$3.invoke(extensionReceiver, (KtExpression)callExpression2);
                    }
                    {
                        this.$context = bindingContext2;
                        this.$checkSuspiciousReceiver$3 = var2_2;
                        super(1);
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                PsiElement $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                boolean $i$f$forEachDescendantOfType2 = false;
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtCallExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
                $this$forEachDescendantOfType$iv = (PsiElement)function2;
                action$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(context2, $fun$checkSuspiciousReceiver$3){
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ buildVisitor.3 $checkSuspiciousReceiver$3;

                    public final void invoke(@NotNull KtNameReferenceExpression nameReferenceExpression) {
                        Intrinsics.checkNotNullParameter((Object)nameReferenceExpression, (String)"nameReferenceExpression");
                        if (Intrinsics.areEqual((Object)nameReferenceExpression.getReferencedName(), (Object)"coroutineContext") ^ true) {
                            return;
                        }
                        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)nameReferenceExpression), (BindingContext)this.$context);
                        if (resolvedCall2 == null) {
                            return;
                        }
                        ResolvedCall resolvedCall3 = resolvedCall2;
                        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall3.getResultingDescriptor())).asString(), (Object)"kotlinx.coroutines.CoroutineScope.coroutineContext")) {
                            ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
                            if (receiverValue == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"resolvedCall.dispatchReceiver ?: return");
                            ReceiverValue dispatchReceiver = receiverValue;
                            this.$checkSuspiciousReceiver$3.invoke(dispatchReceiver, (KtExpression)nameReferenceExpression);
                        }
                    }
                    {
                        this.$context = bindingContext2;
                        this.$checkSuspiciousReceiver$3 = var2_2;
                        super(1);
                    }
                };
                $i$f$forEachDescendantOfType = false;
                $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                $i$f$forEachDescendantOfType2 = false;
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtNameReferenceExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/SuspendFunctionOnCoroutineScopeInspection$WrapWithCoroutineScopeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "removeReceiver", "", "wrapCallOnly", "(ZZ)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "kotlin.idea"})
    private static final class WrapWithCoroutineScopeFix
    implements LocalQuickFix {
        private final boolean removeReceiver;
        private final boolean wrapCallOnly;

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("wrap.with.coroutine.scope.fix.family.name", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.removeReceiver && !this.wrapCallOnly ? KotlinBundle.message("wrap.with.coroutine.scope.fix.text3", new Object[0]) : (this.wrapCallOnly ? KotlinBundle.message("wrap.with.coroutine.scope.fix.text2", new Object[0]) : KotlinBundle.message("wrap.with.coroutine.scope.fix.text", new Object[0]));
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            void expressionToWrap;
            PsiElement problemElement;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                return;
            }
            PsiElement $this$getNonStrictParentOfType$iv = problemElement = psiElement2;
            boolean $i$f$getNonStrictParentOfType = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedFunction.class, (boolean)false);
            if (ktNamedFunction == null) {
                return;
            }
            KtNamedFunction function2 = ktNamedFunction;
            FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(function2, null, 1, null);
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function2)) {
                return;
            }
            KtExpression bodyExpression = function2.getBodyExpression();
            var $fun$getExpressionToWrapCall$1 = new Function0<KtExpression>(problemElement){
                final /* synthetic */ PsiElement $problemElement;

                @Nullable
                public final KtExpression invoke() {
                    PsiElement psiElement2 = this.$problemElement;
                    if (!(psiElement2 instanceof KtExpression)) {
                        psiElement2 = null;
                    }
                    KtExpression ktExpression = (KtExpression)psiElement2;
                    if (ktExpression == null) {
                        return null;
                    }
                    KtExpression result2 = ktExpression;
                    while (result2.getParent() instanceof KtQualifiedExpression || result2.getParent() instanceof KtCallExpression) {
                        PsiElement psiElement3 = result2.getParent();
                        if (psiElement3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        result2 = (KtExpression)psiElement3;
                    }
                    return result2;
                }
                {
                    this.$problemElement = psiElement2;
                    super(0);
                }
            };
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            KtExpression ktExpression = this.wrapCallOnly ? $fun$getExpressionToWrapCall$1.invoke() : bodyExpression;
            if (ktExpression == null) {
                return;
            }
            objectRef.element = ktExpression;
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            if (Companion.ofCoroutineScopeType((ReceiverParameterDescriptor)(functionDescriptor3 != null ? functionDescriptor3.getExtensionReceiverParameter() : null))) {
                void $this$forEachDescendantOfType$iv;
                BindingContext context2 = ResolutionUtils.analyzeWithContent((KtDeclaration)function2);
                PsiElement psiElement3 = (PsiElement)((KtExpression)expressionToWrap.element);
                Function1 action$iv = (Function1)new Function1<KtDotQualifiedExpression, Unit>(functionDescriptor2, context2, (Ref.ObjectRef)expressionToWrap){
                    final /* synthetic */ FunctionDescriptor $functionDescriptor;
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ Ref.ObjectRef $expressionToWrap;

                    public final void invoke(@NotNull KtDotQualifiedExpression it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        KtExpression ktExpression = it.getReceiverExpression();
                        if (!(ktExpression instanceof KtThisExpression)) {
                            ktExpression = null;
                        }
                        KtThisExpression receiverExpression = (KtThisExpression)ktExpression;
                        KtExpression selectorExpression = it.getSelectorExpression();
                        KtThisExpression ktThisExpression = receiverExpression;
                        if ((ktThisExpression != null ? ktThisExpression.getTargetLabel() : null) != null && selectorExpression != null && Intrinsics.areEqual((Object)((DeclarationDescriptor)this.$context.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)receiverExpression.getInstanceReference())), (Object)this.$functionDescriptor)) {
                            if (it == (KtExpression)this.$expressionToWrap.element) {
                                PsiElement psiElement2;
                                PsiElement $this$replaced$iv = (PsiElement)it;
                                boolean $i$f$replaced = false;
                                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)selectorExpression))) {
                                    psiElement2 = (PsiElement)selectorExpression;
                                } else {
                                    PsiElement result$iv = $this$replaced$iv.replace((PsiElement)selectorExpression);
                                    PsiElement psiElement3 = result$iv;
                                    if (!(psiElement3 instanceof KtExpression)) {
                                        psiElement3 = null;
                                    }
                                    if ((psiElement2 = (PsiElement)((KtExpression)psiElement3)) == null) {
                                        PsiElement psiElement4 = result$iv;
                                        if (psiElement4 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                        }
                                        KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement4).getExpression();
                                        if (ktExpression2 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                        }
                                        psiElement2 = (PsiElement)ktExpression2;
                                    }
                                }
                                this.$expressionToWrap.element = (KtExpression)psiElement2;
                            } else {
                                Intrinsics.checkNotNullExpressionValue((Object)it.replace((PsiElement)selectorExpression), (String)"it.replace(selectorExpression)");
                            }
                        }
                    }
                    {
                        this.$functionDescriptor = functionDescriptor2;
                        this.$context = bindingContext2;
                        this.$expressionToWrap = objectRef;
                        super(1);
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
                boolean $i$f$forEachDescendantOfType2 = false;
                $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                        if (element3 instanceof KtDotQualifiedExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
            }
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)function2), (boolean)false, (int)2, null);
            KtBlockExpression blockExpression2 = function2.getBodyBlockExpression();
            ApplicationUtilsKt.executeWriteCommand(project2, this.getName(), this, (Function0)new Function0<KtElement>((Ref.ObjectRef)expressionToWrap, bodyExpression, factory2, blockExpression2){
                final /* synthetic */ Ref.ObjectRef $expressionToWrap;
                final /* synthetic */ KtExpression $bodyExpression;
                final /* synthetic */ KtPsiFactory $factory;
                final /* synthetic */ KtBlockExpression $blockExpression;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KtElement invoke() {
                    KtExpression ktExpression;
                    PsiElement $this$replaced$iv;
                    StringBuilder newElement$iv;
                    if (Intrinsics.areEqual((Object)((KtExpression)this.$expressionToWrap.element), (Object)this.$bodyExpression) ^ true) {
                        StringBuilder stringBuilder;
                        PsiElement psiElement2 = (PsiElement)((KtExpression)this.$expressionToWrap.element);
                        newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)this.$factory, (String)"kotlinx.coroutines.coroutineScope { $0 }", (Object[])new Object[]{(KtExpression)this.$expressionToWrap.element}, (boolean)false, (int)4, null);
                        boolean $i$f$replaced = false;
                        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                            stringBuilder = newElement$iv;
                        } else {
                            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newElement$iv);
                            PsiElement psiElement3 = result$iv;
                            if (!(psiElement3 instanceof KtExpression)) {
                                psiElement3 = null;
                            }
                            if ((stringBuilder = (PsiElement)((KtExpression)psiElement3)) == null) {
                                PsiElement psiElement4 = result$iv;
                                if (psiElement4 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                }
                                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement4).getExpression();
                                if (ktExpression2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                }
                                stringBuilder = (PsiElement)ktExpression2;
                            }
                        }
                        ktExpression = (KtExpression)stringBuilder;
                    } else if (this.$blockExpression == null) {
                        StringBuilder stringBuilder;
                        $this$replaced$iv = (PsiElement)this.$bodyExpression;
                        newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)this.$factory, (String)"kotlinx.coroutines.coroutineScope { $0 }", (Object[])new Object[]{this.$bodyExpression}, (boolean)false, (int)4, null);
                        boolean $i$f$replaced = false;
                        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                            stringBuilder = newElement$iv;
                        } else {
                            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newElement$iv);
                            PsiElement psiElement5 = result$iv;
                            if (!(psiElement5 instanceof KtExpression)) {
                                psiElement5 = null;
                            }
                            if ((stringBuilder = (PsiElement)((KtExpression)psiElement5)) == null) {
                                PsiElement psiElement6 = result$iv;
                                if (psiElement6 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                }
                                KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement6).getExpression();
                                if (ktExpression3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                }
                                stringBuilder = (PsiElement)ktExpression3;
                            }
                        }
                        ktExpression = (KtExpression)stringBuilder;
                    } else {
                        PsiElement psiElement7;
                        void newElement$iv2;
                        void $this$replaced$iv2;
                        StringBuilder $this$buildString = newElement$iv = new StringBuilder();
                        boolean bl = false;
                        Iterator<E> iterator = this.$blockExpression.getStatements().iterator();
                        while (iterator.hasNext()) {
                            KtExpression statement2;
                            KtExpression ktExpression4 = statement2 = (KtExpression)iterator.next();
                            Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"statement");
                            $this$buildString.append(ktExpression4.getText());
                            $this$buildString.append("\n");
                        }
                        String string = newElement$iv.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                        String bodyText = string;
                        newElement$iv = (PsiElement)this.$blockExpression;
                        $this$buildString = (PsiElement)this.$factory.createBlock("kotlinx.coroutines.coroutineScope { " + bodyText + " }");
                        boolean $i$f$replaced = false;
                        if (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)newElement$iv2)) {
                            psiElement7 = newElement$iv2;
                        } else {
                            PsiElement result$iv = $this$replaced$iv2.replace((PsiElement)newElement$iv2);
                            PsiElement psiElement8 = result$iv;
                            if (!(psiElement8 instanceof KtBlockExpression)) {
                                psiElement8 = null;
                            }
                            if ((psiElement7 = (PsiElement)((KtBlockExpression)psiElement8)) == null) {
                                PsiElement psiElement9 = result$iv;
                                if (psiElement9 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                }
                                KtExpression ktExpression5 = ((KtParenthesizedExpression)psiElement9).getExpression();
                                if (ktExpression5 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                                }
                                psiElement7 = (PsiElement)((KtBlockExpression)ktExpression5);
                            }
                        }
                        ktExpression = (KtExpression)psiElement7;
                    }
                    KtExpression result2 = ktExpression;
                    PsiElement psiElement10 = PsiUtilsKt.reformatted$default((PsiElement)result2, false, 1, null);
                    if (psiElement10 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    }
                    return ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement10, null, 2, null);
                }
                {
                    this.$expressionToWrap = objectRef;
                    this.$bodyExpression = ktExpression;
                    this.$factory = ktPsiFactory;
                    this.$blockExpression = ktBlockExpression;
                    super(0);
                }
            });
            KtTypeReference receiverTypeReference2 = function2.getReceiverTypeReference();
            if (this.removeReceiver && !this.wrapCallOnly && receiverTypeReference2 != null) {
                UnusedReceiverParameterInspection.RemoveReceiverFix.Companion.apply$default(UnusedReceiverParameterInspection.RemoveReceiverFix.Companion, receiverTypeReference2, project2, false, 4, null);
            }
        }

        public WrapWithCoroutineScopeFix(boolean removeReceiver, boolean wrapCallOnly) {
            this.removeReceiver = removeReceiver;
            this.wrapCallOnly = wrapCallOnly;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000b*\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/SuspendFunctionOnCoroutineScopeInspection$Companion;", "", "()V", "COROUTINE_CONTEXT", "", "COROUTINE_SCOPE", "COROUTINE_SCOPE_WRAPPER", "MESSAGE", "getMESSAGE", "()Ljava/lang/String;", "isCoroutineScope", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "ofCoroutineScopeType", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "kotlin.idea"})
    public static final class Companion {
        private final String getMESSAGE() {
            return KotlinBundle.message("ambiguous.coroutinecontext.due.to.coroutinescope.receiver.of.suspend.function", new Object[0]);
        }

        private final boolean isCoroutineScope(KotlinType $this$isCoroutineScope) {
            ClassifierDescriptor classifierDescriptor = $this$isCoroutineScope.getConstructor().getDeclarationDescriptor();
            return Intrinsics.areEqual(classifierDescriptor != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null, (Object)SuspendFunctionOnCoroutineScopeInspection.COROUTINE_SCOPE);
        }

        private final boolean ofCoroutineScopeType(ReceiverParameterDescriptor $this$ofCoroutineScopeType) {
            boolean bl;
            block5: {
                if ($this$ofCoroutineScopeType == null) {
                    return false;
                }
                KotlinType kotlinType = $this$ofCoroutineScopeType.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
                if (this.isCoroutineScope(kotlinType)) {
                    return true;
                }
                Collection collection = $this$ofCoroutineScopeType.getType().getConstructor().getSupertypes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"type.constructor.supertypes");
                Iterable $this$any$iv = CollectionsKt.reversed((Iterable)collection);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        KotlinType kotlinType2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it");
                        if (!Companion.isCoroutineScope(kotlinType2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getMESSAGE$p(Companion $this) {
            return $this.getMESSAGE();
        }

        public static final /* synthetic */ boolean access$isCoroutineScope(Companion $this, KotlinType $this$access_u24isCoroutineScope) {
            return $this.isCoroutineScope($this$access_u24isCoroutineScope);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

