/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.coroutines;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.coroutines.AddCallOrUnwrapTypeFix;
import org.jetbrains.kotlin.idea.inspections.coroutines.RenameToFix;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableBuilderKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/AbstractIsResultInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "typeShortName", "", "typeFullName", "allowedSuffix", "allowedNames", "", "suggestedFunctionNameToCall", "shouldMakeSuspend", "", "simplify", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "analyzeFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "toReport", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "analyzeFunctionWithAllowedSuffix", "name", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "isOnTheFly", "kotlin.idea"})
public abstract class AbstractIsResultInspection
extends AbstractKotlinInspection {
    private final String typeShortName;
    private final String typeFullName;
    private final String allowedSuffix;
    private final Set<String> allowedNames;
    private final String suggestedFunctionNameToCall;
    private final boolean shouldMakeSuspend;
    private final Function1<KtExpression, Unit> simplify;

    /*
     * WARNING - void declaration
     */
    protected final void analyzeFunction(@NotNull KtNamedFunction function2, @NotNull PsiElement toReport, @NotNull ProblemsHolder holder) {
        String name2;
        String returnTypeText;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)toReport, (String)"toReport");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (function2 instanceof KtConstructor) {
            return;
        }
        KtTypeReference ktTypeReference = CallableBuilderKt.getReturnTypeReference((KtNamedDeclaration)function2);
        String string = returnTypeText = ktTypeReference != null ? ktTypeReference.getText() : null;
        if (returnTypeText != null && !StringsKt.contains$default((CharSequence)returnTypeText, (CharSequence)this.typeShortName, (boolean)false, (int)2, null)) {
            return;
        }
        Name name3 = function2.getNameAsName();
        String string2 = name2 = name3 != null ? name3.asString() : null;
        if (name2 == null || this.allowedNames.contains(name2)) {
            return;
        }
        KtTypeReference receiverTypeReference2 = function2.getReceiverTypeReference();
        if (receiverTypeReference2 != null) {
            String string3 = receiverTypeReference2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"receiverTypeReference.text");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)this.typeShortName, (boolean)false, (int)2, null)) {
                return;
            }
        }
        if (returnTypeText == null) {
            String text2;
            KtExpression ktExpression = function2.getBodyExpression();
            String string4 = text2 = ktExpression != null ? ktExpression.getText() : null;
            if (text2 != null) {
                boolean bl;
                block18: {
                    Iterable $this$none$iv = this.allowedNames;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.contains$default((CharSequence)text2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                if (bl && !StringsKt.contains$default((CharSequence)text2, (CharSequence)this.typeShortName, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text2, (CharSequence)this.allowedSuffix, (boolean)false, (int)2, null)) {
                    return;
                }
            }
        }
        FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(function2, null, 1, null);
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.returnType ?: return");
        KotlinType returnType2 = kotlinType;
        ClassifierDescriptor classifierDescriptor = returnType2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor returnTypeClass = classDescriptor;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)returnTypeClass)).asString(), (Object)this.typeFullName) ^ true) {
            return;
        }
        if (StringsKt.endsWith$default((String)name2, (String)this.allowedSuffix, (boolean)false, (int)2, null)) {
            this.analyzeFunctionWithAllowedSuffix(name2, descriptor2, toReport, holder);
        } else {
            void $this$toTypedArray$iv;
            String string5 = KotlinBundle.message("function.returning.0.with.a.name.that.does.not.end.with.1", this.typeShortName, this.allowedSuffix);
            Collection collection = CollectionsKt.listOf((Object[])new LocalQuickFix[]{new RenameToFix(name2 + this.allowedSuffix), new AddCallOrUnwrapTypeFix(function2.hasBody(), this.suggestedFunctionNameToCall, this.typeShortName, this.shouldMakeSuspend, this.simplify)});
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            Intrinsics.checkNotNull((Object)localQuickFixArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            holder.registerProblem(toReport, string5, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(this, holder){
            final /* synthetic */ AbstractIsResultInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                PsiElement psiElement2;
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                PsiElement psiElement3 = function2.getNameIdentifier();
                if (psiElement3 == null) {
                    psiElement3 = psiElement2 = function2.getFunKeyword();
                }
                if (psiElement3 == null) {
                    psiElement2 = (PsiElement)function2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"function.nameIdentifier \u2026on.funKeyword ?: function");
                this.this$0.analyzeFunction(function2, psiElement2, this.$holder);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    public void analyzeFunctionWithAllowedSuffix(@NotNull String name2, @NotNull FunctionDescriptor descriptor2, @NotNull PsiElement toReport, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)toReport, (String)"toReport");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public AbstractIsResultInspection(@NotNull String typeShortName, @NotNull String typeFullName, @NotNull String allowedSuffix, @NotNull Set<String> allowedNames, @NotNull String suggestedFunctionNameToCall, boolean shouldMakeSuspend, @NotNull Function1<? super KtExpression, Unit> simplify2) {
        Intrinsics.checkNotNullParameter((Object)typeShortName, (String)"typeShortName");
        Intrinsics.checkNotNullParameter((Object)typeFullName, (String)"typeFullName");
        Intrinsics.checkNotNullParameter((Object)allowedSuffix, (String)"allowedSuffix");
        Intrinsics.checkNotNullParameter(allowedNames, (String)"allowedNames");
        Intrinsics.checkNotNullParameter((Object)suggestedFunctionNameToCall, (String)"suggestedFunctionNameToCall");
        Intrinsics.checkNotNullParameter(simplify2, (String)"simplify");
        this.typeShortName = typeShortName;
        this.typeFullName = typeFullName;
        this.allowedSuffix = allowedSuffix;
        this.allowedNames = allowedNames;
        this.suggestedFunctionNameToCall = suggestedFunctionNameToCall;
        this.shouldMakeSuspend = shouldMakeSuspend;
        this.simplify = simplify2;
    }

    public /* synthetic */ AbstractIsResultInspection(String string, String string2, String string3, Set set2, String string4, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string, string2, string3, set2, string4, bl, (Function1<? super KtExpression, Unit>)function1);
    }
}

