/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.AbstractCallChainChecker;
import org.jetbrains.kotlin.idea.inspections.collections.SimplifyCallChainFix;
import org.jetbrains.kotlin.idea.util.PsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001f\b\u0002\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifyCallChainFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conversion", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;", "removeReceiverOfFirstCall", "", "runOptimizeImports", "modifyArguments", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;ZZLkotlin/jvm/functions/Function2;)V", "shortenedText", "", "apply", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "applyFix", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
public final class SimplifyCallChainFix
implements LocalQuickFix {
    private final String shortenedText;
    private final AbstractCallChainChecker.Conversion conversion;
    private final boolean removeReceiverOfFirstCall;
    private final boolean runOptimizeImports;
    private final Function2<KtPsiFactory, KtCallExpression, Unit> modifyArguments;

    @NotNull
    public String getName() {
        return KotlinBundle.message("simplify.call.chain.fix.text", this.shortenedText);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public final void apply(@NotNull KtQualifiedExpression qualifiedExpression) {
        PsiElement parent2;
        PsiElement result$iv;
        PsiElement call;
        PsiElement psiElement2;
        Object[] objectArray;
        Object object;
        Collection collection;
        Collection collection2;
        PsiElement secondCallTrailingComma;
        KtValueArgumentList secondCallArgumentList;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)qualifiedExpression), (boolean)false, (int)2, null);
        KtExpression firstExpression = qualifiedExpression.getReceiverExpression();
        String operationSign = this.removeReceiverOfFirstCall ? "" : ((ktExpression = firstExpression) instanceof KtSafeQualifiedExpression ? "?." : (ktExpression instanceof KtQualifiedExpression ? "." : ""));
        String receiverExpressionOrEmptyString = !this.removeReceiverOfFirstCall && firstExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)firstExpression).getReceiverExpression().getText() : "";
        KtCallExpression ktCallExpression = AbstractCallChainChecker.Companion.getCallExpression(firstExpression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression firstCallExpression = ktCallExpression;
        this.modifyArguments.invoke((Object)factory2, (Object)firstCallExpression);
        KtValueArgumentList firstCallArgumentList = firstCallExpression.getValueArgumentList();
        KtExpression ktExpression2 = qualifiedExpression.getSelectorExpression();
        if (!(ktExpression2 instanceof KtCallExpression)) {
            ktExpression2 = null;
        }
        KtCallExpression ktCallExpression2 = (KtCallExpression)ktExpression2;
        if (ktCallExpression2 == null) {
            return;
        }
        KtCallExpression secondCallExpression = ktCallExpression2;
        KtValueArgumentList ktValueArgumentList = secondCallArgumentList = secondCallExpression.getValueArgumentList();
        PsiElement psiElement3 = secondCallTrailingComma = ktValueArgumentList != null ? ktValueArgumentList.getTrailingComma() : null;
        if (psiElement3 != null) {
            psiElement3.delete();
        }
        apply.1 $fun$getTextInsideParentheses$1 = apply.1.INSTANCE;
        List list2 = firstCallExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"firstCallExpression.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        KtLambdaExpression lambdaExpression2 = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
        String additionalArgument = this.conversion.getAdditionalArgument();
        Object object2 = secondCallArgumentList;
        boolean secondCallHasArguments = object2 != null && (object2 = object2.getArguments()) != null && !(collection2 = (Collection)object2).isEmpty();
        Object object3 = firstCallArgumentList;
        boolean firstCallHasArguments = object3 != null && (object3 = object3.getArguments()) != null && !(collection = (Collection)object3).isEmpty();
        KtValueArgumentList ktValueArgumentList2 = object = secondCallArgumentList;
        int n = 0;
        Object[] objectArray2 = objectArray = new String[4];
        boolean bl = false;
        boolean bl2 = secondCallHasArguments;
        Object object4 = bl2 ? object : null;
        objectArray[n] = object4 != null ? $fun$getTextInsideParentheses$1.invoke((KtValueArgumentList)object4) : null;
        KtValueArgumentList it = object = firstCallArgumentList;
        n = 1;
        objectArray = objectArray2;
        boolean bl3 = false;
        bl2 = firstCallHasArguments;
        Object object5 = bl2 ? object : null;
        objectArray[n] = object5 != null ? $fun$getTextInsideParentheses$1.invoke((KtValueArgumentList)object5) : null;
        it = object = additionalArgument;
        n = 2;
        objectArray = objectArray2;
        boolean bl4 = false;
        bl2 = !firstCallHasArguments && !secondCallHasArguments;
        objectArray[n] = bl2 ? object : null;
        KtLambdaExpression ktLambdaExpression2 = lambdaExpression2;
        objectArray2[3] = ktLambdaExpression2 != null ? ktLambdaExpression2.getText() : null;
        String argumentsText2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        String newCallText = this.conversion.getReplacement();
        KtExpression newQualifiedOrCallExpression = factory2.createExpression(receiverExpressionOrEmptyString + operationSign + newCallText + "(" + argumentsText2 + ")");
        Project project2 = qualifiedExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"qualifiedExpression.project");
        Project project3 = project2;
        KtFile ktFile = qualifiedExpression.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"qualifiedExpression.containingKtFile");
        KtFile file2 = ktFile;
        PsiElement $this$replaced$iv = (PsiElement)qualifiedExpression;
        boolean $i$f$replaced2 = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)newQualifiedOrCallExpression))) {
            psiElement2 = (PsiElement)newQualifiedOrCallExpression;
        } else {
            PsiElement result$iv2 = $this$replaced$iv.replace((PsiElement)newQualifiedOrCallExpression);
            PsiElement psiElement4 = result$iv2;
            if (!(psiElement4 instanceof KtExpression)) {
                psiElement4 = null;
            }
            if ((psiElement2 = (PsiElement)((KtExpression)psiElement4)) == null) {
                PsiElement psiElement5 = result$iv2;
                if (psiElement5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement5).getExpression();
                if (ktExpression3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression3;
            }
        }
        KtExpression result2 = (KtExpression)psiElement2;
        if (lambdaExpression2 != null || additionalArgument != null) {
            KtCallExpression callExpression2;
            KtExpression $i$f$replaced2 = result2;
            KtCallExpression ktCallExpression3 = callExpression2 = $i$f$replaced2 instanceof KtQualifiedExpression ? org.jetbrains.kotlin.idea.intentions.UtilsKt.getCallExpression((KtQualifiedExpression)result2) : ($i$f$replaced2 instanceof KtCallExpression ? (KtCallExpression)result2 : null);
            if (ktCallExpression3 != null) {
                PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(ktCallExpression3);
            }
        }
        if (secondCallTrailingComma != null && !firstCallHasArguments) {
            Object object6;
            KtQualifiedExpression ktQualifiedExpression;
            KtExpression $this$safeAs$iv = result2;
            boolean $i$f$safeAs = false;
            KtExpression ktExpression4 = $this$safeAs$iv;
            if (!(ktExpression4 instanceof KtQualifiedExpression)) {
                ktExpression4 = null;
            }
            if ((ktQualifiedExpression = (KtQualifiedExpression)ktExpression4) == null || (ktQualifiedExpression = org.jetbrains.kotlin.idea.intentions.UtilsKt.getCallExpression(ktQualifiedExpression)) == null) {
                $this$safeAs$iv = result2;
                $i$f$safeAs = false;
                KtExpression ktExpression5 = $this$safeAs$iv;
                if (!(ktExpression5 instanceof KtCallExpression)) {
                    ktExpression5 = null;
                }
                ktQualifiedExpression = (KtCallExpression)ktExpression5;
            }
            if ((object6 = (call = ktQualifiedExpression)) != null && (object6 = object6.getValueArgumentList()) != null && (object6 = object6.getArguments()) != null && (object6 = (KtValueArgument)CollectionsKt.lastOrNull((List)object6)) != null) {
                object6.add(factory2.createComma());
            }
        }
        if (this.conversion.getAddNotNullAssertion()) {
            PsiElement psiElement6;
            call = (PsiElement)result2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0!!", (Object[])new Object[]{result2}, (boolean)false, (int)4, null);
            boolean $i$f$replaced3 = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement6 = newElement$iv;
            } else {
                result$iv = $this$replaced$iv.replace(newElement$iv);
                PsiElement psiElement7 = result$iv;
                if (!(psiElement7 instanceof KtExpression)) {
                    psiElement7 = null;
                }
                if ((psiElement6 = (PsiElement)((KtExpression)psiElement7)) == null) {
                    PsiElement psiElement8 = result$iv;
                    if (psiElement8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression6 = ((KtParenthesizedExpression)psiElement8).getExpression();
                    if (ktExpression6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement6 = (PsiElement)ktExpression6;
                }
            }
            result2 = (KtExpression)psiElement6;
        }
        if (this.conversion.getRemoveNotNullAssertion() && (parent2 = result2.getParent()) instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
            PsiElement psiElement9;
            PsiElement $this$replaced$iv2 = parent2;
            boolean $i$f$replaced4 = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)((PsiElement)result2))) {
                psiElement9 = (PsiElement)result2;
            } else {
                result$iv = $this$replaced$iv2.replace((PsiElement)result2);
                PsiElement psiElement10 = result$iv;
                if (!(psiElement10 instanceof KtExpression)) {
                    psiElement10 = null;
                }
                if ((psiElement9 = (PsiElement)((KtExpression)psiElement10)) == null) {
                    PsiElement psiElement11 = result$iv;
                    if (psiElement11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression7 = ((KtParenthesizedExpression)psiElement11).getExpression();
                    if (ktExpression7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement9 = (PsiElement)ktExpression7;
                }
            }
            result2 = (KtExpression)psiElement9;
        }
        KtFile ktFile2 = result2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"result.containingKtFile");
        UtilsKt.commitAndUnblockDocument((PsiFile)ktFile2);
        if (result2.isValid()) {
            PsiElement psiElement12 = PsiUtilsKt.reformatted$default((PsiElement)result2, false, 1, null);
            if (psiElement12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement12, null, 2, null);
        }
        if (this.runOptimizeImports) {
            new OptimizeImportsProcessor(project3, (PsiFile)file2).run();
        }
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtQualifiedExpression)) {
                psiElement2 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement2;
            if (ktQualifiedExpression == null) break block1;
            KtQualifiedExpression ktQualifiedExpression2 = ktQualifiedExpression;
            SimplifyCallChainFix simplifyCallChainFix = this;
            KtQualifiedExpression p1 = ktQualifiedExpression2;
            boolean bl = false;
            simplifyCallChainFix.apply(p1);
        }
    }

    public SimplifyCallChainFix(@NotNull AbstractCallChainChecker.Conversion conversion2, boolean removeReceiverOfFirstCall, boolean runOptimizeImports, @NotNull Function2<? super KtPsiFactory, ? super KtCallExpression, Unit> modifyArguments) {
        Intrinsics.checkNotNullParameter((Object)conversion2, (String)"conversion");
        Intrinsics.checkNotNullParameter(modifyArguments, (String)"modifyArguments");
        this.conversion = conversion2;
        this.removeReceiverOfFirstCall = removeReceiverOfFirstCall;
        this.runOptimizeImports = runOptimizeImports;
        this.modifyArguments = modifyArguments;
        this.shortenedText = StringsKt.substringAfterLast$default((String)this.conversion.getReplacement(), (String)".", null, (int)2, null);
    }

    public /* synthetic */ SimplifyCallChainFix(AbstractCallChainChecker.Conversion conversion2, boolean bl, boolean bl2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        this(conversion2, bl, bl2, (Function2<? super KtPsiFactory, ? super KtCallExpression, Unit>)function2);
    }
}

