/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceIndexLoopWithCollectionLoopQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallsInspectionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "visitRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "left", "right", "operator", "Companion", "kotlin.idea"})
public final class ReplaceManualRangeWithIndicesCallsInspection
extends AbstractKotlinInspection {
    private static final Set<String> rangeFunctionNames;
    private static final List<FqName> rangeFunctionFqNames;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ ReplaceManualRangeWithIndicesCallsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression) {
                Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                KtExpression ktExpression = binaryExpression.getLeft();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"binaryExpression.left ?: return");
                KtExpression left = ktExpression;
                KtExpression ktExpression2 = binaryExpression.getRight();
                if (ktExpression2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"binaryExpression.right ?: return");
                KtExpression right2 = ktExpression2;
                KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"binaryExpression.operationReference");
                KtOperationReferenceExpression operator = ktOperationReferenceExpression;
                ReplaceManualRangeWithIndicesCallsInspection.access$visitRange(this.this$0, this.$holder, (KtExpression)binaryExpression, left, right2, (KtExpression)operator);
            }

            public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)expression2);
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression call = ktCallExpression;
                KtExpression left = expression2.getReceiverExpression();
                List list2 = call.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"call.valueArguments");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
                if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktValueArgument, (String)"call.valueArguments.sing\u2026entExpression() ?: return");
                KtValueArgument right2 = ktValueArgument;
                KtExpression ktExpression = call.getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"call.calleeExpression ?: return");
                KtExpression operator = ktExpression;
                ReplaceManualRangeWithIndicesCallsInspection.access$visitRange(this.this$0, this.$holder, (KtExpression)expression2, left, (KtExpression)right2, operator);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final void visitRange(ProblemsHolder holder, KtExpression range2, KtExpression left, KtExpression right2, KtExpression operator) {
        KtExpression collection;
        KtExpression sizeOrLengthCall;
        if (!rangeFunctionNames.contains(operator.getText())) {
            return;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)range2, null, 1, null);
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null || (resolvedCall2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2))) == null) {
            return;
        }
        ResolvedCall functionFqName = resolvedCall2;
        if (!rangeFunctionFqNames.contains(functionFqName)) {
            return;
        }
        String string = functionFqName.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionFqName.shortName().asString()");
        String rangeFunction2 = string;
        Integer n = ReplaceManualRangeWithIndicesCallsInspectionKt.access$toIntConstant(left);
        if (n == null || n != 0) {
            return;
        }
        KtExpression ktExpression = ReplaceManualRangeWithIndicesCallsInspectionKt.access$sizeOrLengthCall(right2, rangeFunction2);
        if (ktExpression == null) {
            return;
        }
        KtExpression $this$safeAs$iv = sizeOrLengthCall = ktExpression;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression2 = $this$safeAs$iv;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        Object object = collection = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (collection != null && !(collection instanceof KtSimpleNameExpression)) {
            return;
        }
        PsiElement psiElement2 = range2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"range.parent");
        PsiElement parent2 = psiElement2.getParent();
        if (parent2 instanceof KtForExpression) {
            KtArrayAccessExpression arrayAccess;
            PsiElement psiElement3;
            KtParameter ktParameter = ((KtForExpression)parent2).getLoopParameter();
            if (ktParameter == null || (ktParameter = ktParameter.getOriginalElement()) == null) {
                return;
            }
            KtParameter paramElement = ktParameter;
            Query query = ReferencesSearch.search((PsiElement)paramElement);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(paramElement)");
            PsiReference psiReference = (PsiReference)CollectionsKt.singleOrNull((Iterable)((Iterable)query));
            Object usageElement = psiReference != null ? psiReference.getElement() : null;
            PsiElement psiElement4 = usageElement;
            if (!((psiElement4 != null && (psiElement4 = psiElement4.getParent()) != null ? psiElement4.getParent() : (psiElement3 = null)) instanceof KtArrayAccessExpression)) {
                psiElement3 = null;
            }
            if ((arrayAccess = (KtArrayAccessExpression)psiElement3) != null) {
                List list2 = arrayAccess.getIndexExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"arrayAccess.indexExpressions");
                if (Intrinsics.areEqual((Object)((KtExpression)CollectionsKt.singleOrNull((List)list2)), (Object)usageElement)) {
                    PsiElement arrayAccessParent;
                    KtExpression ktExpression3;
                    KtSimpleNameExpression ktSimpleNameExpression;
                    KtExpression ktExpression4 = arrayAccess.getArrayExpression();
                    if (!(ktExpression4 instanceof KtSimpleNameExpression)) {
                        ktExpression4 = null;
                    }
                    if (Intrinsics.areEqual((Object)((ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression4) != null && (ktSimpleNameExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression)) != null ? ktSimpleNameExpression.resolve() : null), (ktExpression3 = collection) != null && (ktExpression3 = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression3))) != null ? ktExpression3.resolve() : null) && (!((arrayAccessParent = arrayAccess.getParent()) instanceof KtBinaryExpression) || Intrinsics.areEqual((Object)((KtBinaryExpression)arrayAccessParent).getLeft(), (Object)arrayAccess) ^ true || !KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)arrayAccessParent).getOperationToken()))) {
                        holder.registerProblem((PsiElement)range2, KotlinBundle.message("for.loop.over.indices.could.be.replaced.with.loop.over.elements", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceIndexLoopWithCollectionLoopQuickFix(rangeFunction2)});
                        return;
                    }
                }
            }
        }
        holder.registerProblem((PsiElement)range2, KotlinBundle.message("range.could.be.replaced.with.indices.call", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceManualRangeWithIndicesCallQuickFix()});
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        rangeFunctionNames = SetsKt.setOf((Object[])new String[]{"until", "rangeTo", ".."});
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])new String[]{"Char", "Byte", "Short", "Int", "Long", "UByte", "UShort", "UInt", "ULong"});
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FqName fqName2 = new FqName("kotlin." + (String)it + ".rangeTo");
            collection.add(fqName2);
        }
        rangeFunctionFqNames = CollectionsKt.plus((Collection)((List)var3_3), (Object)new FqName("kotlin.ranges.until"));
    }

    public static final /* synthetic */ void access$visitRange(ReplaceManualRangeWithIndicesCallsInspection $this, ProblemsHolder holder, KtExpression range2, KtExpression left, KtExpression right2, KtExpression operator) {
        $this.visitRange(holder, range2, left, right2, operator);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection$Companion;", "", "()V", "rangeFunctionFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "rangeFunctionNames", "", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

