/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.highlighter.DeclarationKindDetector;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.idea.quickfix.KotlinSuppressIntentionAction;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"createSuppressWarningActions", "", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "element", "Lcom/intellij/psi/PsiElement;", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressionKey", "", "kotlin.core"})
public final class KotlinSuppressableWarningProblemGroupKt {
    @NotNull
    public static final List<SuppressIntentionAction> createSuppressWarningActions(@NotNull PsiElement element3, @NotNull DiagnosticFactory<?> diagnosticFactory) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(diagnosticFactory, (String)"diagnosticFactory");
        return KotlinSuppressableWarningProblemGroupKt.createSuppressWarningActions(element3, diagnosticFactory.getSeverity(), diagnosticFactory.getName());
    }

    @NotNull
    public static final List<SuppressIntentionAction> createSuppressWarningActions(@NotNull PsiElement element3, @NotNull Severity severity, @NotNull String suppressionKey) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
        if (severity != Severity.WARNING) {
            return CollectionsKt.emptyList();
        }
        ArrayList<KotlinSuppressIntentionAction> actions = new ArrayList<KotlinSuppressIntentionAction>();
        boolean suppressAtStatementAllowed = true;
        for (PsiElement current = element3; current != null; current = current.getParent()) {
            if (current instanceof KtDeclaration && !(current instanceof KtDestructuringDeclaration)) {
                PsiElement declaration2 = current;
                AnnotationHostKind kind2 = DeclarationKindDetector.INSTANCE.detect((KtDeclaration)declaration2);
                if (kind2 != null) {
                    actions.add(new KotlinSuppressIntentionAction((KtExpression)declaration2, suppressionKey, kind2));
                }
                suppressAtStatementAllowed = false;
                continue;
            }
            if (current instanceof KtExpression && suppressAtStatementAllowed) {
                if (!(((KtExpression)current).getParent() instanceof KtBlockExpression) && !(((KtExpression)current).getParent() instanceof KtDestructuringDeclaration)) continue;
                String kind3 = ((KtExpression)current).getParent() instanceof KtBlockExpression ? KotlinIdeaAnalysisBundle.message("declaration.kind.statement", new Object[0]) : KotlinIdeaAnalysisBundle.message("declaration.kind.initializer", new Object[0]);
                actions.add(new KotlinSuppressIntentionAction((KtExpression)current, suppressionKey, new AnnotationHostKind(kind3, "", true)));
                suppressAtStatementAllowed = false;
                continue;
            }
            if (!(current instanceof KtFile)) continue;
            KtFile ktFile = (KtFile)current;
            String string = KotlinIdeaAnalysisBundle.message("declaration.kind.file", new Object[0]);
            String string2 = ((KtFile)current).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"current.name");
            actions.add(new KotlinSuppressIntentionAction(ktFile, suppressionKey, new AnnotationHostKind(string, string2, true)));
            suppressAtStatementAllowed = false;
        }
        return actions;
    }
}

