/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinIndentationAdjuster;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinLineIndentProvider;", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider;", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "indentionSettings", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinIndentationAdjuster;", "Companion", "kotlin.idea"})
public final class KotlinLineIndentProvider
extends KotlinLangLineIndentProvider {
    private static boolean useFormatter;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public String getLineIndent(@NotNull Project project2, @NotNull Editor editor2, @Nullable Language language2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return useFormatter ? null : super.getLineIndent(project2, editor2, language2, offset2);
    }

    @Override
    @NotNull
    public KotlinIndentationAdjuster indentionSettings(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return new KotlinIndentationAdjuster(editor2){
            private final CodeStyleSettings settings;
            final /* synthetic */ Editor $editor;

            public final CodeStyleSettings getSettings() {
                return this.settings;
            }

            public boolean getAlignWhenMultilineFunctionParentheses() {
                CodeStyleSettings codeStyleSettings = this.settings;
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"settings");
                return CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)codeStyleSettings).ALIGN_MULTILINE_METHOD_BRACKETS;
            }

            public boolean getAlignWhenMultilineBinaryExpression() {
                CodeStyleSettings codeStyleSettings = this.settings;
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"settings");
                return CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)codeStyleSettings).ALIGN_MULTILINE_BINARY_OPERATION;
            }

            public boolean getContinuationIndentInElvis() {
                CodeStyleSettings codeStyleSettings = this.settings;
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"settings");
                return CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)codeStyleSettings).CONTINUATION_INDENT_IN_ELVIS;
            }

            public boolean getContinuationIndentForExpressionBodies() {
                CodeStyleSettings codeStyleSettings = this.settings;
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"settings");
                return CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)codeStyleSettings).CONTINUATION_INDENT_FOR_EXPRESSION_BODIES;
            }
            {
                this.$editor = $captured_local_variable$0;
                this.settings = CodeStyle.getSettings((Editor)$captured_local_variable$0);
            }
        };
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinLineIndentProvider$Companion;", "", "()V", "<set-?>", "", "useFormatter", "getUseFormatter", "()Z", "setUseFormatter", "(Z)V", "kotlin.idea"})
    public static final class Companion {
        @TestOnly
        public final boolean getUseFormatter() {
            return useFormatter;
        }

        @TestOnly
        public final void setUseFormatter(boolean bl) {
            useFormatter = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

