/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.JavaPsiImplementationHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelperKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.KotlinExceptionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000267B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J7\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\t2\u0006\u0010\u0012\u001a\u0002H\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0 H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020$2\u0006\u0010\n\u001a\u00020$J\u0016\u0010)\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\"H\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010.\u001a\u00020/H\u0007J\u0010\u00100\u001a\u00020/2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001c2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001c*\u000204H\u0002J\u0018\u00105\u001a\b\u0012\u0004\u0012\u0002020\u001c*\b\u0012\u0004\u0012\u0002020\"H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forceResolve", "", "convertPropertyOrFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "findClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "findFirstMatchingInIndex", "T", "entity", "index", "Lcom/intellij/psi/stubs/StringStubIndexExtension;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;Lcom/intellij/psi/stubs/StringStubIndexExtension;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findSpecialProperty", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getInitialMemberCandidates", "", "sourceClassOrObject", "name", "declarationClass", "Ljava/lang/Class;", "getInitialTopLevelCandidates", "", "getNavigationElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOriginalClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "getOriginalElement", "haveRenamesInImports", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "navigateToDeclaration", "from", "resetForceResolve", "", "setForceResolve", "targetScopes", "Lcom/intellij/psi/search/GlobalSearchScope;", "associatedCommonLibraries", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "union", "NavigationKind", "SourceAndDecompiledConversionVisitor", "kotlin.core"})
public final class SourceNavigationHelper {
    private static final Logger LOG;
    private static boolean forceResolve;
    @NotNull
    public static final SourceNavigationHelper INSTANCE;

    @TestOnly
    public final void resetForceResolve() {
        forceResolve = false;
    }

    @TestOnly
    public final void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<GlobalSearchScope> targetScopes(KtNamedDeclaration declaration, NavigationKind navigationKind) {
        v0 = declaration.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"declaration.containingKtFile");
        containingFile = v0;
        v1 = containingFile.getVirtualFile();
        if (v1 == null) {
            return CollectionsKt.emptyList();
        }
        vFile = v1;
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                v2 = declaration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"declaration.project");
                binaryModuleInfos = GetModuleInfoKt.getBinaryLibrariesModuleInfos(v2, vFile);
                var7_7 = binaryModuleInfos;
                var24_10 = this;
                $i$f$mapNotNull = false;
                var9_17 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var14_38 = $this$forEach$iv$iv$iv.iterator();
                while (var14_38.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var14_38.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (BinaryModuleInfo)element$iv$iv;
                    $i$a$-mapNotNull-SourceNavigationHelper$targetScopes$primaryScope$1 = false;
                    v3 = it.getSourcesModuleInfo();
                    v4 /* !! */  = v3 != null ? v3.sourceScope() : null;
                    if (v4 /* !! */  == null) continue;
                    it$iv$iv = var20_51 = v4 /* !! */ ;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var25_56 = (List)destination$iv$iv;
                primaryScope = var24_10.union(var25_56);
                $i$f$mapNotNull = binaryModuleInfos;
                var24_10 = this;
                $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (BinaryModuleInfo)element$iv$iv;
                    $i$a$-flatMap-SourceNavigationHelper$targetScopes$additionalScope$1 = false;
                    list$iv$iv = SourceNavigationHelper.INSTANCE.associatedCommonLibraries(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                var25_56 = (List)destination$iv$iv;
                $this$flatMap$iv = var25_56;
                $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var15_41 = $this$forEach$iv$iv$iv.iterator();
                while (var15_41.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var15_41.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (BinaryModuleInfo)element$iv$iv;
                    $i$a$-mapNotNull-SourceNavigationHelper$targetScopes$additionalScope$2 = false;
                    v5 = it.getSourcesModuleInfo();
                    v6 /* !! */  = v5 != null ? v5.sourceScope() : null;
                    if (v6 /* !! */  == null) continue;
                    it$iv$iv = var21_53 = v6 /* !! */ ;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var25_56 = (List)destination$iv$iv;
                additionalScope = var24_10.union(var25_56);
                $this$any$iv = binaryModuleInfos;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl79
                v7 = false;
                ** GOTO lbl86
lbl79:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (BinaryModuleInfo)element$iv;
                    $i$a$-any-SourceNavigationHelper$targetScopes$1 = false;
                    if (!(it instanceof ScriptDependenciesInfo)) continue;
                    v7 = true;
                    ** GOTO lbl86
                }
                v7 = false;
lbl86:
                // 3 sources

                if (v7) {
                    v8 = CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
                    v9 = ProjectScope.getContentScope((Project)containingFile.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"ProjectScope.getContentS\u2026e(containingFile.project)");
                    v10 = CollectionsKt.plus((Collection)v8, (Object)v9);
                    break;
                }
                v10 = CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
                break;
            }
            case 2: {
                if (JvmFileClassUtilKt.getFileClassInfo((KtFile)containingFile) instanceof JvmMultifileClassPartInfo) {
                    v11 = containingFile.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"containingFile.project");
                    v12 = JavaElementFinder.Companion.getInstance(v11);
                    v13 = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)containingFile).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"containingFile.javaFileFacadeFqName.asString()");
                    v14 = declaration.getResolveScope();
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"declaration.resolveScope");
                    psiClass = v12.findClass(v13, v14);
                    if (psiClass != null) {
                        v15 = declaration.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"declaration.project");
                        v16 = psiClass.getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"psiClass.containingFile");
                        v17 = v16.getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"psiClass.containingFile.virtualFile");
                        primaryScope = GetModuleInfoKt.getBinaryLibrariesModuleInfos(v15, v17);
                        var24_11 = this;
                        $i$f$map = false;
                        $this$any$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            $i$a$-any-SourceNavigationHelper$targetScopes$1 = (BinaryModuleInfo)item$iv$iv;
                            var25_57 = destination$iv$iv;
                            $i$a$-map-SourceNavigationHelper$targetScopes$2 = false;
                            var26_63 = it.binariesScope();
                            var25_57.add(var26_63);
                        }
                        var25_57 = (List)destination$iv$iv;
                        return var24_11.union((Collection<? extends GlobalSearchScope>)var25_57);
                    }
                }
                v18 = declaration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"declaration.project");
                psiClass = GetModuleInfoKt.getLibrarySourcesModuleInfos(v18, vFile);
                var24_12 = this;
                $i$f$map = false;
                $i$f$map = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    item$iv$iv = (LibrarySourceInfo)item$iv$iv;
                    var25_58 = destination$iv$iv;
                    $i$a$-map-SourceNavigationHelper$targetScopes$3 = false;
                    var26_64 = it.getBinariesModuleInfo().binariesScope();
                    var25_58.add(var26_64);
                }
                var25_58 = (List)destination$iv$iv;
                v10 = var24_12.union((Collection<? extends GlobalSearchScope>)var25_58);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v10;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BinaryModuleInfo> associatedCommonLibraries(BinaryModuleInfo $this$associatedCommonLibraries) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        if (TargetPlatformKt.isCommon((TargetPlatform)$this$associatedCommonLibraries.getPlatform())) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filterIsInstance$iv = $this$associatedCommonLibraries.dependencies();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BinaryModuleInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
            boolean bl = false;
            if (!TargetPlatformKt.isCommon((TargetPlatform)it.getPlatform())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<GlobalSearchScope> union(Collection<? extends GlobalSearchScope> $this$union) {
        List list2;
        Collection<? extends GlobalSearchScope> collection = $this$union;
        if (!collection.isEmpty()) {
            Collection<? extends GlobalSearchScope> $this$toTypedArray$iv = $this$union;
            boolean $i$f$toTypedArray = false;
            Collection<? extends GlobalSearchScope> thisCollection$iv = $this$toTypedArray$iv;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            Intrinsics.checkNotNull((Object)globalSearchScopeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            list2 = CollectionsKt.listOf((Object)GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final boolean haveRenamesInImports(Collection<? extends KtFile> files2) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = files2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        KtFile file2 = (KtFile)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = file2.getImportDirectives();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                KtImportDirective it = (KtImportDirective)element$iv2;
                                boolean bl4 = false;
                                if (!(it.getAliasName() != null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtNamedDeclaration findSpecialProperty(Name memberName2, KtClass containingClass2) {
        List constructorParameters = containingClass2.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!Intrinsics.areEqual((Object)memberName2, (Object)constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return (KtNamedDeclaration)constructorParameter;
        }
        if (containingClass2.hasModifier(KtTokens.ENUM_KEYWORD)) {
            Iterator iterator = ContainerUtil.findAll((Collection)containingClass2.getDeclarations(), KtEnumEntry.class).iterator();
            while (iterator.hasNext()) {
                KtEnumEntry enumEntry;
                KtEnumEntry ktEnumEntry = enumEntry = (KtEnumEntry)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)ktEnumEntry, (String)"enumEntry");
                if (!Intrinsics.areEqual((Object)memberName2, (Object)ktEnumEntry.getNameAsName())) continue;
                return (KtNamedDeclaration)enumEntry;
            }
        }
        return null;
    }

    private final KtNamedDeclaration convertPropertyOrFunction(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        Object sourceClassOrObject;
        if (declaration2 instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject2 = this.findClassOrObject(((KtPrimaryConstructor)declaration2).getContainingClassOrObject(), navigationKind);
            KtClassOrObject ktClassOrObject = sourceClassOrObject2;
            return ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getPrimaryConstructor()) != null ? (KtNamedDeclaration)ktClassOrObject : (KtNamedDeclaration)sourceClassOrObject2;
        }
        String memberNameAsString = declaration2.getName();
        if (memberNameAsString == null) {
            LOG.debug("Declaration with null name:" + DebugTextUtilKt.getDebugText((KtElement)((KtElement)declaration2)));
            return null;
        }
        Name name2 = Name.identifier((String)memberNameAsString);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(memberNameAsString)");
        Name memberName2 = name2;
        PsiElement decompiledContainer = declaration2.getParent();
        Collection candidates2 = null;
        PsiElement psiElement2 = decompiledContainer;
        if (psiElement2 instanceof KtFile) {
            candidates2 = this.getInitialTopLevelCandidates(declaration2, navigationKind);
        } else if (psiElement2 instanceof KtClassBody) {
            Object object;
            List<KtNamedDeclaration> list2;
            KtClassOrObject ktClassOrObject;
            PsiElement psiElement3 = decompiledContainer.getParent();
            if (psiElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            KtClassOrObject decompiledClassOrObject = (KtClassOrObject)psiElement3;
            KtClassOrObject ktClassOrObject2 = sourceClassOrObject = this.findClassOrObject(decompiledClassOrObject, navigationKind);
            if (ktClassOrObject2 != null) {
                KtClassOrObject it = ktClassOrObject = ktClassOrObject2;
                boolean bl = false;
                list2 = INSTANCE.getInitialMemberCandidates((KtClassOrObject)sourceClassOrObject, memberName2, (Class<? extends KtNamedDeclaration>)declaration2.getClass());
            } else {
                list2 = null;
            }
            if ((object = (ktClassOrObject = list2)) == null) {
                object = CollectionsKt.emptyList();
            }
            if ((candidates2 = (Collection)object).isEmpty() && declaration2 instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                return this.findSpecialProperty(memberName2, (KtClass)sourceClassOrObject);
            }
        } else {
            throw (Throwable)KotlinExceptionUtils.withPsiAttachment(KotlinExceptionUtils.withPsiAttachment(KotlinExceptionUtils.withPsiAttachment(new KotlinExceptionWithAttachments("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName()), "declaration", (PsiElement)declaration2), "container", decompiledContainer), "file", (PsiElement)declaration2.getContainingFile());
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            KtNamedDeclaration it;
            Iterable $this$filterTo$iv$iv;
            ProgressManager.checkCanceled();
            Iterable $this$filter$iv = candidates2;
            boolean $i$f$filter = false;
            sourceClassOrObject = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                if (!MemberMatching.sameReceiverPresenceAndParametersCount(it, declaration2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates2 = (List)destination$iv$iv;
            if (candidates2.size() <= 1) {
                return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
            }
            if (!this.haveRenamesInImports(SourceNavigationHelperKt.access$getContainingFiles(candidates2))) {
                ProgressManager.checkCanceled();
                $this$filter$iv = candidates2;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (KtNamedDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!MemberMatching.receiverAndParametersShortTypesMatch(it, declaration2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates2 = (List)destination$iv$iv;
                if (candidates2.size() <= 1) {
                    return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
                }
            }
        }
        for (KtNamedDeclaration candidate2 : candidates2) {
            CallableDescriptor candidateDescriptor;
            ProgressManager.checkCanceled();
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)candidate2, null, 1, null);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((CallableDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (!MemberMatching.receiversMatch(declaration2, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration2, candidateDescriptor)) continue;
            KtNamedDeclaration ktNamedDeclaration = declaration2;
            if (ktNamedDeclaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterListOwner");
            }
            if (!MemberMatching.typeParametersMatch((KtTypeParameterListOwner)ktNamedDeclaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate2;
        }
        return null;
    }

    private final <T extends KtNamedDeclaration> T findFirstMatchingInIndex(T entity, NavigationKind navigationKind, StringStubIndexExtension<T> index2) {
        KtNamedDeclaration ktNamedDeclaration;
        block7: {
            FqName fqName2 = entity.getFqName();
            if (fqName2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"entity.fqName ?: return null");
            FqName classFqName = fqName2;
            Iterable iterable = this.targetScopes(entity, navigationKind);
            for (Object t : iterable) {
                KtNamedDeclaration ktNamedDeclaration2;
                Object v2;
                GlobalSearchScope scope2 = (GlobalSearchScope)t;
                boolean bl = false;
                ProgressManager.checkCanceled();
                Collection collection = index2.get((Object)classFqName.asString(), entity.getProject(), scope2);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"index.get(classFqName.as\u2026), entity.project, scope)");
                Iterable $this$minByOrNull$iv = collection;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = minElem$iv;
                    } else {
                        KtNamedDeclaration it = (KtNamedDeclaration)minElem$iv;
                        boolean bl2 = false;
                        KtNamedDeclaration ktNamedDeclaration3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration3, (String)"it");
                        boolean minValue$iv = ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration3);
                        do {
                            Object e$iv = iterator$iv.next();
                            KtNamedDeclaration it2 = (KtNamedDeclaration)e$iv;
                            $i$a$-minByOrNull-SourceNavigationHelper$findFirstMatchingInIndex$1$1 = false;
                            KtNamedDeclaration ktNamedDeclaration4 = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration4, (String)"it");
                            boolean v$iv = ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration4);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = minElem$iv;
                    }
                }
                if ((ktNamedDeclaration2 = (KtNamedDeclaration)v2) == null) continue;
                ktNamedDeclaration = ktNamedDeclaration2;
                break block7;
            }
            ktNamedDeclaration = null;
        }
        return (T)ktNamedDeclaration;
    }

    private final KtClassOrObject findClassOrObject(KtClassOrObject decompiledClassOrObject, NavigationKind navigationKind) {
        return (KtClassOrObject)this.findFirstMatchingInIndex((KtNamedDeclaration)decompiledClassOrObject, navigationKind, KotlinFullClassNameIndex.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtNamedDeclaration> getInitialTopLevelCandidates(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        void $this$flatMapTo$iv$iv;
        StringStubIndexExtension stringStubIndexExtension;
        List<GlobalSearchScope> scopes = this.targetScopes(declaration2, navigationKind);
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            stringStubIndexExtension = KotlinTopLevelFunctionFqnNameIndex.INSTANCE;
        } else if (ktNamedDeclaration instanceof KtProperty) {
            stringStubIndexExtension = KotlinTopLevelPropertyFqnNameIndex.INSTANCE;
        } else {
            throw (Throwable)new IllegalArgumentException("Neither function nor declaration: " + declaration2.getClass().getName());
        }
        StringStubIndexExtension index2 = stringStubIndexExtension;
        Iterable $this$flatMap$iv = scopes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GlobalSearchScope scope2 = (GlobalSearchScope)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            FqName fqName2 = declaration2.getFqName();
            Intrinsics.checkNotNull((Object)fqName2);
            Collection collection = index2.get((Object)fqName2.asString(), declaration2.getProject(), scope2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"index.get(declaration.fq\u2026claration.project, scope)");
            Iterable $this$sortedBy$iv = collection;
            boolean $i$f$sortedBy = false;
            Iterable list$iv$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    KtNamedDeclaration it = (KtNamedDeclaration)a;
                    boolean bl = false;
                    KtNamedDeclaration ktNamedDeclaration = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration, (String)"it");
                    it = (KtNamedDeclaration)b;
                    Comparable comparable = Boolean.valueOf(ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration));
                    bl = false;
                    KtNamedDeclaration ktNamedDeclaration2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration2, (String)"it");
                    Boolean bl2 = ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration2);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl2);
                }
            });
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getInitialMemberCandidates(KtClassOrObject sourceClassOrObject, Name name2, Class<? extends KtNamedDeclaration> declarationClass2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)sourceClassOrObject.getDeclarations(), declarationClass2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtNamedDeclaration declaration2 = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)name2, (Object)declaration2.getNameAsSafeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiClass getOriginalClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classOrObject.fqName ?: return null");
        FqName fqName3 = fqName2;
        Project project2 = classOrObject.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"classOrObject.project");
        Project project3 = project2;
        PsiElement psiElement2 = JavaPsiImplementationHelperImpl.findCompiledElement((Project)project3, (PsiElement)((PsiElement)classOrObject), (Function)new Function(project3, fqName3){
            final /* synthetic */ Project $project;
            final /* synthetic */ FqName $fqName;

            public final Collection<PsiElement> apply(GlobalSearchScope scope2) {
                return CollectionsKt.listOfNotNull((Object)JavaPsiFacade.getInstance((Project)this.$project).findClass(this.$fqName.asString(), scope2));
            }
            {
                this.$project = project2;
                this.$fqName = fqName2;
            }
        });
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        return (PsiClass)psiElement2;
    }

    @NotNull
    public final KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.CLASS_FILES_TO_SOURCES);
    }

    @NotNull
    public final KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.SOURCES_TO_CLASS_FILES);
    }

    private final KtDeclaration navigateToDeclaration(KtDeclaration from, NavigationKind navigationKind) {
        KtDeclaration ktDeclaration;
        if (DumbService.isDumb((Project)from.getProject())) {
            return from;
        }
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$1[navigationKind.ordinal()]) {
            case 1: {
                if (from.getContainingKtFile().isCompiled()) break;
                return from;
            }
            case 2: {
                PsiFile file2 = from.getContainingFile();
                if (file2 instanceof KtFile && ((KtFile)file2).isCompiled()) {
                    return from;
                }
                if (!ProjectRootsUtil.isInContent((PsiElement)from, false, true, false, true, false)) {
                    return from;
                }
                if (!KtPsiUtil.isLocal((KtDeclaration)from)) break;
                return from;
            }
        }
        if ((ktDeclaration = (KtDeclaration)from.accept((KtVisitor)new SourceAndDecompiledConversionVisitor(navigationKind), (Object)Unit.INSTANCE)) == null) {
            ktDeclaration = from;
        }
        return ktDeclaration;
    }

    private SourceNavigationHelper() {
    }

    static {
        SourceNavigationHelper sourceNavigationHelper;
        INSTANCE = sourceNavigationHelper = new SourceNavigationHelper();
        Logger logger = Logger.getInstance(SourceNavigationHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Sourc\u2026gationHelper::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "", "(Ljava/lang/String;I)V", "CLASS_FILES_TO_SOURCES", "SOURCES_TO_CLASS_FILES", "kotlin.core"})
    public static final class NavigationKind
    extends Enum<NavigationKind> {
        public static final /* enum */ NavigationKind CLASS_FILES_TO_SOURCES;
        public static final /* enum */ NavigationKind SOURCES_TO_CLASS_FILES;
        private static final /* synthetic */ NavigationKind[] $VALUES;

        static {
            NavigationKind[] navigationKindArray = new NavigationKind[2];
            NavigationKind[] navigationKindArray2 = navigationKindArray;
            navigationKindArray[0] = CLASS_FILES_TO_SOURCES = new NavigationKind();
            navigationKindArray[1] = SOURCES_TO_CLASS_FILES = new NavigationKind();
            $VALUES = navigationKindArray;
        }

        public static NavigationKind[] values() {
            return (NavigationKind[])$VALUES.clone();
        }

        public static NavigationKind valueOf(String string) {
            return Enum.valueOf(NavigationKind.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "(Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;)V", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin.core"})
    private static final class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Unit> {
        private final NavigationKind navigationKind;

        @Nullable
        public KtNamedDeclaration visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)function2, this.navigationKind);
        }

        @Nullable
        public KtNamedDeclaration visitProperty(@NotNull KtProperty property2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)property2, this.navigationKind);
        }

        @Nullable
        public KtClassOrObject visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.findClassOrObject((KtClassOrObject)declaration2, this.navigationKind);
        }

        @Nullable
        public KtClassOrObject visitClass(@NotNull KtClass klass2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.findClassOrObject((KtClassOrObject)klass2, this.navigationKind);
        }

        @Nullable
        public KtTypeAlias visitTypeAlias(@NotNull KtTypeAlias typeAlias2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)typeAlias2, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (KtTypeAlias)INSTANCE.findFirstMatchingInIndex((KtNamedDeclaration)typeAlias2, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.INSTANCE);
        }

        @Nullable
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            PsiElement psiElement2 = parameter.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parameter.parent");
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            }
            KtCallableDeclaration callableDeclaration = (KtCallableDeclaration)psiElement3;
            List list2 = callableDeclaration.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callableDeclaration.valueParameters");
            List parameters2 = list2;
            int index2 = parameters2.indexOf(parameter);
            Object object = callableDeclaration.accept((KtVisitor)this, (Object)Unit.INSTANCE);
            if (!(object instanceof KtCallableDeclaration)) {
                object = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)object;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration sourceCallable = ktCallableDeclaration;
            List list3 = sourceCallable.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"sourceCallable.valueParameters");
            List sourceParameters = list3;
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return (KtDeclaration)sourceParameters.get(index2);
        }

        @Nullable
        public KtNamedDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)constructor2, this.navigationKind);
        }

        @Nullable
        public KtNamedDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)constructor2, this.navigationKind);
        }

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)navigationKind), (String)"navigationKind");
            this.navigationKind = navigationKind;
        }
    }
}

