/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinInlineFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\fJ4\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinRequestHint;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "stepSize", "", "depth", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;IILcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "myInlineFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinInlineFilter;", "doStep", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "size", "isTheSameFrame", "", "context", "kotlin.jvm-debugger.core"})
public class KotlinRequestHint
extends RequestHint {
    private final KotlinInlineFilter myInlineFilter;

    protected boolean isTheSameFrame(@NotNull SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return super.isTheSameFrame(context2) && (this.myInlineFilter == null || !this.myInlineFilter.isNestedInline(context2));
    }

    public void doStep(@NotNull DebugProcessImpl debugProcess, @Nullable SuspendContextImpl suspendContext, @Nullable ThreadReferenceProxyImpl stepThread, int size, int depth2) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (depth2 == 3) {
            KotlinStepAction action2;
            Location location2;
            StackFrameProxyImpl frameProxy;
            SuspendContextImpl suspendContextImpl = suspendContext;
            StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContextImpl != null ? suspendContextImpl.getFrameProxy() : null;
            Location location3 = location2 = stackFrameProxyImpl != null ? SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl) : null;
            if (location2 != null && (action2 = KotlinSteppingCommandProviderKt.getStepOutAction(location2, frameProxy)) != KotlinStepAction.StepOut.INSTANCE) {
                DebugProcessImpl.StepCommand command2 = action2.createCommand(debugProcess, suspendContext, false);
                RequestHint requestHint = command2.getHint(suspendContext, stepThread, (RequestHint)this);
                Intrinsics.checkNotNull((Object)requestHint);
                Intrinsics.checkNotNullExpressionValue((Object)requestHint, (String)"command.getHint(suspendC\u2026text, stepThread, this)!!");
                RequestHint hint = requestHint;
                command2.step(suspendContext, stepThread, hint);
                return;
            }
        }
        super.doStep(debugProcess, suspendContext, stepThread, size, depth2);
    }

    public KotlinRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, int stepSize, int depth2, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        super(stepThread, suspendContext, stepSize, depth2, filter2, parentHint);
        this.myInlineFilter = KotlinSteppingCommandProviderKt.createKotlinInlineFilter(suspendContext);
    }
}

