/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.InlineStackFrameVariableHolder;
import org.jetbrains.kotlin.idea.debugger.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "", "sortedVariables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "variableFrameIds", "", "currentFrameId", "", "(Ljava/util/List;[II)V", "parentFrame", "getParentFrame", "()Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "visibleVariables", "getVisibleVariables", "()Ljava/util/List;", "Companion", "kotlin.jvm-debugger.util"})
public final class InlineStackFrameVariableHolder {
    private final List<LocalVariableProxyImpl> sortedVariables;
    private final int[] variableFrameIds;
    private final int currentFrameId;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalVariableProxyImpl> getVisibleVariables() {
        List variables = new ArrayList();
        Set variableNames = new LinkedHashSet();
        for (IndexedValue indexedValue : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)this.sortedVariables))) {
            void index2;
            int n = indexedValue.component1();
            LocalVariableProxyImpl variable2 = (LocalVariableProxyImpl)indexedValue.component2();
            if (this.variableFrameIds[index2] != this.currentFrameId || variableNames.contains(variable2.name())) continue;
            Collection collection = variables;
            collection.add(variable2);
            collection = variableNames;
            String string = variable2.name();
            collection.add(string);
        }
        return CollectionsKt.reversed((Iterable)variables);
    }

    @Nullable
    public final InlineStackFrameVariableHolder getParentFrame() {
        int n;
        int n2;
        int[] parentVariableFrameIds;
        List<LocalVariableProxyImpl> parentSortedVariables;
        block6: {
            int scopeVariableIndex;
            block5: {
                int n3;
                List<LocalVariableProxyImpl> $this$indexOfLast$iv = this.sortedVariables;
                boolean $i$f$indexOfLast = false;
                ListIterator<LocalVariableProxyImpl> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    LocalVariableProxyImpl it = iterator$iv.previous();
                    boolean bl = false;
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                    if (!InlineCodegenUtilsKt.isFakeLocalVariableForInline((String)string)) continue;
                    n3 = iterator$iv.nextIndex();
                    break block5;
                }
                n3 = scopeVariableIndex = -1;
            }
            if (scopeVariableIndex < 0) {
                return null;
            }
            parentSortedVariables = this.sortedVariables.subList(0, scopeVariableIndex);
            parentVariableFrameIds = ArraysKt.sliceArray((int[])this.variableFrameIds, (IntRange)RangesKt.until((int)0, (int)scopeVariableIndex));
            List<LocalVariableProxyImpl> $this$indexOfLast$iv = parentSortedVariables;
            boolean $i$f$indexOfLast = false;
            ListIterator<LocalVariableProxyImpl> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                LocalVariableProxyImpl it = iterator$iv.previous();
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                if (!InlineCodegenUtilsKt.isFakeLocalVariableForInline((String)string)) continue;
                n2 = iterator$iv.nextIndex();
                break block6;
            }
            n2 = -1;
        }
        Integer n4 = n2;
        int it = ((Number)n4).intValue();
        boolean bl = false;
        Integer n5 = it >= 0 ? n4 : null;
        if (n5 != null) {
            n4 = n5;
            it = ((Number)n4).intValue();
            boolean bl2 = false;
            n = this.variableFrameIds[it];
        } else {
            n = 0;
        }
        int parentFrameId = n;
        return new InlineStackFrameVariableHolder(parentSortedVariables, parentVariableFrameIds, parentFrameId);
    }

    private InlineStackFrameVariableHolder(List<? extends LocalVariableProxyImpl> sortedVariables, int[] variableFrameIds, int currentFrameId) {
        this.sortedVariables = sortedVariables;
        this.variableFrameIds = variableFrameIds;
        this.currentFrameId = currentFrameId;
    }

    public /* synthetic */ InlineStackFrameVariableHolder(List sortedVariables, int[] variableFrameIds, int currentFrameId, DefaultConstructorMarker $constructor_marker) {
        this(sortedVariables, variableFrameIds, currentFrameId);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder$Companion;", "", "()V", "fromSortedVisibleVariables", "Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "sortedVariables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "fromStackFrame", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "allVisibleVariables", "kotlin.jvm-debugger.util"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final InlineStackFrameVariableHolder fromSortedVisibleVariables(List<? extends LocalVariableProxyImpl> sortedVariables) {
            int[] variableFrameIds = new int[sortedVariables.size()];
            List<Integer> activeFrames = CollectionsKt.mutableListOf((Object[])new Integer[]{0});
            List pendingVariables = new ArrayList();
            int nextFrameId = 1;
            boolean bl = false;
            for (LocalVariableProxyImpl variable2 : (Iterable)sortedVariables) {
                void currentIndex;
                Object object;
                String name2;
                String string = name2 = variable2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                int depth2 = InlineUtilsKt.getInlineDepth(string);
                if (StringsKt.startsWith$default((String)name2, (String)"$i$f$", (boolean)false, (int)2, null)) {
                    int frameId = nextFrameId++;
                    activeFrames.add(frameId);
                    Iterator iterator = pendingVariables.iterator();
                    while (iterator.hasNext()) {
                        int pending = ((Number)iterator.next()).intValue();
                        variableFrameIds[pending] = frameId;
                    }
                    pendingVariables.clear();
                    variableFrameIds[currentIndex] = frameId;
                } else if (StringsKt.startsWith$default((String)name2, (String)"$i$a$", (boolean)false, (int)2, null)) {
                    object = pendingVariables.iterator();
                    while (object.hasNext()) {
                        int pending = ((Number)object.next()).intValue();
                        variableFrameIds[pending] = -1;
                    }
                    pendingVariables.clear();
                    if (depth2 + 1 < activeFrames.size()) {
                        activeFrames = activeFrames.subList(0, depth2 + 1);
                    }
                    variableFrameIds[currentIndex] = ((Number)CollectionsKt.last((List)activeFrames)).intValue();
                } else if (depth2 < activeFrames.size()) {
                    variableFrameIds[currentIndex] = ((Number)activeFrames.get(depth2)).intValue();
                } else if (depth2 == activeFrames.size()) {
                    Collection collection = pendingVariables;
                    object = (int)currentIndex;
                    collection.add(object);
                } else {
                    variableFrameIds[currentIndex] = -1;
                }
                ++currentIndex;
            }
            return new InlineStackFrameVariableHolder(sortedVariables, variableFrameIds, ((Number)CollectionsKt.last((List)activeFrames)).intValue(), null);
        }

        @NotNull
        public final InlineStackFrameVariableHolder fromStackFrame(@NotNull StackFrameProxyImpl frame) {
            List<LocalVariable> allVariables;
            List<LocalVariable> list2;
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            VirtualMachineProxyImpl virtualMachineProxyImpl = frame.getVirtualMachine();
            Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"frame.virtualMachine");
            if (NoStrataPositionManagerHelperKt.isDexDebug(virtualMachineProxyImpl.getVirtualMachine())) {
                Method method = frame.location().method();
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"frame.location().method()");
                list2 = SafeUtilKt.safeVariables(method);
            } else {
                list2 = allVariables = null;
            }
            if (allVariables == null) {
                Iterable $this$sortedBy$iv = this.allVisibleVariables(frame);
                boolean $i$f$sortedBy = false;
                List sortedVariables = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        LocalVariableProxyImpl it = (LocalVariableProxyImpl)a;
                        boolean bl = false;
                        Comparable comparable = it.getVariable();
                        it = (LocalVariableProxyImpl)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        LocalVariable localVariable = it.getVariable();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)localVariable);
                    }
                });
                return this.fromSortedVisibleVariables(sortedVariables);
            }
            Map startOffsets = new LinkedHashMap();
            Map replacements = new LinkedHashMap();
            for (LocalVariable variable2 : allVariables) {
                Object object = DebuggerUtils.INSTANCE.getBorders(variable2);
                if (object == null || (object = (Location)object.getStart()) == null) {
                    continue;
                }
                Object startOffset = object;
                Collection collection = (List)startOffsets.computeIfAbsent(startOffset.codeIndex(), fromStackFrame.1.INSTANCE);
                collection.add(variable2);
            }
            for (LocalVariable variable2 : allVariables) {
                List otherVariables;
                Object object = DebuggerUtils.INSTANCE.getBorders(variable2);
                if (object == null || (object = (Location)object.getEndInclusive()) == null) {
                    continue;
                }
                Object endOffset2 = object;
                if ((List)startOffsets.get(endOffset2.codeIndex() + 1L) == null) {
                    continue;
                }
                for (LocalVariable other : otherVariables) {
                    if (!Intrinsics.areEqual((Object)variable2.name(), (Object)other.name()) || !Intrinsics.areEqual((Object)variable2.type(), (Object)other.type())) continue;
                    replacements.put(other, variable2);
                }
            }
            Iterable $this$sortedBy$iv = this.allVisibleVariables(frame);
            boolean $i$f$sortedBy = false;
            List sortedVariables = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(replacements){
                final /* synthetic */ Map $replacements$inlined;
                {
                    this.$replacements$inlined = map2;
                }

                public final int compare(T a, T b) {
                    LocalVariableProxyImpl proxy = (LocalVariableProxyImpl)a;
                    boolean bl = false;
                    LocalVariable variable2 = proxy.getVariable();
                    while (true) {
                        if ((LocalVariable)this.$replacements$inlined.get(variable2) != null) continue;
                        break;
                    }
                    proxy = (LocalVariableProxyImpl)b;
                    Comparable comparable = variable2;
                    bl = false;
                    variable2 = proxy.getVariable();
                    while (true) {
                        if ((LocalVariable)this.$replacements$inlined.get(variable2) != null) continue;
                        break;
                    }
                    LocalVariable localVariable = variable2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)localVariable);
                }
            });
            return this.fromSortedVisibleVariables(sortedVariables);
        }

        /*
         * WARNING - void declaration
         */
        private final List<LocalVariableProxyImpl> allVisibleVariables(StackFrameProxyImpl $this$allVisibleVariables) {
            List list2;
            Method method = $this$allVisibleVariables.location().method();
            if (Intrinsics.areEqual((Object)$this$allVisibleVariables.getStackFrame().location().method(), (Object)method) ^ true) {
                return CollectionsKt.emptyList();
            }
            Method method2 = method;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
            List<LocalVariable> list3 = SafeUtilKt.safeVariables(method2);
            if (list3 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list3;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    LocalVariableProxyImpl localVariableProxyImpl;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    LocalVariable variable2 = (LocalVariable)element$iv$iv;
                    boolean bl2 = false;
                    LocalVariableProxyImpl localVariableProxyImpl2 = variable2.isVisible($this$allVisibleVariables.getStackFrame()) ? new LocalVariableProxyImpl($this$allVisibleVariables, variable2) : null;
                    if (localVariableProxyImpl2 == null) continue;
                    LocalVariableProxyImpl it$iv$iv = localVariableProxyImpl = localVariableProxyImpl2;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

